/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.Layer;
import org.openstreetmap.gui.jmapviewer.MapObjectImpl;
import org.openstreetmap.gui.jmapviewer.Style;
import org.openstreetmap.gui.jmapviewer.interfaces.MapRectangle;

public class MapRectangleImpl
extends MapObjectImpl
implements MapRectangle {
    private Coordinate topLeft;
    private Coordinate bottomRight;

    public MapRectangleImpl(Coordinate coordinate, Coordinate coordinate2) {
        this(null, null, coordinate, coordinate2);
    }

    public MapRectangleImpl(String string, Coordinate coordinate, Coordinate coordinate2) {
        this(null, string, coordinate, coordinate2);
    }

    public MapRectangleImpl(Layer layer, Coordinate coordinate, Coordinate coordinate2) {
        this(layer, null, coordinate, coordinate2);
    }

    public MapRectangleImpl(Layer layer, String string, Coordinate coordinate, Coordinate coordinate2) {
        this(layer, string, coordinate, coordinate2, MapRectangleImpl.getDefaultStyle());
    }

    public MapRectangleImpl(Layer layer, String string, Coordinate coordinate, Coordinate coordinate2, Style style) {
        super(layer, string, style);
        this.topLeft = coordinate;
        this.bottomRight = coordinate2;
    }

    @Override
    public Coordinate getTopLeft() {
        return this.topLeft;
    }

    @Override
    public Coordinate getBottomRight() {
        return this.bottomRight;
    }

    @Override
    public void paint(Graphics graphics, Point point, Point point2) {
        Color color = graphics.getColor();
        graphics.setColor(this.getColor());
        Stroke stroke = null;
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            stroke = graphics2D.getStroke();
            graphics2D.setStroke(this.getStroke());
        }
        graphics.drawRect(point.x, point.y, point2.x - point.x, point2.y - point.y);
        graphics.setColor(color);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setStroke(stroke);
        }
        int n = point2.x - point.x;
        int n2 = point2.y - point.y;
        Point point3 = new Point(point.x + n / 2, point.y + n2 / 2);
        if (this.getLayer() == null || this.getLayer().isVisibleTexts().booleanValue()) {
            this.paintText(graphics, point3);
        }
    }

    public static Style getDefaultStyle() {
        return new Style(Color.BLUE, null, new BasicStroke(2.0f), MapRectangleImpl.getDefaultFont());
    }

    public String toString() {
        return "MapRectangle from " + this.getTopLeft() + " to " + this.getBottomRight();
    }
}

