/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadClassVariableNode
extends RubyNode {
    private final String name;
    private final LexicalScope lexicalScope;

    public ReadClassVariableNode(RubyContext context, SourceSection sourceSection, String name, LexicalScope lexicalScope) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalScope = lexicalScope;
    }

    public static DynamicObject resolveTargetModule(LexicalScope lexicalScope) {
        while (RubyGuards.isRubyClass(lexicalScope.getLiveModule()) && Layouts.CLASS.getIsSingleton(lexicalScope.getLiveModule())) {
            lexicalScope = lexicalScope.getParent();
        }
        return lexicalScope.getLiveModule();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        DynamicObject module = ReadClassVariableNode.resolveTargetModule(this.lexicalScope);
        assert (RubyGuards.isRubyModule(module));
        Object value = ModuleOperations.lookupClassVariable(module, this.name);
        if (value == null) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedClassVariable(module, this.name, this));
        }
        return value;
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        DynamicObject module = ReadClassVariableNode.resolveTargetModule(this.lexicalScope);
        Object value = ModuleOperations.lookupClassVariable(module, this.name);
        if (value == null) {
            return this.nil();
        }
        return this.create7BitString(StringOperations.encodeByteList("class variable", (Encoding)UTF8Encoding.INSTANCE));
    }
}

