/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.StringSupport;

public class SymbolCodeRangeableWrapper
implements CodeRangeable {
    private final DynamicObject symbol;

    public SymbolCodeRangeableWrapper(DynamicObject symbol) {
        this.symbol = symbol;
    }

    public String toString() {
        return Layouts.SYMBOL.getString(this.symbol);
    }

    public int getCodeRange() {
        return Layouts.SYMBOL.getCodeRange(this.symbol);
    }

    @CompilerDirectives.TruffleBoundary
    public int scanForCodeRange() {
        ByteList byteList = Layouts.SYMBOL.getByteList(this.symbol);
        int cr = Layouts.SYMBOL.getCodeRange(this.symbol);
        if (cr == 0) {
            cr = StringSupport.codeRangeScan((Encoding)byteList.getEncoding(), (ByteList)byteList);
            Layouts.SYMBOL.setCodeRange(this.symbol, cr);
        }
        return cr;
    }

    public boolean isCodeRangeValid() {
        return Layouts.SYMBOL.getCodeRange(this.symbol) == 32;
    }

    public void setCodeRange(int codeRange) {
        Layouts.SYMBOL.setCodeRange(this.symbol, codeRange);
    }

    public void clearCodeRange() {
        Layouts.SYMBOL.setCodeRange(this.symbol, 0);
    }

    public void keepCodeRange() {
        if (Layouts.SYMBOL.getCodeRange(this.symbol) == 48) {
            Layouts.SYMBOL.setCodeRange(this.symbol, 0);
        }
    }

    public void modify() {
        throw new UnsupportedOperationException();
    }

    public void modify(int length) {
        throw new UnsupportedOperationException();
    }

    public void modifyAndKeepCodeRange() {
        throw new UnsupportedOperationException();
    }

    public Encoding checkEncoding(CodeRangeable other) {
        return Layouts.SYMBOL.getByteList(this.symbol).getEncoding();
    }

    public ByteList getByteList() {
        return Layouts.SYMBOL.getByteList(this.symbol);
    }
}

