/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;

public class COSInteger
extends COSNumber {
    private final int value;

    public static COSInteger create(byte[] byArray, int n, int n2) {
        int n3 = 0;
        int n4 = n + n2;
        boolean bl = false;
        byte by = byArray[n];
        if (by == 43) {
            ++n;
        } else if (by == 45) {
            bl = true;
            ++n;
        }
        int n5 = n;
        while (n5 < n4) {
            n3 = n3 * 10 + byArray[n5] - 48;
            ++n5;
        }
        if (bl) {
            return new COSInteger(-n3);
        }
        return new COSInteger(n3);
    }

    public static COSInteger create(int n) {
        return new COSInteger(n);
    }

    public static COSInteger createStrict(byte[] byArray, int n, int n2) {
        long l = 0L;
        int n3 = n + n2;
        boolean bl = false;
        byte by = byArray[n];
        if (by == 43) {
            ++n;
        } else if (by == 45) {
            bl = true;
            ++n;
        }
        int n4 = n;
        while (n4 < n3) {
            l = l * 10L + (long)byArray[n4] - 48L;
            ++n4;
        }
        if (l > Integer.MAX_VALUE || l < Integer.MIN_VALUE) {
            return null;
        }
        n4 = (int)l;
        if (bl) {
            return new COSInteger(-n4);
        }
        return new COSInteger(n4);
    }

    protected COSInteger(int n) {
        this.value = n;
    }

    @Override
    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromInteger(this);
    }

    @Override
    public COSInteger asInteger() {
        return this;
    }

    @Override
    protected String basicToString() {
        return String.valueOf(this.intValue());
    }

    @Override
    protected COSObject copyBasic() {
        return new COSInteger(this.value);
    }

    public boolean equals(Object object) {
        if (!(object instanceof COSInteger)) {
            return false;
        }
        return this.value == ((COSInteger)object).intValue();
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public Object saveState() {
        COSInteger cOSInteger = new COSInteger(this.value);
        cOSInteger.container = this.container.saveStateContainer();
        return cOSInteger;
    }
}

