/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.crypt.AESCryptHandler;
import de.intarsys.pdf.crypt.ArcFourCryptHandler;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ICryptHandler;
import de.intarsys.pdf.crypt.IdentityCryptHandler;
import de.intarsys.pdf.crypt.StandardCryptHandler;
import de.intarsys.pdf.crypt.SystemSecurityHandler;
import de.intarsys.pdf.filter.Filter;
import java.util.HashMap;
import java.util.Map;

public class SystemSecurityHandlerV4
extends SystemSecurityHandler {
    public static final COSName CN_AESV2 = COSName.constant("AESV2");
    public static final COSName CN_CryptFilter = COSName.constant("CryptFilter");
    public static final COSName CN_None = COSName.constant("None");
    public static final COSName CN_V2 = COSName.constant("V2");
    public static final COSName DK_CFM = COSName.constant("CFM");
    public static final COSName DK_NAME = COSName.constant("Name");
    public static final COSName DK_TYPE = COSName.constant("Type");
    private Map<COSName, ICryptHandler> cryptHandlers = new HashMap<COSName, ICryptHandler>();

    protected SystemSecurityHandlerV4(COSDictionary cOSDictionary) {
        super(cOSDictionary);
    }

    public void cosAddCryptFilter(COSName cOSName, COSDictionary cOSDictionary) {
        COSDictionary cOSDictionary2 = this.cosGetEncryption();
        COSDictionary cOSDictionary3 = cOSDictionary2.get(COSEncryption.DK_CF).asDictionary();
        if (cOSDictionary3 == null) {
            cOSDictionary3 = COSDictionary.create();
            cOSDictionary2.put(COSEncryption.DK_CF, cOSDictionary3);
        }
        cOSDictionary3.put(cOSName, cOSDictionary);
    }

    public COSDictionary cosGetCryptFilters() {
        COSDictionary cOSDictionary = this.cosGetEncryption();
        return cOSDictionary.get(COSEncryption.DK_CF).asDictionary();
    }

    public void cosRemoveCryptFilter(COSName cOSName) {
        COSDictionary cOSDictionary = this.cosGetEncryption();
        COSDictionary cOSDictionary2 = cOSDictionary.get(COSEncryption.DK_CF).asDictionary();
        if (cOSDictionary2 == null) {
            return;
        }
        cOSDictionary2.remove(cOSName);
    }

    protected COSDictionary createCryptFilterAES() {
        COSDictionary cOSDictionary = COSDictionary.create();
        cOSDictionary.put(DK_TYPE, CN_CryptFilter);
        cOSDictionary.put(DK_CFM, CN_AESV2);
        cOSDictionary.put(COSEncryption.DK_Length, COSInteger.create(128));
        return cOSDictionary;
    }

    protected COSDictionary createCryptFilterArcFour() {
        COSDictionary cOSDictionary = COSDictionary.create();
        cOSDictionary.put(DK_TYPE, CN_CryptFilter);
        cOSDictionary.put(DK_CFM, CN_V2);
        cOSDictionary.put(COSEncryption.DK_Length, COSInteger.create(128));
        return cOSDictionary;
    }

    protected COSDictionary createCryptFilterNone() {
        COSDictionary cOSDictionary = COSDictionary.create();
        cOSDictionary.put(DK_TYPE, CN_CryptFilter);
        cOSDictionary.put(DK_CFM, CN_None);
        cOSDictionary.put(COSEncryption.DK_Length, COSInteger.create(128));
        return cOSDictionary;
    }

    protected ICryptHandler createCryptHandler(COSName cOSName) throws COSSecurityException {
        if (COSEncryption.CN_IDENTITY.equals(cOSName)) {
            return new IdentityCryptHandler();
        }
        COSDictionary cOSDictionary = this.getEncryption().getCryptFilterDict(cOSName);
        if (cOSDictionary == null) {
            return new IdentityCryptHandler();
        }
        COSName cOSName2 = cOSDictionary.get(DK_CFM).asName();
        if (CN_V2.equals(cOSName2)) {
            ArcFourCryptHandler arcFourCryptHandler = new ArcFourCryptHandler();
            ((StandardCryptHandler)arcFourCryptHandler).initialize(this.getSecurityHandler().getCryptKey());
            return arcFourCryptHandler;
        }
        if (CN_AESV2.equals(cOSName2)) {
            AESCryptHandler aESCryptHandler = new AESCryptHandler();
            ((StandardCryptHandler)aESCryptHandler).initialize(this.getSecurityHandler().getCryptKey());
            return aESCryptHandler;
        }
        return this.getSecurityHandler();
    }

    @Override
    public byte[] decryptFile(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        COSName cOSName = this.getEncryption().getCryptFilterNameFile();
        ICryptHandler iCryptHandler = this.getCryptHandler(cOSName);
        byte[] byArray2 = iCryptHandler.decrypt(cOSObjectKey, byArray);
        return byArray2;
    }

    @Override
    public byte[] decryptStream(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        Object object;
        Object object2;
        Object object3 = COSEncryption.CN_IDENTITY;
        if (COSStream.hasFilter(cOSDictionary, Filter.CN_Filter_Crypt)) {
            object2 = COSStream.getDecodeParams(cOSDictionary, Filter.CN_Filter_Crypt);
            if (object2 != null && (object = ((COSDictionary)object2).get(DK_NAME).asName()) != null) {
                object3 = object;
            }
        } else {
            object3 = this.getEncryption().getCryptFilterNameString();
        }
        object2 = this.getCryptHandler((COSName)object3);
        object = object2.decrypt(cOSObjectKey, byArray);
        return object;
    }

    @Override
    public byte[] decryptString(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        COSName cOSName = this.getEncryption().getCryptFilterNameString();
        ICryptHandler iCryptHandler = this.getCryptHandler(cOSName);
        return iCryptHandler.decrypt(cOSObjectKey, byArray);
    }

    @Override
    public byte[] encryptFile(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        COSName cOSName = this.getEncryption().getCryptFilterNameFile();
        ICryptHandler iCryptHandler = this.getCryptHandler(cOSName);
        byte[] byArray2 = iCryptHandler.encrypt(cOSObjectKey, byArray);
        return byArray2;
    }

    @Override
    public byte[] encryptStream(COSObjectKey cOSObjectKey, COSDictionary cOSDictionary, byte[] byArray) throws COSSecurityException {
        Object object;
        Object object2;
        if (!this.isEnabled()) {
            return byArray;
        }
        Object object3 = COSEncryption.CN_IDENTITY;
        if (COSStream.hasFilter(cOSDictionary, Filter.CN_Filter_Crypt)) {
            object2 = COSStream.getDecodeParams(cOSDictionary, Filter.CN_Filter_Crypt);
            if (object2 != null && (object = ((COSDictionary)object2).get(DK_NAME).asName()) != null) {
                object3 = object;
            }
        } else {
            object3 = this.getEncryption().getCryptFilterNameString();
        }
        object2 = this.getCryptHandler((COSName)object3);
        object = object2.encrypt(cOSObjectKey, byArray);
        return object;
    }

    @Override
    public byte[] encryptString(COSObjectKey cOSObjectKey, byte[] byArray) throws COSSecurityException {
        if (!this.isEnabled()) {
            return byArray;
        }
        COSName cOSName = this.getEncryption().getCryptFilterNameString();
        ICryptHandler iCryptHandler = this.getCryptHandler(cOSName);
        return iCryptHandler.encrypt(cOSObjectKey, byArray);
    }

    public ICryptHandler getCryptHandler(COSName cOSName) throws COSSecurityException {
        ICryptHandler iCryptHandler = this.cryptHandlers.get(cOSName);
        if (iCryptHandler == null) {
            iCryptHandler = this.createCryptHandler(cOSName);
            this.cryptHandlers.put(cOSName, iCryptHandler);
        }
        return iCryptHandler;
    }

    @Override
    public int getLength() {
        return 128;
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        COSEncryption cOSEncryption = this.getEncryption();
        cOSEncryption.setFieldInt(COSEncryption.DK_Length, 128);
        COSName cOSName = COSName.constant("StdCF");
        this.setEncryptionMethodAES(cOSName);
        this.setEncryptionFilterStream(cOSName);
        this.setEncryptionFilterString(cOSName);
        this.setEncryptMetadata(true);
    }

    public void setEncryptionFilterStream(COSName cOSName) {
        COSDictionary cOSDictionary = this.cosGetEncryption();
        cOSDictionary.put(COSEncryption.DK_StmF, cOSName);
    }

    public void setEncryptionFilterString(COSName cOSName) {
        COSDictionary cOSDictionary = this.cosGetEncryption();
        cOSDictionary.put(COSEncryption.DK_StrF, cOSName);
    }

    public void setEncryptionMethodAES(COSName cOSName) {
        this.cosAddCryptFilter(cOSName, this.createCryptFilterAES());
    }

    public void setEncryptionMethodArcFour(COSName cOSName) {
        this.cosAddCryptFilter(cOSName, this.createCryptFilterArcFour());
    }

    public void setEncryptionMethodNone(COSName cOSName) {
        this.cosAddCryptFilter(cOSName, this.createCryptFilterNone());
    }

    public void setEncryptMetadata(boolean bl) {
        COSDictionary cOSDictionary = this.cosGetEncryption();
        cOSDictionary.put(COSEncryption.DK_EncryptMetadata, COSBoolean.create(bl));
    }
}

