/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.encoding.Encoding;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class MappedWriter
extends Writer {
    private Encoding encoding;
    private OutputStream outStream;

    public MappedWriter(OutputStream outputStream, Encoding encoding) {
        super(outputStream);
        this.setOutStream(outputStream);
        this.setEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.outStream == null) {
                return;
            }
            this.flush();
            this.outStream.close();
            this.outStream = null;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.outStream == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.outStream.flush();
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    protected OutputStream getOutStream() {
        return this.outStream;
    }

    private void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    private void setOutStream(OutputStream outputStream) {
        this.outStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return;
            }
            int n3 = n + n2;
            int n4 = n;
            while (n4 < n3) {
                this.encoding.putNextDecoded(this.outStream, cArray[n4]);
                ++n4;
            }
        }
    }
}

