/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.GlyphNameMap;

public class AFMEncoding
extends Encoding {
    private final AFM afm;

    public AFMEncoding(AFM aFM) {
        this.afm = aFM;
    }

    @Override
    public COSObject cosGetObject() {
        return null;
    }

    public AFM getAfm() {
        return this.afm;
    }

    @Override
    public int getDecoded(int n) {
        String string = this.getGlyphName(n);
        if (string == null) {
            return -1;
        }
        return GlyphNameMap.Standard.getUnicode(string);
    }

    @Override
    public int getEncoded(int n) {
        String string = GlyphNameMap.Standard.getGlyphName(n);
        return this.getEncoded(string);
    }

    @Override
    public int getEncoded(String string) {
        AFMChar aFMChar = this.getAfm().getCharByName(string);
        if (aFMChar != null) {
            return aFMChar.getCode();
        }
        return -1;
    }

    @Override
    public String getGlyphName(int n) {
        AFMChar aFMChar = this.getAfm().getCharByCode(n);
        if (aFMChar != null) {
            return aFMChar.getName();
        }
        return ".notdef";
    }

    @Override
    public String getName() {
        return "AFMEncoding";
    }
}

