/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cds.CDSNameTreeEntry;
import de.intarsys.pdf.cds.CDSNameTreeNode;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.crypt.AccessPermissionsTools;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDActionGoTo;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDApplicationData;
import de.intarsys.pdf.pd.PDCollection;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutputIntent;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PDDocument
implements IAdditionalActionSupport,
IAttributeSupport,
ILocatorSupport {
    public static final Set CATALOG_ACTION_TRIGGERS;
    public static final COSName CN_Perms_DocMDP;
    public static final COSName CN_Perms_UR;
    public static final COSName DK_OpenAction;
    public static final COSName DK_Perms;
    public static final COSName DK_Legal;
    private IAccessPermissions accessPermissions;
    private final COSDocument cosDoc;

    static {
        CN_Perms_DocMDP = COSName.constant("DocMDP");
        CN_Perms_UR = COSName.constant("UR");
        DK_OpenAction = COSName.constant("OpenAction");
        DK_Perms = COSName.constant("Perms");
        DK_Legal = COSName.constant("Legal");
        CATALOG_ACTION_TRIGGERS = new HashSet(6);
        CATALOG_ACTION_TRIGGERS.add("DC");
        CATALOG_ACTION_TRIGGERS.add("WS");
        CATALOG_ACTION_TRIGGERS.add("DS");
        CATALOG_ACTION_TRIGGERS.add("WP");
        CATALOG_ACTION_TRIGGERS.add("DP");
    }

    public static PDDocument createFromCos(COSDocument cOSDocument) {
        PDDocument pDDocument = (PDDocument)cOSDocument.getAttribute(PDDocument.class);
        if (pDDocument == null) {
            pDDocument = new PDDocument(cOSDocument);
            pDDocument.initializeFromCos();
            pDDocument.checkConsistency();
            cOSDocument.setAttribute(PDDocument.class, pDDocument);
        }
        return pDDocument;
    }

    public static PDDocument createFromLocator(ILocator iLocator) throws IOException, COSLoadException {
        return PDDocument.createFromLocator(iLocator, null);
    }

    public static PDDocument createFromLocator(ILocator iLocator, Map map) throws IOException, COSLoadException {
        return PDDocument.createFromCos(COSDocument.createFromLocator(iLocator, map));
    }

    public static PDDocument createNew() {
        PDDocument pDDocument = new PDDocument();
        pDDocument.initializeFromScratch();
        pDDocument.setAttribute(PDDocument.class, pDDocument);
        return pDDocument;
    }

    protected PDDocument() {
        this(COSDocument.createNew());
    }

    protected PDDocument(COSDocument cOSDocument) {
        this.cosDoc = cOSDocument;
    }

    public void addAction(PDAction pDAction) {
        this.addOpenAction(pDAction);
    }

    public void addDestination(String string, COSObject cOSObject) {
        COSCatalog cOSCatalog = this.getCatalog();
        COSDictionary cOSDictionary = cOSCatalog.cosGetDests();
        if (cOSDictionary == null) {
            cOSDictionary = COSDictionary.create();
            cOSCatalog.cosSetDests(cOSDictionary);
        }
        cOSDictionary.put(COSName.createUTF8(string), cOSObject);
    }

    public void addOpenAction(PDAction pDAction) {
        if (pDAction == null) {
            return;
        }
        if (this.getOpenAction() != null) {
            this.getOpenAction().addNext(pDAction);
        } else {
            this.setOpenAction(pDAction);
        }
    }

    public void addPageNode(PDPageNode pDPageNode) {
        this.getPageTree().addNode(pDPageNode);
    }

    public void addPageNodeAfter(PDPageNode pDPageNode, PDPageNode pDPageNode2) {
        if (pDPageNode2 == null) {
            this.getPageTree().addNode(pDPageNode);
        } else {
            pDPageNode2.getParent().addNodeAfter(pDPageNode, pDPageNode2);
        }
    }

    protected void checkConsistency() throws COSRuntimeException {
        if (this.getCatalog() == null) {
            throw new COSRuntimeException("Catalog missing");
        }
        if (this.getPageTree() == null) {
            throw new COSRuntimeException("Page tree missing");
        }
    }

    public void close() throws IOException {
        this.cosDoc.close();
    }

    protected void collectAnnotations(List list) {
        this.getPageTree().collectAnnotations(list);
    }

    public PDDocument copyDeep() {
        return PDDocument.createFromCos(this.cosGetDoc().copyDeep());
    }

    public COSDocument cosGetDoc() {
        return this.cosDoc;
    }

    public COSDictionary cosGetPermissionsDict() {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return null;
        }
        return cOSCatalog.cosGetField(DK_Perms).asDictionary();
    }

    public COSDictionary cosGetPieceInfoDict() {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return null;
        }
        return cOSCatalog.cosGetField(COSCatalog.DK_PieceInfo).asDictionary();
    }

    public COSDictionary cosGetURI() {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return null;
        }
        return cOSCatalog.cosGetField(COSCatalog.DK_URI).asDictionary();
    }

    public void cosSetPermissionsDict(COSDictionary cOSDictionary) {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return;
        }
        cOSDictionary.beIndirect();
        cOSCatalog.cosSetField(DK_Perms, cOSDictionary);
    }

    public void cosSetPieceInfoDict(COSDictionary cOSDictionary) {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return;
        }
        cOSDictionary.beIndirect();
        cOSCatalog.cosSetField(COSCatalog.DK_PieceInfo, cOSDictionary);
    }

    public PDAcroForm createAcroForm() {
        if (this.getAcroForm() != null) {
            throw new IllegalStateException("AcroForm already available");
        }
        PDAcroForm pDAcroForm = (PDAcroForm)PDAcroForm.META.createNew();
        PDResources pDResources = (PDResources)PDResources.META.createNew();
        pDAcroForm.setDefaultResources(pDResources);
        this.setAcroForm(pDAcroForm);
        return pDAcroForm;
    }

    public PDPageTree createPageTree() {
        PDPageTree pDPageTree = (PDPageTree)PDPageTree.META.createNew();
        return pDPageTree;
    }

    public IAccessPermissions getAccessPermissions() {
        if (this.accessPermissions == null) {
            this.accessPermissions = AccessPermissionsTools.createPermissions(this);
        }
        return this.accessPermissions;
    }

    public PDAcroForm getAcroForm() {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return null;
        }
        return (PDAcroForm)PDAcroForm.META.createFromCos(cOSCatalog.cosGetField(COSCatalog.DK_AcroForm));
    }

    @Override
    public PDAdditionalActions getAdditionalActions() {
        COSDictionary cOSDictionary = null;
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog != null) {
            cOSDictionary = cOSCatalog.cosGetField(DK_AA).asDictionary();
        }
        return (PDAdditionalActions)PDAdditionalActions.META.createFromCos(cOSDictionary);
    }

    public List getAnnotations() {
        ArrayList arrayList = new ArrayList();
        this.collectAnnotations(arrayList);
        return arrayList;
    }

    public PDApplicationData getApplicationData(String string) {
        COSDictionary cOSDictionary = this.cosGetPieceInfoDict();
        if (cOSDictionary == null) {
            return null;
        }
        COSName cOSName = COSName.createUTF8(string);
        COSDictionary cOSDictionary2 = cOSDictionary.get(cOSName).asDictionary();
        if (cOSDictionary2 == null) {
            return null;
        }
        return (PDApplicationData)PDApplicationData.META.createFromCos(cOSDictionary2);
    }

    public final Object getAttribute(Object object) {
        return this.cosDoc.getAttribute(object);
    }

    public String getAuthor() {
        return this.getDocumentInfoString(COSInfoDict.DK_Author);
    }

    public COSCatalog getCatalog() {
        return this.cosGetDoc().getCatalog();
    }

    public PDCollection getCollection() {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return null;
        }
        return (PDCollection)PDCollection.META.createFromCos(cOSCatalog.cosGetField(COSCatalog.DK_Collection));
    }

    public CDSDate getCreationDate() {
        if (this.getInfoDict() == null) {
            return null;
        }
        return this.getInfoDict().getCreationDate();
    }

    public String getCreationDateString() {
        return this.getDocumentInfoString(COSInfoDict.DK_CreationDate);
    }

    public String getCreator() {
        return this.getDocumentInfoString(COSInfoDict.DK_Creator);
    }

    public List<String> getDestinationNames() {
        COSObject cOSObject;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        COSDictionary cOSDictionary = this.getCatalog().cosGetDests();
        if (cOSDictionary != null) {
            object = cOSDictionary.keySet().iterator();
            while (object.hasNext()) {
                cOSObject = (COSName)object.next();
                arrayList.add(((COSName)cOSObject).stringValue());
            }
        }
        if ((object = this.getCatalog().cosGetNames()) != null && (cOSObject = ((COSDictionary)object).get(COSCatalog.DK_Dests).asDictionary()) != null) {
            CDSNameTreeNode cDSNameTreeNode = CDSNameTreeNode.createFromCos((COSDictionary)cOSObject);
            Iterator iterator = cDSNameTreeNode.iterator();
            while (iterator.hasNext()) {
                CDSNameTreeEntry cDSNameTreeEntry = (CDSNameTreeEntry)iterator.next();
                arrayList.add(cDSNameTreeEntry.getName().stringValue());
            }
        }
        return arrayList;
    }

    protected String getDocumentInfoString(COSName cOSName) {
        COSInfoDict cOSInfoDict = this.cosGetDoc().getInfoDict();
        if (cOSInfoDict == null) {
            return null;
        }
        COSObject cOSObject = cOSInfoDict.cosGetField(cOSName);
        return cOSObject.isNull() ? null : cOSObject.stringValue();
    }

    public COSInfoDict getInfoDict() {
        return this.cosGetDoc().getInfoDict();
    }

    public String getKeywords() {
        return this.getDocumentInfoString(COSInfoDict.DK_Keywords);
    }

    public ILocator getLocator() {
        return this.cosDoc.getLocator();
    }

    public String getMetadata() {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return null;
        }
        COSStream cOSStream = cOSCatalog.cosGetField(COSCatalog.DK_Metadata).asStream();
        if (cOSStream == null) {
            return null;
        }
        byte[] byArray = cOSStream.getEncodedBytes();
        return new String(byArray);
    }

    public CDSDate getModDate() {
        if (this.getInfoDict() == null) {
            return null;
        }
        return this.getInfoDict().getModDate();
    }

    public String getModDateString() {
        return this.getDocumentInfoString(COSInfoDict.DK_ModDate);
    }

    public String getName() {
        return this.cosDoc.getName();
    }

    public PDAction getOpenAction() {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return null;
        }
        COSObject cOSObject = cOSCatalog.cosGetField(DK_OpenAction);
        if (cOSObject.isNull()) {
            return null;
        }
        if (cOSObject instanceof COSDictionary) {
            return (PDAction)PDAction.META.createFromCos(cOSObject);
        }
        if (cOSObject instanceof COSArray) {
            return (PDAction)PDActionGoTo.META.createFromCos(cOSObject);
        }
        return null;
    }

    public PDOutline getOutline() {
        return (PDOutline)PDOutline.META.createFromCos(this.getCatalog().cosGetOutline());
    }

    public PDOutputIntent getOutputIntent(COSName cOSName) {
        List list = this.getOutputIntents();
        if (list != null) {
            for (PDOutputIntent pDOutputIntent : list) {
                COSObject cOSObject = pDOutputIntent.cosGetField(PDOutputIntent.DK_S);
                if (cOSObject == null || !cOSObject.equals(cOSName)) continue;
                return pDOutputIntent;
            }
        }
        return null;
    }

    public List getOutputIntents() {
        COSArray cOSArray = null;
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog != null && (cOSArray = cOSCatalog.cosGetField(COSCatalog.DK_OutputIntents).asArray()) != null) {
            ArrayList<COSBasedObject> arrayList = new ArrayList<COSBasedObject>();
            Iterator iterator = cOSArray.iterator();
            while (iterator.hasNext()) {
                COSBasedObject cOSBasedObject = PDOutputIntent.META.createFromCos((COSObject)iterator.next());
                if (cOSBasedObject == null) continue;
                arrayList.add(cOSBasedObject);
            }
            return arrayList;
        }
        return null;
    }

    public PDPageTree getPageTree() {
        return (PDPageTree)PDPageNode.META.createFromCos(this.getCatalog().cosGetField(COSCatalog.DK_Pages));
    }

    public PDSignature getPermissions(COSName cOSName) {
        COSDictionary cOSDictionary = this.cosGetPermissionsDict();
        if (cOSDictionary == null) {
            return null;
        }
        COSDictionary cOSDictionary2 = cOSDictionary.get(cOSName).asDictionary();
        if (cOSDictionary2 == null) {
            return null;
        }
        return (PDSignature)PDSignature.META.createFromCos(cOSDictionary2);
    }

    public String getProducer() {
        return this.getDocumentInfoString(COSInfoDict.DK_Producer);
    }

    public String getSubject() {
        return this.getDocumentInfoString(COSInfoDict.DK_Subject);
    }

    @Override
    public Set getSupportedTriggerEvents() {
        return CATALOG_ACTION_TRIGGERS;
    }

    public String getTitle() {
        return this.getDocumentInfoString(COSInfoDict.DK_Title);
    }

    public String getTrapped() {
        if (this.getInfoDict() == null) {
            return null;
        }
        return this.getInfoDict().getTrapped();
    }

    public EnumWriteMode getWriteModeHint() {
        return this.cosDoc.getWriteModeHint();
    }

    protected void initializeFromCos() {
    }

    protected void initializeFromScratch() {
        PDPageTree pDPageTree = (PDPageTree)PDPageTree.META.createNew();
        this.cosDoc.getCatalog().cosSetField(COSCatalog.DK_Pages, pDPageTree.cosGetObject());
    }

    public boolean isAppendOnly() {
        if (this.getAcroForm() == null) {
            return false;
        }
        return this.getAcroForm().getSigFlags().isAppendOnly();
    }

    public boolean isDirty() {
        return this.cosDoc.isDirty();
    }

    public boolean isEncrypted() {
        return this.cosDoc.isEncrypted();
    }

    public boolean isNew() {
        return this.cosDoc.isNew();
    }

    public boolean isPreferIncrementalSave() {
        if (this.isEncrypted()) {
            return true;
        }
        if (this.isAppendOnly()) {
            return true;
        }
        return this.isSigned();
    }

    public boolean isReadOnly() {
        return this.cosDoc.isReadOnly();
    }

    public boolean isSigned() {
        if (this.getAcroForm() == null) {
            return false;
        }
        return this.getAcroForm().isSigned();
    }

    public COSObject lookupDestination(String string) {
        COSDictionary cOSDictionary;
        COSDictionary cOSDictionary2;
        COSCatalog cOSCatalog = this.getCatalog();
        COSObject cOSObject = null;
        COSDictionary cOSDictionary3 = cOSCatalog.cosGetDests();
        if (cOSDictionary3 != null) {
            cOSObject = cOSDictionary3.get(COSName.createUTF8(string));
        }
        if (cOSObject == null && (cOSDictionary2 = cOSCatalog.cosGetNames()) != null && (cOSDictionary = cOSDictionary2.get(COSCatalog.DK_Dests).asDictionary()) != null) {
            CDSNameTreeNode cDSNameTreeNode = CDSNameTreeNode.createFromCos(cOSDictionary);
            cOSObject = cDSNameTreeNode.get(COSString.create(string));
        }
        if (cOSObject == null || cOSObject.isNull()) {
            return null;
        }
        return cOSObject;
    }

    public void removeApplicationData(String string) {
        COSDictionary cOSDictionary = this.cosGetPieceInfoDict();
        if (cOSDictionary == null) {
            return;
        }
        COSName cOSName = COSName.createUTF8(string);
        cOSDictionary.remove(cOSName);
    }

    public final Object removeAttribute(Object object) {
        return this.cosDoc.removeAttribute(object);
    }

    public void restore(ILocator iLocator) throws IOException, COSLoadException {
        this.cosGetDoc().restore(iLocator);
    }

    public void save() throws IOException {
        this.save(this.getLocator(), null);
    }

    public void save(ILocator iLocator) throws IOException {
        this.save(iLocator, null);
    }

    public void save(ILocator iLocator, Map hashMap) throws IOException {
        HashMap<String, EnumWriteMode> hashMap2 = hashMap;
        if (hashMap2 == null) {
            hashMap2 = new HashMap<String, EnumWriteMode>();
        }
        if (this.isPreferIncrementalSave()) {
            hashMap2.put("writeModeHint", EnumWriteMode.INCREMENTAL);
        } else {
            EnumWriteMode enumWriteMode = (EnumWriteMode)((Object)hashMap2.get("writeModeHint"));
            if ((enumWriteMode == null || enumWriteMode.isUndefined()) && iLocator != null && iLocator != this.getLocator()) {
                hashMap2.put("writeModeHint", EnumWriteMode.FULL);
            }
        }
        this.cosDoc.save(iLocator, hashMap2);
    }

    public void setAcroForm(PDAcroForm pDAcroForm) {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return;
        }
        cOSCatalog.setFieldObject(COSCatalog.DK_AcroForm, pDAcroForm);
    }

    @Override
    public void setAdditionalActions(PDAdditionalActions pDAdditionalActions) {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog != null) {
            cOSCatalog.setFieldObject(DK_AA, pDAdditionalActions);
        }
    }

    public void setApplicationData(String string, PDApplicationData pDApplicationData) {
        COSDictionary cOSDictionary = this.cosGetPieceInfoDict();
        if (cOSDictionary == null) {
            cOSDictionary = COSDictionary.create();
            this.cosSetPieceInfoDict(cOSDictionary);
        }
        COSName cOSName = COSName.createUTF8(string);
        if (pDApplicationData == null) {
            cOSDictionary.remove(cOSName);
        } else {
            cOSDictionary.put(cOSName, pDApplicationData.cosGetDict());
        }
    }

    public final Object setAttribute(Object object, Object object2) {
        return this.cosDoc.setAttribute(object, object2);
    }

    public void setAuthor(String string) {
        this.setDocumentInfo(COSInfoDict.DK_Author, string);
    }

    public void setCollection(PDCollection pDCollection) {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return;
        }
        cOSCatalog.setFieldObject(COSCatalog.DK_Collection, pDCollection);
    }

    public void setCreationDateString(String string) {
        this.setDocumentInfo(COSInfoDict.DK_CreationDate, string);
    }

    public void setCreator(String string) {
        this.setDocumentInfo(COSInfoDict.DK_Creator, string);
    }

    public void setDocumentInfo(COSName cOSName, String string) {
        COSInfoDict cOSInfoDict = this.cosGetDoc().getInfoDict();
        if (cOSInfoDict == null) {
            cOSInfoDict = (COSInfoDict)COSInfoDict.META.createNew();
            this.cosGetDoc().setInfoDict(cOSInfoDict);
        }
        cOSInfoDict.setFieldString(cOSName, string);
    }

    public void setInfoDict(COSInfoDict cOSInfoDict) {
        this.cosGetDoc().setInfoDict(cOSInfoDict);
    }

    public void setKeywords(String string) {
        this.setDocumentInfo(COSInfoDict.DK_Keywords, string);
    }

    public void setModDateString(String string) {
        this.setDocumentInfo(COSInfoDict.DK_ModDate, string);
    }

    public void setName(String string) {
        this.cosDoc.setName(string);
    }

    public void setOpenAction(PDAction pDAction) {
        COSCatalog cOSCatalog = this.getCatalog();
        if (cOSCatalog == null) {
            return;
        }
        cOSCatalog.setFieldObject(DK_OpenAction, pDAction);
    }

    public void setOutline(PDOutline pDOutline) {
        this.getCatalog().cosSetOutline(pDOutline.cosGetDict());
    }

    public void setPageTree(PDPageTree pDPageTree) {
        this.getCatalog().setFieldObject(COSCatalog.DK_Pages, pDPageTree);
    }

    public void setPermissions(COSName cOSName, PDSignature pDSignature) {
        COSDictionary cOSDictionary = this.cosGetPermissionsDict();
        if (cOSDictionary == null) {
            cOSDictionary = COSDictionary.create();
            this.cosSetPermissionsDict(cOSDictionary);
        }
        COSDictionary cOSDictionary2 = pDSignature.cosGetDict();
        cOSDictionary2.beIndirect();
        cOSDictionary.put(cOSName, cOSDictionary2);
    }

    public void setProducer(String string) {
        this.setDocumentInfo(COSInfoDict.DK_Producer, string);
    }

    public void setSubject(String string) {
        this.setDocumentInfo(COSInfoDict.DK_Subject, string);
    }

    public void setTitle(String string) {
        this.setDocumentInfo(COSInfoDict.DK_Title, string);
    }

    public void setTrapped(String string) {
        if (this.getInfoDict() == null) {
            return;
        }
        this.getInfoDict().setTrapped(string);
    }

    public void setWriteModeHint(EnumWriteMode enumWriteMode) {
        this.cosDoc.setWriteModeHint(enumWriteMode);
    }
}

