/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.postscript;

import de.intarsys.pdf.postscript.IOperator;
import de.intarsys.pdf.postscript.PSArray;
import de.intarsys.pdf.postscript.PSName;
import de.intarsys.pdf.postscript.PSPrimitiveObject;
import de.intarsys.pdf.postscript.ParseException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class Handler {
    private PSArray procedure;
    private Stack stack = new Stack();

    public Object get(int n) {
        return this.stack.get(n);
    }

    public Object peek() {
        return this.stack.peek();
    }

    public Object pop() {
        return this.stack.pop();
    }

    public List popResult() {
        ArrayList arrayList = new ArrayList(this.stack.size());
        Iterator iterator = this.stack.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        this.stack.removeAllElements();
        return arrayList;
    }

    public void processEndArray() {
        throw new UnsupportedOperationException();
    }

    public void processEndProcedure() {
        this.stack.push(this.procedure);
        this.procedure = null;
    }

    public void processIdentifier(String string) throws ParseException {
        IOperator iOperator;
        Class<?> clazz;
        if (this.procedure != null) {
            this.procedure.add(new PSName(string));
            return;
        }
        String string2 = MessageFormat.format("de.intarsys.pdf.postscript.Operator_{0}", string);
        try {
            clazz = Class.forName(string2);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        try {
            iOperator = (IOperator)clazz.getField("Instance").get(null);
        }
        catch (Exception exception) {
            throw new ParseException(exception);
        }
        iOperator.execute(this);
    }

    public void processImmediateIdentifier(String string) {
        throw new UnsupportedOperationException();
    }

    public void processKeyIdentifier(String string) {
        throw new UnsupportedOperationException();
    }

    public void processLiteral(double d) {
        if (this.procedure != null) {
            this.procedure.add(new PSPrimitiveObject(d));
            return;
        }
        this.stack.push(d);
    }

    public void processLiteral(int n) {
        if (this.procedure != null) {
            this.procedure.add(new PSPrimitiveObject(n));
            return;
        }
        this.stack.push(n);
    }

    public void processLiteral(Object object) {
        if (this.procedure != null) {
            this.procedure.add(new PSPrimitiveObject(object));
            return;
        }
        this.stack.push(object);
    }

    public void processStartArray() {
        throw new UnsupportedOperationException();
    }

    public void processStartProcedure() {
        this.procedure = new PSArray();
    }

    public void push(Object object) {
        this.stack.push(object);
    }

    public void pushArgs(List list) {
        this.stack.addAll(list);
    }

    public int size() {
        return this.stack.size();
    }
}

