/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.parser.validators;

import java.io.File;
import java.util.Iterator;
import jcmdline.BooleanParam;
import jcmdline.CmdLineHandler;
import jcmdline.FileParam;
import jcmdline.PdfFileParam;
import jcmdline.StringParam;
import jcmdline.dto.PdfFile;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.SetViewerParsedCommand;
import org.pdfsam.console.business.parser.validators.interfaces.AbstractCmdValidator;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.exceptions.console.ParseException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.ValidationUtility;

public class SetViewerCmdValidator
extends AbstractCmdValidator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractParsedCommand validateArguments(CmdLineHandler cmdLineHandler) throws ConsoleException {
        StringParam directionOption;
        StringParam nfsmOption;
        StringParam lOption;
        StringParam mOption;
        SetViewerParsedCommand parsedCommandDTO = new SetViewerParsedCommand();
        if (cmdLineHandler == null) throw new ConsoleException(2);
        FileParam oOption = (FileParam)cmdLineHandler.getOption("o");
        if (!oOption.isSet()) {
            throw new ParseException(15);
        }
        File outFile = oOption.getFile();
        ValidationUtility.assertValidDirectory(outFile);
        parsedCommandDTO.setOutputFile(outFile);
        StringParam pOption = (StringParam)cmdLineHandler.getOption("p");
        if (pOption.isSet()) {
            parsedCommandDTO.setOutputFilesPrefix(pOption.getValue());
        }
        if ((mOption = (StringParam)cmdLineHandler.getOption("mode")).isSet()) {
            parsedCommandDTO.setMode(this.getMode(mOption.getValue()));
        }
        if ((lOption = (StringParam)cmdLineHandler.getOption("layout")).isSet()) {
            parsedCommandDTO.setLayout(this.getLayout(lOption.getValue()));
        }
        if ((nfsmOption = (StringParam)cmdLineHandler.getOption("nfsmode")).isSet()) {
            parsedCommandDTO.setNfsmode(this.getNFSMode(nfsmOption.getValue()));
        }
        if ((directionOption = (StringParam)cmdLineHandler.getOption("direction")).isSet()) {
            parsedCommandDTO.setDirection(this.getDirection(directionOption.getValue()));
        }
        PdfFileParam fOption = (PdfFileParam)cmdLineHandler.getOption("f");
        FileParam dOption = (FileParam)cmdLineHandler.getOption("d");
        if (!fOption.isSet() && !dOption.isSet()) throw new ParseException(25);
        if (fOption.isSet()) {
            Iterator fIterator = fOption.getPdfFiles().iterator();
            while (fIterator.hasNext()) {
                PdfFile currentFile = (PdfFile)fIterator.next();
                ValidationUtility.assertValidPdfExtension(currentFile.getFile().getName());
            }
            parsedCommandDTO.setInputFileList(FileUtility.getPdfFiles(fOption.getPdfFiles()));
        }
        if (dOption.isSet()) {
            File inputDir = dOption.getFile();
            ValidationUtility.assertValidDirectory(inputDir);
            parsedCommandDTO.setInputDirectory(inputDir);
        }
        parsedCommandDTO.setHideMenu(((BooleanParam)cmdLineHandler.getOption("hidemenu")).isTrue());
        parsedCommandDTO.setHideToolBar(((BooleanParam)cmdLineHandler.getOption("hidetoolbar")).isTrue());
        parsedCommandDTO.setHideWindowUI(((BooleanParam)cmdLineHandler.getOption("hidewindowui")).isTrue());
        parsedCommandDTO.setFitWindow(((BooleanParam)cmdLineHandler.getOption("fitwindow")).isTrue());
        parsedCommandDTO.setCenterWindow(((BooleanParam)cmdLineHandler.getOption("centerwindow")).isTrue());
        parsedCommandDTO.setDisplayDocTitle(((BooleanParam)cmdLineHandler.getOption("displaydoctitle")).isTrue());
        parsedCommandDTO.setNoPrintScaling(((BooleanParam)cmdLineHandler.getOption("noprintscaling")).isTrue());
        return parsedCommandDTO;
    }

    private int getDirection(String direction) {
        int retVal = 0;
        if ("r2l".equals(direction)) {
            retVal = 0x800000;
        } else if ("l2r".equals(direction)) {
            retVal = 0x400000;
        }
        return retVal;
    }

    private int getMode(String mode) {
        int retVal = 64;
        if ("attachments".equals(mode)) {
            retVal = 2048;
        } else if ("fullscreen".equals(mode)) {
            retVal = 512;
        } else if ("ocontent".equals(mode)) {
            retVal = 1024;
        } else if ("outlines".equals(mode)) {
            retVal = 128;
        } else if ("thumbs".equals(mode)) {
            retVal = 256;
        }
        return retVal;
    }

    private int getNFSMode(String nfsmode) {
        int retVal = 262144;
        if ("nfsocontent".equals(nfsmode)) {
            retVal = 0x200000;
        } else if ("nfsoutlines".equals(nfsmode)) {
            retVal = 524288;
        } else if ("nfsthumbs".equals(nfsmode)) {
            retVal = 0x100000;
        }
        return retVal;
    }

    private int getLayout(String layout) {
        int retVal = 2;
        if ("singlepage".equals(layout)) {
            retVal = 1;
        } else if ("twocolumnl".equals(layout)) {
            retVal = 4;
        } else if ("twocolumnr".equals(layout)) {
            retVal = 8;
        } else if ("twopagel".equals(layout)) {
            retVal = 16;
        } else if ("twopager".equals(layout)) {
            retVal = 32;
        }
        return retVal;
    }
}

