/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.handlers;

import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.pdfsam.console.business.dto.commands.AbstractParsedCommand;
import org.pdfsam.console.business.dto.commands.DocumentInfoParsedCommand;
import org.pdfsam.console.business.pdf.handlers.interfaces.AbstractCmdExecutor;
import org.pdfsam.console.exceptions.console.ConsoleException;
import org.pdfsam.console.utils.FileUtility;
import org.pdfsam.console.utils.PdfUtility;

public class DocumentInfoCmdExecutor
extends AbstractCmdExecutor {
    private static final Logger LOG = Logger.getLogger(DocumentInfoCmdExecutor.class.getPackage().getName());
    private static final String TITLE = PdfName.decodeName((String)PdfName.TITLE.toString());
    private static final String AUTHOR = PdfName.decodeName((String)PdfName.AUTHOR.toString());
    private static final String SUBJECT = PdfName.decodeName((String)PdfName.SUBJECT.toString());
    private static final String KEYWORDS = PdfName.decodeName((String)PdfName.KEYWORDS.toString());
    private PdfReader pdfReader = null;
    private PdfStamper pdfStamper = null;

    public void execute(AbstractParsedCommand parsedCommand) throws ConsoleException {
        if (parsedCommand != null && parsedCommand instanceof DocumentInfoParsedCommand) {
            DocumentInfoParsedCommand inputCommand = (DocumentInfoParsedCommand)parsedCommand;
            this.setPercentageOfWorkDone(0);
            try {
                File tmpFile = FileUtility.generateTmpFile(inputCommand.getOutputFile());
                this.pdfReader = PdfUtility.readerFor(inputCommand.getInputFile());
                this.pdfReader.removeUnusedObjects();
                this.pdfReader.consolidateNamedDestinations();
                LOG.debug("Creating a new document.");
                Character pdfVersion = inputCommand.getOutputPdfVersion();
                this.pdfStamper = pdfVersion != null ? new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), inputCommand.getOutputPdfVersion().charValue()) : new PdfStamper(this.pdfReader, (OutputStream)new FileOutputStream(tmpFile), this.pdfReader.getPdfVersion());
                HashMap meta = this.pdfReader.getInfo();
                meta.put("Creator", "pdfsam-console (Ver. 2.4.3e)");
                if (inputCommand.getAuthor() != null) {
                    meta.put(AUTHOR, inputCommand.getAuthor());
                }
                if (inputCommand.getSubject() != null) {
                    meta.put(SUBJECT, inputCommand.getSubject());
                }
                if (inputCommand.getTitle() != null) {
                    meta.put(TITLE, inputCommand.getTitle());
                }
                if (inputCommand.getKeywords() != null) {
                    meta.put(KEYWORDS, inputCommand.getKeywords());
                }
                this.setCompressionSettingOnStamper(inputCommand, this.pdfStamper);
                this.pdfStamper.setMoreInfo(meta);
                this.pdfStamper.close();
                this.pdfReader.close();
                FileUtility.renameTemporaryFile(tmpFile, inputCommand.getOutputFile(), inputCommand.isOverwrite());
                LOG.debug("File " + inputCommand.getOutputFile().getCanonicalPath() + " created.");
            }
            catch (Exception e) {
                throw new ConsoleException(e);
            }
            finally {
                this.setWorkCompleted();
            }
        } else {
            throw new ConsoleException(5);
        }
    }

    public void clean() {
        this.closePdfReader(this.pdfReader);
        this.closePdfStamper(this.pdfStamper);
    }
}

