/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.emp4j.messages.sources;

import java.io.File;
import java.net.URL;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pdfsam.emp4j.messages.interfaces.AbstractMessagesSource;
import org.w3c.dom.DOMException;

public class XmlMessagesSource
extends AbstractMessagesSource {
    private static final long serialVersionUID = -5549563695772599153L;
    private transient Document document;

    public XmlMessagesSource(Node node) throws Exception {
        super(node);
        Node arg1 = node.selectSingleNode("xmlsource/@filename");
        if (arg1 == null) {
            throw new DOMException(8, "Error reading configuration node, node is null.");
        }
        this.document = this.getDocument(arg1.getText());
    }

    private Document getDocument(String filename) throws Exception {
        Document retVal;
        SAXReader reader = new SAXReader();
        File resourceFile = new File(filename);
        if (resourceFile.exists()) {
            retVal = reader.read(resourceFile);
        } else {
            ClassLoader cl = XmlMessagesSource.class.getClassLoader();
            URL resourceUrl = null;
            resourceUrl = cl != null ? cl.getResource(filename) : ClassLoader.getSystemResource(filename);
            if (resourceUrl != null) {
                retVal = reader.read(resourceUrl);
            } else {
                throw new NullPointerException("Cannot locate XmlMessageSource data file.");
            }
        }
        return retVal;
    }

    public String getLocalizedExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode) throws Exception {
        return this.getExceptionMessage(exceptionTypeKey, exceptionErrorCode);
    }

    public String getExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getTypeDescription(exceptionTypeKey.toString()));
        sb.append(this.padString(Integer.toString(exceptionErrorCode), 3, '0', true));
        sb.append(" - ");
        Node node = this.document.selectSingleNode("/exception-types/type[@key=\"" + exceptionTypeKey.toString() + "\"]/exception[@errorcode=\"" + exceptionErrorCode + "\"]/@message");
        if (node != null) {
            sb.append(node.getText());
        }
        return sb.toString();
    }

    private String getTypeDescription(String exceptionTypeKey) throws Exception {
        String retVal = "UNK";
        Node node = this.document.selectSingleNode("/exception-types/type[@key=\"" + exceptionTypeKey + "\"]/@description");
        if (node != null) {
            retVal = node.getText();
        }
        return retVal;
    }

    private String padString(String s, int n, char c, boolean paddingLeft) {
        StringBuffer str = new StringBuffer(s);
        int strLength = str.length();
        if (n > 0 && n > strLength) {
            for (int i = 0; i <= n; ++i) {
                if (paddingLeft) {
                    if (i >= n - strLength) continue;
                    str.insert(0, c);
                    continue;
                }
                if (i <= strLength) continue;
                str.append(c);
            }
        }
        return str.toString();
    }
}

