/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.functions.postscript;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.icepdf.core.pobjects.functions.postscript.Lexer;

public class LexerText {
    public static final String TEST_1 = "{1.000000 3 1 roll 1.000000 3 1 roll 1.000000 3 1 roll 5 -1 roll \n2 index -0.874500 mul 1.000000 add mul 1 index -0.098000 mul 1.000000 add mul 5 \n1 roll 4 -1 roll 2 index -0.796100 mul 1.000000 add mul 1 index -0.247100 \nmul 1.000000 add mul 4 1 roll 3 -1 roll 2 index -0.647100 mul 1.000000 \nadd mul 1 index -0.878400 mul 1.000000 add mul 3 1 roll pop pop }";
    public static final String TEST_2 = "{1.000000 2 1 roll 1.000000 2 1 roll 1.000000 2 1 roll 0 index 1.000000 \ncvr exch sub 2 1 roll 5 -1 roll 1.000000 cvr exch sub 5 1 \nroll 4 -1 roll 1.000000 cvr exch sub 4 1 roll 3 -1 roll 1.000000 \ncvr exch sub 3 1 roll 2 -1 roll 1.000000 cvr exch sub 2 1 \nroll pop }";
    public static final String TEST_3 = "{0 0 0 0 5 4 roll 0 index 3 -1 roll add 2 1 roll pop dup 1 gt {pop 1} if 4 1 roll dup 1 gt {pop 1} if 4 1 roll dup 1 gt {pop 1} if 4 1 roll dup 1 gt {pop 1} if 4 1 roll}";

    public static void main(String[] args) {
        try {
            new LexerText().test8();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void test1() throws IOException {
        String test = TEST_1;
        ByteArrayInputStream function_4 = new ByteArrayInputStream(test.getBytes());
        Lexer lex = new Lexer();
        lex.setInputStream(function_4);
        lex.parse(new float[]{1.0f, 1.0f});
        System.out.println("result: " + lex.getStack().toString());
    }

    public void test2() throws IOException {
        String test = "{2 index 1.000000 cvr exch sub 4 1 roll 1 index 1.000000 cvr exch sub \n4 1 roll 0 index 1.000000 cvr exch sub 4 1 roll 1.000000 4 1 \nroll 7 -1 roll 1.000000 cvr exch sub 7 1 roll 6 -1 roll 1.000000 \ncvr exch sub 6 1 roll 5 -1 roll 1.000000 cvr exch sub 5 1 \nroll 4 -1 roll 1.000000 cvr exch sub 4 1 roll pop pop pop }";
        ByteArrayInputStream function_4 = new ByteArrayInputStream(test.getBytes());
        Lexer lex = new Lexer();
        lex.setInputStream(function_4);
        lex.parse(new float[]{0.360779f, 0.094238274f, 0.00392151f});
        System.out.println("result: " + lex.getStack().toString());
    }

    public void test5() throws IOException {
        String test = "{2 index 1.000000 cvr exch sub 4 1 roll 1 index 1.000000 cvr exch sub \n4 1 roll 0 index 1.000000 cvr exch sub 4 1 roll 1.000000 4 1 \nroll 7 -1 roll 1.000000 cvr exch sub 7 1 roll 6 -1 roll 1.000000 \ncvr exch sub 6 1 roll 5 -1 roll 1.000000 cvr exch sub 5 1 \nroll 4 -1 roll 1.000000 cvr exch sub 4 1 roll pop pop pop }";
        ByteArrayInputStream function_4 = new ByteArrayInputStream(test.getBytes());
        Lexer lex = new Lexer();
        lex.setInputStream(function_4);
        lex.parse(new float[]{0.360779f, 0.094238274f, 0.00392151f});
        System.out.println("result: " + lex.getStack().toString());
    }

    public void test6() throws IOException {
        String test = TEST_2;
        ByteArrayInputStream function_4 = new ByteArrayInputStream(test.getBytes());
        Lexer lex = new Lexer();
        lex.setInputStream(function_4);
        lex.parse(new float[]{0.300003f});
        System.out.println("result: " + lex.getStack().toString());
        int n = 4;
        float[] range = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
        float[] y = new float[n];
        System.out.println();
        for (int i = 0; i < n; ++i) {
            float value = ((Float)lex.getStack().elementAt(i)).floatValue();
            y[i] = Math.min(Math.max(value, range[2 * i]), range[2 * i + 1]);
            System.out.print(y[i] + ", ");
        }
        System.out.println();
    }

    public void test7() throws IOException {
        String test = TEST_3;
        ByteArrayInputStream function_4 = new ByteArrayInputStream(test.getBytes());
        Lexer lex = new Lexer();
        lex.setInputStream(function_4);
        lex.parse(new float[]{1.0f});
        System.out.println("result: " + lex.getStack().toString());
        int n = 4;
        float[] range = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
        float[] y = new float[n];
        System.out.println();
        for (int i = 0; i < n; ++i) {
            float value = ((Float)lex.getStack().elementAt(i)).floatValue();
            y[i] = Math.min(Math.max(value, range[2 * i]), range[2 * i + 1]);
            System.out.print(y[i] + ", ");
        }
        System.out.println();
    }

    public void test8() throws IOException {
        String test = "{3 copy pop 0 exch pop exch pop 4 1 roll 3 copy exch pop exch pop 5 1 roll 3 copy pop 0 exch 2 copy lt {exch} if pop exch pop 6 1 roll pop 0 exch pop exch 2 copy lt {exch} if pop 4 1 roll}";
        ByteArrayInputStream function_4 = new ByteArrayInputStream(test.getBytes());
        Lexer lex = new Lexer();
        lex.setInputStream(function_4);
        lex.parse(new float[]{0.86f, 0.07999998f, 0.0f});
        System.out.println("result: " + lex.getStack().toString());
        int n = 4;
        float[] range = new float[]{0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 1.0f};
        float[] y = new float[n];
        System.out.println();
        for (int i = 0; i < n; ++i) {
            float value = ((Float)lex.getStack().elementAt(i)).floatValue();
            y[i] = Math.min(Math.max(value, range[2 * i]), range[2 * i + 1]);
            System.out.print(y[i] + ", ");
        }
        System.out.println();
    }
}

