/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeArrayType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.NativeVoid;

public class NativeArray
extends NativeObject {
    public static final NativeArrayType META = new NativeArrayType(NativeVoid.META, 0);
    private INativeObject[] values;
    private NativeArrayType type;

    static {
        NativeType.register(NativeArray.class, META);
    }

    public static NativeArray create(INativeType iNativeType, int n) {
        NativeArrayType nativeArrayType = new NativeArrayType(iNativeType, n);
        return new NativeArray(nativeArrayType);
    }

    protected NativeArray(NativeArrayType nativeArrayType) {
        this.type = nativeArrayType;
        this.allocate();
    }

    protected NativeArray(NativeArrayType nativeArrayType, INativeHandle iNativeHandle) {
        super(iNativeHandle);
        this.type = nativeArrayType;
    }

    public INativeType getBaseType() {
        return this.type.getBaseType();
    }

    @Override
    public int getByteCount() {
        return this.type.getByteCount();
    }

    public synchronized INativeObject getNativeObject(int n) {
        INativeObject iNativeObject;
        if (this.values == null) {
            this.values = new INativeObject[this.getSize()];
        }
        if ((iNativeObject = this.values[n]) == null) {
            int n2 = n * this.type.getBaseSize();
            this.values[n] = iNativeObject = this.type.getBaseType().createNative(this.handle.offset(n2));
        }
        return iNativeObject;
    }

    @Override
    public INativeType getNativeType() {
        return this.type;
    }

    public int getSize() {
        return this.type.getArraySize();
    }

    @Override
    public Object getValue() {
        throw new UnsupportedOperationException("getValue not implemented for NativeArray");
    }

    public Object getValue(int n) {
        return this.getNativeObject(n).getValue();
    }

    public void setBaseType(INativeType iNativeType) {
        this.type = NativeArrayType.create(iNativeType, this.type.getArraySize());
        this.values = null;
        this.handle.setSize(this.getByteCount());
    }

    public void setSize(int n) {
        this.type = NativeArrayType.create(this.type.getBaseType(), n);
        this.values = null;
        this.handle.setSize(this.getByteCount());
    }

    public void setValue(int n, Object object) {
        this.getNativeObject(n).setValue(object);
    }

    @Override
    public void setValue(Object object) {
        throw new UnsupportedOperationException("setValue not implemented for NativeArray");
    }

    @Override
    public String toNestedString() {
        return "[...]";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int n = 0;
        while (n < this.getSize()) {
            ++n;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

