/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeBufferType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;
import java.nio.ByteBuffer;

public class NativeBuffer
extends NativeObject {
    public static final NativeBufferType META = new NativeBufferType();
    private NativeBufferType type;

    static {
        NativeType.register(NativeBuffer.class, META);
    }

    public NativeBuffer(byte[] byArray) {
        this.type = new NativeBufferType(byArray.length);
        this.handle = NativeInterface.get().allocate(byArray.length);
        this.handle.setByteArray(0, byArray, 0, byArray.length);
    }

    protected NativeBuffer(INativeHandle iNativeHandle) {
        super(iNativeHandle);
    }

    public NativeBuffer(int n) {
        this.type = new NativeBufferType(n);
        this.handle = NativeInterface.get().allocate(n);
    }

    @Override
    public int getByteCount() {
        return this.type.getByteCount();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    public int getSize() {
        return this.type.getByteCount();
    }

    @Override
    public Object getValue() {
        return this.getBytes();
    }

    public void setSize(int n) {
        this.type = new NativeBufferType(n);
        this.handle.setSize(this.getByteCount());
    }

    @Override
    public void setValue(Object object) {
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.setByteArray(0, byArray, 0, byArray.length);
        } else if (object instanceof ByteBuffer) {
            byte[] byArray = new byte[this.getSize()];
            ((ByteBuffer)object).get(byArray);
            this.setByteArray(0, byArray, 0, byArray.length);
        }
    }
}

