/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeLongLP64Type;
import de.intarsys.nativec.type.NativeNumber;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;

public class NativeLongLP64
extends NativeNumber {
    public static final NativeLongLP64Type META = new NativeLongLP64Type();

    static {
        NativeType.register(NativeLongLP64.class, META);
    }

    public static NativeLongLP64 createFromAddress(long l) {
        return (NativeLongLP64)META.createNative(NativeTools.toHandle(l));
    }

    public NativeLongLP64() {
        this.allocate();
    }

    protected NativeLongLP64(INativeHandle iNativeHandle) {
        super(iNativeHandle);
    }

    public NativeLongLP64(long l) {
        this.allocate();
        this.setValue(l);
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    @Override
    public INativeType getNativeType() {
        return META;
    }

    @Override
    public Object getValue() {
        return new Long(this.longValue());
    }

    @Override
    public int intValue() {
        return (int)this.longValue();
    }

    @Override
    public long longValue() {
        if (NativeObject.SIZE_PTR == 4) {
            return this.handle.getInt(0);
        }
        return this.handle.getLong(0);
    }

    public void setValue(long l) {
        if (NativeObject.SIZE_PTR == 4) {
            this.handle.setInt(0, (int)l);
            return;
        }
        this.handle.setLong(0, l);
    }

    @Override
    public void setValue(Object object) {
        this.setValue(((Number)object).longValue());
    }

    @Override
    public short shortValue() {
        return (short)this.longValue();
    }

    public String toString() {
        if (this.getNativeHandle().getAddress() == 0L) {
            return "nope - null pointer";
        }
        return String.valueOf(this.longValue());
    }
}

