/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.merge.GUI;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pdfsam.guiclient.business.listeners.EnterDoClickListener;
import org.pdfsam.guiclient.commons.business.actions.SetOutputPathSelectionTableAction;
import org.pdfsam.guiclient.commons.business.listeners.CompressCheckBoxItemListener;
import org.pdfsam.guiclient.commons.components.CommonComponentsFactory;
import org.pdfsam.guiclient.commons.components.JPdfVersionCombo;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooser;
import org.pdfsam.guiclient.commons.components.sharedchooser.SharedJFileChooserType;
import org.pdfsam.guiclient.commons.panels.JPdfSelectionPanel;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.dto.PdfSelectionTableItem;
import org.pdfsam.guiclient.dto.StringItem;
import org.pdfsam.guiclient.exceptions.LoadJobException;
import org.pdfsam.guiclient.exceptions.SaveJobException;
import org.pdfsam.guiclient.gui.components.JHelpLabel;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.i18n.GettextResource;
import org.pdfsam.plugin.merge.actions.SaveListAsXmlAction;
import org.pdfsam.plugin.merge.listeners.RunButtonActionListener;

public class MergeMainGUI
extends AbstractPlugablePanel {
    private static final String DEFAULT_OUPUT_NAME = "merged_file.pdf";
    private static final long serialVersionUID = -992513717368544272L;
    private static final Logger log = Logger.getLogger((String)MergeMainGUI.class.getPackage().getName());
    private JTextField destinationTextField = CommonComponentsFactory.getInstance().createTextField(1);
    private SpringLayout layoutDestinationPanel;
    private JPanel destinationPanel = new JPanel();
    private SpringLayout layoutOptionPanel;
    private JPanel optionPanel = new JPanel();
    private JHelpLabel mergeTypeHelpLabel;
    private JHelpLabel destinationHelpLabel;
    private Configuration config;
    private JCheckBox mergeTypeCheck = new JCheckBox();
    private JPdfVersionCombo versionCombo = new JPdfVersionCombo();
    private JPdfSelectionPanel selectionPanel = new JPdfSelectionPanel(Integer.MAX_VALUE, 7);
    private JPanel topPanel = new JPanel();
    private final JButton browseDestButton = CommonComponentsFactory.getInstance().createButton(2);
    private final JButton runButton = CommonComponentsFactory.getInstance().createButton(1);
    private final JCheckBox overwriteCheckbox = CommonComponentsFactory.getInstance().createCheckBox(1);
    private final JCheckBox outputCompressedCheck = CommonComponentsFactory.getInstance().createCheckBox(2);
    private final EnterDoClickListener runEnterKeyListener = new EnterDoClickListener(this.runButton);
    private final EnterDoClickListener browseEnterKeyListener = new EnterDoClickListener(this.browseDestButton);
    private final MergeFocusPolicy mergeFocusPolicy = new MergeFocusPolicy();
    private final JLabel outputVersionLabel = CommonComponentsFactory.getInstance().createLabel(1);
    private static final String PLUGIN_AUTHOR = "Andrea Vacondio";
    private static final String PLUGIN_VERSION = "0.7.4";
    public static final String ALL_STRING = "All";

    public MergeMainGUI() {
        this.initialize();
    }

    private void initialize() {
        this.config = Configuration.getInstance();
        this.setPanelIcon("/images/merge.png");
        this.setPreferredSize(new Dimension(500, 550));
        this.setLayout(new GridBagLayout());
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints topConst = new GridBagConstraints();
        topConst.fill = 1;
        topConst.ipady = 5;
        topConst.weightx = 1.0;
        topConst.weighty = 1.0;
        topConst.gridwidth = 3;
        topConst.gridheight = 2;
        topConst.gridx = 0;
        topConst.gridy = 0;
        this.topPanel.add((Component)this.selectionPanel, topConst);
        this.selectionPanel.addPopupMenuAction((AbstractAction)new SetOutputPathSelectionTableAction(this.selectionPanel, this.destinationTextField, DEFAULT_OUPUT_NAME));
        this.layoutOptionPanel = new SpringLayout();
        this.optionPanel.setLayout(this.layoutOptionPanel);
        this.optionPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Merge options")));
        this.optionPanel.setMinimumSize(new Dimension(50, 50));
        this.optionPanel.setPreferredSize(new Dimension(50, 60));
        topConst.fill = 2;
        topConst.weightx = 0.0;
        topConst.weighty = 0.0;
        topConst.gridwidth = 3;
        topConst.gridheight = 1;
        topConst.gridx = 0;
        topConst.gridy = 2;
        this.topPanel.add((Component)this.optionPanel, topConst);
        this.mergeTypeCheck.setText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"PDF documents contain forms"));
        this.mergeTypeCheck.setSelected(false);
        this.optionPanel.add(this.mergeTypeCheck);
        String helpText = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Merge type") + "</b><ul>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Unchecked") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Use this merge type for standard pdf documents") + ".</li>" + "<li><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Checked") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Use this merge type for pdf documents containing forms") + "." + "<br><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Note") + ":</b> " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Setting this option the documents will be completely loaded in memory") + ".</li>" + "</ul></body></html>";
        this.mergeTypeHelpLabel = new JHelpLabel(helpText, true);
        this.optionPanel.add((Component)this.mergeTypeHelpLabel);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 10, 0);
        this.add(this.topPanel, c);
        this.layoutDestinationPanel = new SpringLayout();
        this.destinationPanel.setLayout(this.layoutDestinationPanel);
        this.destinationPanel.setBorder(BorderFactory.createTitledBorder(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file")));
        this.destinationPanel.setPreferredSize(new Dimension(200, 160));
        this.destinationPanel.setMinimumSize(new Dimension(160, 150));
        c.fill = 2;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 3;
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.add(this.destinationPanel, c);
        this.destinationPanel.add(this.destinationTextField);
        this.browseDestButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File chosenFile;
                JFileChooser fileChooser = SharedJFileChooser.getInstance((SharedJFileChooserType)SharedJFileChooserType.PDF_FILE, (int)0, (String)MergeMainGUI.this.destinationTextField.getText());
                if (fileChooser.showOpenDialog(MergeMainGUI.this.browseDestButton.getParent()) == 0 && (chosenFile = fileChooser.getSelectedFile()) != null) {
                    MergeMainGUI.this.destinationTextField.setText(chosenFile.getAbsolutePath());
                }
            }
        });
        this.destinationPanel.add(this.browseDestButton);
        this.destinationPanel.add(this.overwriteCheckbox);
        this.outputCompressedCheck.addItemListener((ItemListener)new CompressCheckBoxItemListener(this.versionCombo));
        this.outputCompressedCheck.setSelected(true);
        this.destinationPanel.add(this.outputCompressedCheck);
        this.destinationPanel.add((Component)this.versionCombo);
        this.destinationPanel.add(this.outputVersionLabel);
        String helpTextDest = "<html><body><b>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Destination output file") + "</b>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Browse or enter the full path to the destination output file.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want to overwrite the output file if it already exists.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Check the box if you want compressed output files.") + " " + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"PDF version 1.5 or above.") + "</p>" + "<p>" + GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Set the pdf version of the ouput document.") + "</p>" + "</body></html>";
        this.destinationHelpLabel = new JHelpLabel(helpTextDest, true);
        this.destinationPanel.add((Component)this.destinationHelpLabel);
        this.runButton.addActionListener((ActionListener)((Object)new RunButtonActionListener(this)));
        this.runButton.setToolTipText(GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Execute pdf merge"));
        this.runButton.setSize(new Dimension(88, 25));
        c.fill = 0;
        c.ipadx = 5;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 26;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 2;
        c.insets = new Insets(10, 10, 10, 10);
        this.add(this.runButton, c);
        this.runButton.addKeyListener((KeyListener)this.runEnterKeyListener);
        this.browseDestButton.addKeyListener((KeyListener)this.browseEnterKeyListener);
        this.destinationTextField.addKeyListener((KeyListener)this.runEnterKeyListener);
        this.selectionPanel.addPopupMenuAction((AbstractAction)new SaveListAsXmlAction(this.selectionPanel));
        this.setLayout();
    }

    private void setLayout() {
        this.layoutOptionPanel.putConstraint("South", (Component)this.mergeTypeCheck, 30, "North", (Component)this.optionPanel);
        this.layoutOptionPanel.putConstraint("East", (Component)this.mergeTypeCheck, -40, "East", (Component)this.optionPanel);
        this.layoutOptionPanel.putConstraint("North", (Component)this.mergeTypeCheck, 0, "North", (Component)this.optionPanel);
        this.layoutOptionPanel.putConstraint("West", (Component)this.mergeTypeCheck, 5, "West", (Component)this.optionPanel);
        this.layoutOptionPanel.putConstraint("South", (Component)this.mergeTypeHelpLabel, -1, "South", (Component)this.optionPanel);
        this.layoutOptionPanel.putConstraint("East", (Component)this.mergeTypeHelpLabel, -1, "East", (Component)this.optionPanel);
        this.layoutDestinationPanel.putConstraint("East", (Component)this.destinationTextField, -105, "East", (Component)this.destinationPanel);
        this.layoutDestinationPanel.putConstraint("North", (Component)this.destinationTextField, 10, "North", (Component)this.destinationPanel);
        this.layoutDestinationPanel.putConstraint("South", (Component)this.destinationTextField, 30, "North", (Component)this.destinationPanel);
        this.layoutDestinationPanel.putConstraint("West", (Component)this.destinationTextField, 5, "West", (Component)this.destinationPanel);
        this.layoutDestinationPanel.putConstraint("South", (Component)this.overwriteCheckbox, 17, "North", (Component)this.overwriteCheckbox);
        this.layoutDestinationPanel.putConstraint("North", (Component)this.overwriteCheckbox, 5, "South", (Component)this.destinationTextField);
        this.layoutDestinationPanel.putConstraint("West", (Component)this.overwriteCheckbox, 0, "West", (Component)this.destinationTextField);
        this.layoutDestinationPanel.putConstraint("South", (Component)this.outputCompressedCheck, 17, "North", (Component)this.outputCompressedCheck);
        this.layoutDestinationPanel.putConstraint("North", (Component)this.outputCompressedCheck, 5, "South", (Component)this.overwriteCheckbox);
        this.layoutDestinationPanel.putConstraint("West", (Component)this.outputCompressedCheck, 0, "West", (Component)this.destinationTextField);
        this.layoutDestinationPanel.putConstraint("South", (Component)this.outputVersionLabel, 17, "North", (Component)this.outputVersionLabel);
        this.layoutDestinationPanel.putConstraint("North", (Component)this.outputVersionLabel, 8, "South", (Component)this.outputCompressedCheck);
        this.layoutDestinationPanel.putConstraint("West", (Component)this.outputVersionLabel, 0, "West", (Component)this.destinationTextField);
        this.layoutDestinationPanel.putConstraint("South", (Component)this.versionCombo, 0, "South", (Component)this.outputVersionLabel);
        this.layoutDestinationPanel.putConstraint("West", (Component)this.versionCombo, 2, "East", (Component)this.outputVersionLabel);
        this.layoutDestinationPanel.putConstraint("South", (Component)this.browseDestButton, 25, "North", (Component)this.browseDestButton);
        this.layoutDestinationPanel.putConstraint("East", (Component)this.browseDestButton, -5, "East", (Component)this.destinationPanel);
        this.layoutDestinationPanel.putConstraint("North", (Component)this.browseDestButton, 0, "North", (Component)this.destinationTextField);
        this.layoutDestinationPanel.putConstraint("West", (Component)this.browseDestButton, -93, "East", (Component)this.destinationPanel);
        this.layoutDestinationPanel.putConstraint("South", (Component)this.destinationHelpLabel, -1, "South", (Component)this.destinationPanel);
        this.layoutDestinationPanel.putConstraint("East", (Component)this.destinationHelpLabel, -1, "East", (Component)this.destinationPanel);
    }

    public String getPluginAuthor() {
        return PLUGIN_AUTHOR;
    }

    public String getPluginName() {
        return GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Merge/Extract");
    }

    public String getVersion() {
        return PLUGIN_VERSION;
    }

    public FocusTraversalPolicy getFocusPolicy() {
        return this.mergeFocusPolicy;
    }

    public Node getJobNode(Node arg0, boolean savePasswords) throws SaveJobException {
        try {
            if (arg0 != null) {
                Element filelist = ((Element)arg0).addElement("filelist");
                PdfSelectionTableItem[] items = this.selectionPanel.getTableRows();
                for (int i = 0; i < items.length; ++i) {
                    Element fileNode = filelist.addElement("file");
                    fileNode.addAttribute("name", items[i].getInputFile().getAbsolutePath());
                    fileNode.addAttribute("pageselection", items[i].getPageSelection() != null ? items[i].getPageSelection() : ALL_STRING);
                    if (!savePasswords) continue;
                    fileNode.addAttribute("password", items[i].getPassword());
                }
                Element fileDestination = ((Element)arg0).addElement("destination");
                fileDestination.addAttribute("value", this.destinationTextField.getText());
                Element fileOverwrite = ((Element)arg0).addElement("overwrite");
                fileOverwrite.addAttribute("value", this.overwriteCheckbox.isSelected() ? TRUE : FALSE);
                Element mergeType = ((Element)arg0).addElement("merge_type");
                mergeType.addAttribute("value", this.mergeTypeCheck.isSelected() ? TRUE : FALSE);
                Element fileCompress = ((Element)arg0).addElement("compressed");
                fileCompress.addAttribute("value", this.outputCompressedCheck.isSelected() ? TRUE : FALSE);
                Element pdfVersion = ((Element)arg0).addElement("pdfversion");
                pdfVersion.addAttribute("value", ((StringItem)this.versionCombo.getSelectedItem()).getId());
            }
            return arg0;
        }
        catch (Exception ex) {
            throw new SaveJobException((Throwable)ex);
        }
    }

    public void loadJobNode(Node arg0) throws LoadJobException {
        try {
            Node pdfVersion;
            Node mergeType;
            Node fileOverwrite;
            Node fileDestination = arg0.selectSingleNode("destination/@value");
            if (fileDestination != null) {
                this.destinationTextField.setText(fileDestination.getText());
            }
            if ((fileOverwrite = arg0.selectSingleNode("overwrite/@value")) != null) {
                this.overwriteCheckbox.setSelected(TRUE.equals(fileOverwrite.getText()));
            }
            if ((mergeType = arg0.selectSingleNode("merge_type/@value")) != null) {
                this.mergeTypeCheck.setSelected(TRUE.equals(mergeType.getText()));
            }
            List fileList = arg0.selectNodes("filelist/file");
            for (int i = 0; fileList != null && i < fileList.size(); ++i) {
                Node fileName;
                Node fileNode = (Node)fileList.get(i);
                if (fileNode == null || (fileName = fileNode.selectSingleNode("@name")) == null || fileName.getText().length() <= 0) continue;
                Node pageSelection = fileNode.selectSingleNode("@pageselection");
                Node filePwd = fileNode.selectSingleNode("@password");
                this.selectionPanel.getLoader().addFile(new File(fileName.getText()), filePwd != null ? filePwd.getText() : null, pageSelection != null ? pageSelection.getText() : null);
            }
            Node fileCompressed = arg0.selectSingleNode("compressed/@value");
            if (fileCompressed != null && TRUE.equals(fileCompressed.getText())) {
                this.outputCompressedCheck.doClick();
            }
            if ((pdfVersion = arg0.selectSingleNode("pdfversion/@value")) != null) {
                for (int i = 0; i < this.versionCombo.getItemCount(); ++i) {
                    if (!((StringItem)this.versionCombo.getItemAt(i)).getId().equals(pdfVersion.getText())) continue;
                    this.versionCombo.setSelectedIndex(i);
                    break;
                }
            }
            log.info((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Merge section loaded."));
        }
        catch (Exception ex) {
            log.error((Object)GettextResource.gettext((ResourceBundle)this.config.getI18nResourceBundle(), (String)"Error: "), (Throwable)ex);
        }
    }

    public void resetPanel() {
        this.selectionPanel.clearSelectionTable();
        this.destinationTextField.setText("");
        this.versionCombo.resetComponent();
        this.outputCompressedCheck.setSelected(false);
        this.overwriteCheckbox.setSelected(false);
        this.mergeTypeCheck.setSelected(false);
    }

    public JTextField getDestinationTextField() {
        return this.destinationTextField;
    }

    public JCheckBox getMergeTypeCheck() {
        return this.mergeTypeCheck;
    }

    public JPdfVersionCombo getVersionCombo() {
        return this.versionCombo;
    }

    public JPdfSelectionPanel getSelectionPanel() {
        return this.selectionPanel;
    }

    public JCheckBox getOverwriteCheckbox() {
        return this.overwriteCheckbox;
    }

    public JCheckBox getOutputCompressedCheck() {
        return this.outputCompressedCheck;
    }

    public class MergeFocusPolicy
    extends FocusTraversalPolicy {
        public Component getComponentAfter(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getAddFileButton())) {
                return MergeMainGUI.this.selectionPanel.getRemoveFileButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getRemoveFileButton())) {
                return MergeMainGUI.this.selectionPanel.getMoveUpButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getMoveUpButton())) {
                return MergeMainGUI.this.selectionPanel.getMoveDownButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getMoveDownButton())) {
                return MergeMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getClearButton())) {
                return MergeMainGUI.this.mergeTypeCheck;
            }
            if (aComponent.equals(MergeMainGUI.this.mergeTypeCheck)) {
                return MergeMainGUI.this.destinationTextField;
            }
            if (aComponent.equals(MergeMainGUI.this.destinationTextField)) {
                return MergeMainGUI.this.browseDestButton;
            }
            if (aComponent.equals(MergeMainGUI.this.browseDestButton)) {
                return MergeMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(MergeMainGUI.this.overwriteCheckbox)) {
                return MergeMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(MergeMainGUI.this.outputCompressedCheck)) {
                return MergeMainGUI.this.versionCombo;
            }
            if (aComponent.equals(MergeMainGUI.this.versionCombo)) {
                return MergeMainGUI.this.runButton;
            }
            if (aComponent.equals(MergeMainGUI.this.runButton)) {
                return MergeMainGUI.this.selectionPanel.getAddFileButton();
            }
            return MergeMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getComponentBefore(Container CycleRootComp, Component aComponent) {
            if (aComponent.equals(MergeMainGUI.this.runButton)) {
                return MergeMainGUI.this.versionCombo;
            }
            if (aComponent.equals(MergeMainGUI.this.versionCombo)) {
                return MergeMainGUI.this.outputCompressedCheck;
            }
            if (aComponent.equals(MergeMainGUI.this.outputCompressedCheck)) {
                return MergeMainGUI.this.overwriteCheckbox;
            }
            if (aComponent.equals(MergeMainGUI.this.overwriteCheckbox)) {
                return MergeMainGUI.this.browseDestButton;
            }
            if (aComponent.equals(MergeMainGUI.this.browseDestButton)) {
                return MergeMainGUI.this.destinationTextField;
            }
            if (aComponent.equals(MergeMainGUI.this.destinationTextField)) {
                return MergeMainGUI.this.mergeTypeCheck;
            }
            if (aComponent.equals(MergeMainGUI.this.mergeTypeCheck)) {
                return MergeMainGUI.this.selectionPanel.getClearButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getClearButton())) {
                return MergeMainGUI.this.selectionPanel.getMoveDownButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getMoveDownButton())) {
                return MergeMainGUI.this.selectionPanel.getMoveUpButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getMoveUpButton())) {
                return MergeMainGUI.this.selectionPanel.getRemoveFileButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getRemoveFileButton())) {
                return MergeMainGUI.this.selectionPanel.getAddFileButton();
            }
            if (aComponent.equals(MergeMainGUI.this.selectionPanel.getAddFileButton())) {
                return MergeMainGUI.this.runButton;
            }
            return MergeMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getDefaultComponent(Container CycleRootComp) {
            return MergeMainGUI.this.selectionPanel.getAddFileButton();
        }

        public Component getLastComponent(Container CycleRootComp) {
            return MergeMainGUI.this.runButton;
        }

        public Component getFirstComponent(Container CycleRootComp) {
            return MergeMainGUI.this.selectionPanel.getAddFileButton();
        }
    }
}

