/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.guiclient.gui.frames;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang.time.DurationFormatUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.pdfsam.guiclient.GuiClient;
import org.pdfsam.guiclient.business.ApplicationCloser;
import org.pdfsam.guiclient.business.actions.LoadEnvironmentAction;
import org.pdfsam.guiclient.business.actions.SaveEnvironmentAction;
import org.pdfsam.guiclient.business.environment.Environment;
import org.pdfsam.guiclient.business.listeners.LogActionListener;
import org.pdfsam.guiclient.business.listeners.MainWindowListener;
import org.pdfsam.guiclient.business.listeners.mediators.ApplicationExitMediator;
import org.pdfsam.guiclient.business.listeners.mediators.TreeMediator;
import org.pdfsam.guiclient.business.listeners.mediators.UpdateCheckerMediator;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.guiclient.configuration.GuiConfiguration;
import org.pdfsam.guiclient.gui.components.JMainMenuBar;
import org.pdfsam.guiclient.gui.frames.JSplashScreen;
import org.pdfsam.guiclient.gui.panels.JButtonsPanel;
import org.pdfsam.guiclient.gui.panels.JInfoPanel;
import org.pdfsam.guiclient.gui.panels.JLogPanel;
import org.pdfsam.guiclient.gui.panels.JSettingsPanel;
import org.pdfsam.guiclient.gui.panels.JStatusPanel;
import org.pdfsam.guiclient.gui.panels.JTreePanel;
import org.pdfsam.guiclient.plugins.PlugInsLoader;
import org.pdfsam.guiclient.plugins.interfaces.AbstractPlugablePanel;
import org.pdfsam.guiclient.plugins.models.PluginDataModel;
import org.pdfsam.i18n.GettextResource;

public class JMainFrame
extends JFrame {
    private static final long serialVersionUID = -3858244069059677829L;
    private static final Logger log = Logger.getLogger(JMainFrame.class.getPackage().getName());
    private String DEFAULT_ICON = "/images/pdf.png";
    private String DEFAULT_ICON_16 = "/images/pdf16.png";
    private JSplashScreen screen;
    private Map<PluginDataModel, AbstractPlugablePanel> pluginsMap;
    private JStatusPanel statusPanel;
    private JTreePanel treePanel;
    private JButtonsPanel buttonsPanel;
    private JPanel mainPanel = new JPanel(new CardLayout());
    private JScrollPane mainScrollPanel;
    private JSplitPane verticalSplitPane;
    private JSplitPane horizSplitPane;
    private JLogPanel logPanel;
    private JMainMenuBar menuBar;
    private Environment environment;

    public JMainFrame() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        log.info("Starting " + GuiClient.getApplicationName() + " Ver. " + GuiClient.getVersion());
        this.runSplash();
        ToolTipManager.sharedInstance().setDismissDelay(300000);
        this.initialize();
        this.closeSplash();
        stopWatch.stop();
        log.info(GuiClient.getApplicationName() + " Ver. " + GuiClient.getVersion() + " " + GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"started in ") + DurationFormatUtils.formatDurationWords((long)stopWatch.getTime(), (boolean)true, (boolean)true));
    }

    private void initialize() {
        try {
            File defaultEnv;
            URL iconUrl = this.getClass().getResource("/images/pdf_" + GuiClient.getVersionType() + ".png");
            URL iconUrl16 = this.getClass().getResource("/images/pdf_" + GuiClient.getVersionType() + "16.png");
            if (iconUrl == null) {
                iconUrl = this.getClass().getResource(this.DEFAULT_ICON);
            }
            if (iconUrl16 == null) {
                iconUrl16 = this.getClass().getResource(this.DEFAULT_ICON_16);
            }
            this.setIconImage(new ImageIcon(iconUrl).getImage());
            this.setTitle(GuiClient.getApplicationName() + " Ver. " + GuiClient.getVersion());
            this.setSplashStep(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Loading plugins.."));
            PlugInsLoader pluginsLoader = new PlugInsLoader(Configuration.getInstance().getPluginAbsolutePath());
            this.pluginsMap = pluginsLoader.loadPlugins();
            JInfoPanel infoPanel = new JInfoPanel(this.pluginsMap);
            PluginDataModel infoDataModel = new PluginDataModel(infoPanel.getPluginName(), infoPanel.getVersion(), infoPanel.getPluginAuthor(), infoPanel.getClass().getName());
            this.mainPanel.add((Component)infoPanel, infoPanel.getPluginName());
            JSettingsPanel settingsPanel = new JSettingsPanel();
            PluginDataModel settingsDataModel = new PluginDataModel(settingsPanel.getPluginName(), settingsPanel.getVersion(), settingsPanel.getPluginAuthor(), settingsPanel.getClass().getName());
            this.mainPanel.add((Component)settingsPanel, settingsPanel.getPluginName());
            this.mainPanel.setPreferredSize(new Dimension(670, 500));
            for (AbstractPlugablePanel instance : this.pluginsMap.values()) {
                this.mainPanel.add((Component)instance, instance.getPluginName());
            }
            this.setSplashStep(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Building status bar.."));
            this.statusPanel = new JStatusPanel(new ImageIcon(iconUrl16), GuiClient.getApplicationName(), 1000);
            this.getContentPane().add((Component)this.statusPanel, "Last");
            Configuration.getInstance().getConsoleServicesFacade().addExecutionObserver((Observer)this.statusPanel);
            this.setSplashStep(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Building tree.."));
            this.treePanel = new JTreePanel(new DefaultMutableTreeNode("pdfsam " + GuiClient.getVersion()));
            for (PluginDataModel item : this.pluginsMap.keySet()) {
                this.treePanel.addToPlugsNode(item);
            }
            this.treePanel.addToRootNode(settingsDataModel);
            this.treePanel.addToRootNode(infoDataModel);
            this.treePanel.getTree().addTreeSelectionListener(new TreeMediator(this));
            this.treePanel.expand();
            this.pluginsMap.put(settingsDataModel, settingsPanel);
            this.pluginsMap.put(infoDataModel, infoPanel);
            this.setSplashStep(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Building menus.."));
            this.environment = new Environment(this.pluginsMap, this.treePanel);
            SaveEnvironmentAction saveAction = new SaveEnvironmentAction(this.environment, this);
            LoadEnvironmentAction loadAction = new LoadEnvironmentAction(this.environment, this);
            ApplicationExitMediator exitMediator = new ApplicationExitMediator(new ApplicationCloser(this));
            this.menuBar = new JMainMenuBar(saveAction, loadAction, exitMediator);
            this.getRootPane().setJMenuBar(this.menuBar);
            this.environment.addObserver(new EnvironmentLoadObserver());
            this.setSplashStep(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Building buttons bar.."));
            this.buttonsPanel = new JButtonsPanel(saveAction, loadAction, exitMediator, new LogActionListener());
            this.getContentPane().add((Component)this.buttonsPanel, "First");
            this.initializeUpdateChecker(settingsPanel);
            this.mainScrollPanel = new JScrollPane(this.mainPanel);
            this.mainScrollPanel.setMinimumSize(new Dimension(100, 400));
            this.logPanel = new JLogPanel();
            this.horizSplitPane = new JSplitPane(1, this.treePanel, this.mainScrollPanel);
            this.horizSplitPane.setOneTouchExpandable(true);
            this.horizSplitPane.setDividerLocation(155);
            this.verticalSplitPane = new JSplitPane(0, this.horizSplitPane, this.logPanel);
            this.verticalSplitPane.setOneTouchExpandable(true);
            this.verticalSplitPane.setResizeWeight(1.0);
            this.verticalSplitPane.setDividerLocation(0.75);
            String defaultEnvString = Configuration.getInstance().getDefaultEnvironment();
            if (defaultEnvString != null && defaultEnvString.length() > 0 && (defaultEnv = new File(defaultEnvString)) != null && defaultEnv.exists() && defaultEnv.isFile()) {
                log.info(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Loading default environment."));
                this.environment.loadJobs(defaultEnv);
            }
            this.getContentPane().add((Component)this.verticalSplitPane, "Center");
            this.setSize(640, 480);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new MainWindowListener(this));
        }
        catch (Exception e) {
            log.fatal(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Error starting pdfsam."), e);
        }
    }

    private void initializeUpdateChecker(JSettingsPanel settingsPanel) {
        UpdateCheckerMediator updateMediator = new UpdateCheckerMediator(this.statusPanel);
        if (Configuration.getInstance().isCheckForUpdates()) {
            updateMediator.checkForUpdates(5000L, false);
        }
        settingsPanel.setCheckUpdateMediator(updateMediator);
    }

    private void runSplash() {
        this.screen = new JSplashScreen("pdfsam loader", "Initialization..");
        this.screen.setMaximumBarValue(5);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                JMainFrame.this.screen.setVisible(true);
            }
        };
        SwingUtilities.invokeLater(runner);
    }

    private void closeSplash() {
        if (this.screen != null) {
            this.screen.setVisible(false);
            this.screen.dispose();
        }
    }

    private void setSplashStep(String message) {
        if (this.screen != null) {
            this.screen.setText(message);
            this.screen.addBarValue();
        }
    }

    public JStatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    public JTreePanel getTreePanel() {
        return this.treePanel;
    }

    public JButtonsPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public Map<PluginDataModel, AbstractPlugablePanel> getPluginsMap() {
        return this.pluginsMap;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public void setMainPanelPreferredSize(Dimension d) {
        this.mainPanel.setPreferredSize(d);
    }

    public int getVerticalDividerLocation() {
        return this.verticalSplitPane.getDividerLocation();
    }

    public void setVerticalDividerLocation(int location) {
        this.verticalSplitPane.setDividerLocation(location);
    }

    public int getHorizontalDividerLocation() {
        return this.horizSplitPane.getDividerLocation();
    }

    public void setHorizontalDividerLocation(int location) {
        this.horizSplitPane.setDividerLocation(location);
    }

    public Dimension getHorizontalDividerDimension() {
        return this.horizSplitPane.getSize();
    }

    public void setHorizontalDividerDimension(Dimension d) {
        this.horizSplitPane.setSize(d);
    }

    public Dimension getVerticalDividerDimension() {
        return this.verticalSplitPane.getSize();
    }

    public void setVerticalDividerDimension(Dimension d) {
        this.verticalSplitPane.setSize(d);
    }

    public void rebuildRecentEnvironmentsMenu() {
        this.menuBar.rebuildRecentEnvironmentSubmenu(this.environment);
    }

    private class EnvironmentLoadObserver
    implements Observer {
        private EnvironmentLoadObserver() {
        }

        @Override
        public void update(Observable environment, Object loadedEnv) {
            GuiConfiguration.getInstance().addRecentEnvironment(((File)loadedEnv).getAbsolutePath());
            JMainFrame.this.rebuildRecentEnvironmentsMenu();
        }
    }
}

