/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.digest;

import de.intarsys.tools.digest.Digest;
import de.intarsys.tools.digest.Digester;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigestCodec;
import de.intarsys.tools.digest.IDigestEnvironment;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.provider.Providers;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandardDigestEnvironment
implements IDigestEnvironment {
    private IDigestCodec codec;

    protected IDigestCodec createCodec() {
        Iterator<IDigestCodec> iterator = Providers.get().lookupProviders(IDigestCodec.class);
        while (iterator.hasNext()) {
            try {
                return iterator.next();
            }
            catch (Throwable throwable) {
                Logger.getAnonymousLogger().log(Level.WARNING, "error creating codec", throwable);
            }
        }
        return null;
    }

    @Override
    public IDigest createDigest(String string, byte[] byArray) {
        return new Digest(string, byArray);
    }

    @Override
    public IDigester createDigester(String string) throws NoSuchAlgorithmException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string, "BC");
            return new Digester(string, messageDigest);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            return new Digester(string, messageDigest);
        }
    }

    @Override
    public IDigest decode(byte[] byArray) throws IOException {
        if (this.getCodec() == null) {
            throw new IOException("no digest codec installed");
        }
        return this.getCodec().decode(byArray);
    }

    @Override
    public byte[] encode(IDigest iDigest) throws IOException {
        if (this.getCodec() == null) {
            throw new IOException("no digest codec installed");
        }
        return this.getCodec().encode(iDigest);
    }

    protected IDigestCodec getCodec() {
        if (this.codec == null) {
            this.codec = this.createCodec();
        }
        return this.codec;
    }
}

