/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.facade;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.facade.FacadeFactory;
import de.intarsys.tools.facade.IFacade;
import de.intarsys.tools.facade.IFacadeFactory;

public class DelegatingFacadeFactory
extends FacadeFactory {
    private IFacadeFactory[] factories = new IFacadeFactory[10];
    private int count = 0;
    private static final Object ATTR_FACADE = new Object();

    protected IFacade basicCreate(Object object) {
        int n = 0;
        while (n < this.count) {
            IFacade iFacade = this.factories[n].createFacade(object);
            if (iFacade != null) {
                return iFacade;
            }
            ++n;
        }
        return null;
    }

    public void addFactory(IFacadeFactory iFacadeFactory) {
        if (this.count >= this.factories.length) {
            IFacadeFactory[] iFacadeFactoryArray = new IFacadeFactory[this.count + 2];
            System.arraycopy(this.factories, 0, iFacadeFactoryArray, 0, this.count);
            this.factories = iFacadeFactoryArray;
        }
        this.factories[this.count++] = iFacadeFactory;
    }

    public void removeFactory(IFacadeFactory iFacadeFactory) {
        int n = 0;
        while (n < this.count) {
            IFacadeFactory iFacadeFactory2 = this.factories[n];
            if (iFacadeFactory2 == iFacadeFactory) {
                if (n + 1 < this.count) {
                    System.arraycopy(this.factories, n + 1, this.factories, n, this.count - n - 1);
                }
                this.factories[this.count--] = null;
            }
            ++n;
        }
    }

    @Override
    public final IFacade createFacade(Object object) {
        if (object instanceof IAttributeSupport) {
            IAttributeSupport iAttributeSupport = (IAttributeSupport)object;
            IFacade iFacade = (IFacade)iAttributeSupport.getAttribute(ATTR_FACADE);
            if (iFacade == null && (iFacade = this.basicCreate(object)) != null) {
                iAttributeSupport.setAttribute(ATTR_FACADE, iFacade);
            }
            return iFacade;
        }
        if (object != null) {
            return this.basicCreate(object);
        }
        return null;
    }
}

