/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import de.intarsys.tools.logging.IHandlerFactory;
import java.io.IOException;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommonHandlerFactory
implements IHandlerFactory {
    private boolean singleton = false;
    private Level level = Level.OFF;
    private Handler singletonHandler;
    private Formatter formatter;

    protected abstract Handler basicCreateHandler() throws IOException;

    @Override
    public final synchronized Handler createLogHandler() throws IOException {
        if (this.isSingleton() && this.singletonHandler != null) {
            return this.singletonHandler;
        }
        Handler handler = this.basicCreateHandler();
        if (this.getLevel() != Level.OFF) {
            handler.setLevel(this.getLevel());
        } else {
            handler.setLevel(Logger.getLogger("").getLevel());
        }
        if (this.getFormatter() != null) {
            handler.setFormatter(this.getFormatter());
        }
        if (this.isSingleton()) {
            this.singletonHandler = handler;
        }
        return handler;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public Level getLevel() {
        return this.level;
    }

    protected Handler getSingletonHandler() {
        return this.singletonHandler;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setFormatter(Formatter formatter) {
        this.formatter = formatter;
        if (this.singletonHandler != null) {
            this.singletonHandler.setFormatter(formatter);
        }
    }

    public void setLevel(Level level) {
        this.level = level;
        if (this.singletonHandler != null) {
            this.singletonHandler.setLevel(level);
        }
    }

    public void setSingleton(boolean bl) {
        this.singleton = bl;
    }

    protected void setSingletonHandler(Handler handler) {
        this.singletonHandler = handler;
    }
}

