/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging;

import java.util.logging.Handler;
import java.util.logging.LogRecord;

public class DelegatingHandler
extends Handler {
    private final Handler baseHandler;

    public DelegatingHandler() {
        this.baseHandler = null;
    }

    public DelegatingHandler(Handler handler) {
        this.baseHandler = handler;
    }

    @Override
    public void close() throws SecurityException {
        Handler handler = this.getBaseHandler();
        if (handler != null) {
            handler.close();
        }
    }

    @Override
    public void flush() {
        Handler handler = this.getBaseHandler();
        if (handler != null) {
            handler.flush();
        }
    }

    public Handler getBaseHandler() {
        return this.baseHandler;
    }

    @Override
    public void publish(LogRecord logRecord) {
        Handler handler = this.getBaseHandler();
        if (handler != null) {
            handler.publish(logRecord);
        }
    }
}

