/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.serialize.IDeserializer;
import de.intarsys.tools.stream.FastByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class BONDeserializer
implements IDeserializer {
    private final InputStream is;
    private final FastByteArrayOutputStream os = new FastByteArrayOutputStream();
    private boolean isfloat;
    private String charset = "UTF-8";

    public BONDeserializer(InputStream inputStream) {
        this.is = inputStream;
    }

    public BONDeserializer(InputStream inputStream, String string) {
        this.is = inputStream;
        this.charset = string;
    }

    @Override
    public Object deserialize() throws IOException {
        this.os.reset();
        int n = this.is.read();
        while (this.isWhitespace(n)) {
            n = this.is.read();
        }
        if (n == -1) {
            return null;
        }
        if (n >= 48 && n <= 57 || n == 43 || n == 46 || n == 45) {
            this.isfloat = n == 46;
            this.os.write(n);
            return this.deserializeNumber();
        }
        if (this.isLetter(n)) {
            this.os.write(n);
            String string = this.deserializeToken();
            if ("null".equals(string)) {
                return null;
            }
            if ("true".equals(string)) {
                return true;
            }
            if ("false".equals(string)) {
                return false;
            }
            throw new IOException("unexpected token '" + string + "'");
        }
        if (n == 34) {
            return this.deserializeString();
        }
        if (n == 64) {
            return this.deserializeBase64();
        }
        if (n == 35) {
            return this.deserializeBinary();
        }
        throw new IOException("unexpected character " + (char)n + " (" + n + ")");
    }

    protected Object deserializeBase64() throws IOException {
        int n = this.is.read();
        while (n != -1) {
            if (n == 64) break;
            this.os.write(n);
            n = this.is.read();
        }
        return Base64.decode(this.os.toByteArray(), 0, this.os.size());
    }

    protected Object deserializeBinary() throws IOException {
        int n = this.is.read();
        while (n != -1) {
            if (n == 35 && (n = this.is.read()) != 35) break;
            this.os.write(n);
            n = this.is.read();
        }
        return this.os.getBytes();
    }

    protected Object deserializeNumber() throws IOException {
        int n = this.is.read();
        while (n != -1) {
            if (!this.isNumber(n) && n != 46) break;
            this.isfloat = this.isfloat || n == 46;
            this.os.write(n);
            n = this.is.read();
        }
        String string = new String(this.os.getBytes(), 0, this.os.size());
        if (this.isfloat) {
            return Float.valueOf(Float.parseFloat(string));
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return Long.parseLong(string);
        }
    }

    protected String deserializeString() throws IOException {
        int n = this.is.read();
        while (n != -1) {
            if (n == 92) {
                n = this.is.read();
                if (n == -1) break;
                this.os.write(n);
                n = this.is.read();
                continue;
            }
            if (n == 34) break;
            this.os.write(n);
            n = this.is.read();
        }
        return new String(this.os.getBytes(), 0, this.os.size(), this.getCharset());
    }

    protected String deserializeToken() throws IOException {
        int n = this.is.read();
        while (n != -1) {
            if (!this.isLetter(n)) break;
            this.os.write(n);
            n = this.is.read();
        }
        return new String(this.os.getBytes(), 0, this.os.size());
    }

    public String getCharset() {
        return this.charset;
    }

    protected boolean isLetter(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90;
    }

    protected boolean isNumber(int n) {
        return n >= 48 && n <= 57;
    }

    protected boolean isWhitespace(int n) {
        return n == 32 || n == 9 || n == 10;
    }

    public void setCharset(String string) {
        this.charset = string;
    }
}

