/*
 * Decompiled with CFR 0.152.
 */
package jcmdline;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jcmdline.CmdLineException;
import jcmdline.CmdLineParser;
import jcmdline.OptionTakesNoValue;
import jcmdline.Parameter;
import jcmdline.Strings;
import jcmdline.TextUsageFormatter;
import jcmdline.UsageFormatter;

public class PosixCmdLineParser
implements CmdLineParser {
    private UsageFormatter usageFormatter;

    public PosixCmdLineParser() {
        this.setUsageFormatter(new TextUsageFormatter());
    }

    public void parse(String[] clargs, Map opts, List args) throws CmdLineException {
        if (clargs == null) {
            clargs = new String[]{};
        }
        int i = this.processOptions(clargs, opts);
        this.processArguments(i, clargs, args);
    }

    public void setUsageFormatter(UsageFormatter usageFormatter) {
        this.usageFormatter = usageFormatter;
    }

    public UsageFormatter getUsageFormatter() {
        return this.usageFormatter;
    }

    private int processOptions(String[] params, Map options) throws CmdLineException {
        int i;
        for (i = 0; i < params.length; ++i) {
            Parameter p;
            String val = null;
            if (params[i].equals("--")) {
                ++i;
                break;
            }
            if (!params[i].startsWith("-")) break;
            int tagIdx = 1;
            if (params[i].startsWith("--")) {
                tagIdx = 2;
            }
            if (params[i].length() == tagIdx) {
                throw new CmdLineException(Strings.get("PosixCmdLineParser.optionNoTag"));
            }
            String tag = params[i].substring(tagIdx);
            int equalsIdx = tag.indexOf("=");
            if (equalsIdx != -1) {
                val = tag.substring(equalsIdx + 1);
                tag = tag.substring(0, equalsIdx);
            }
            if ((p = this.findMatchingOption(tag, options)) instanceof OptionTakesNoValue) {
                if (val == null) {
                    val = ((OptionTakesNoValue)((Object)p)).getDefaultValue();
                }
            } else if (val == null) {
                if (i == params.length - 1) {
                    throw new CmdLineException(Strings.get("PosixCmdLineParser.missingOptionValue", new Object[]{tag}));
                }
                val = params[++i];
            }
            p.addValue(val);
        }
        return i;
    }

    private void processArguments(int stIdx, String[] params, List args) throws CmdLineException {
        int argIdx = 0;
        for (int pIdx = stIdx; pIdx < params.length; ++pIdx) {
            if (argIdx >= args.size()) {
                throw new CmdLineException(Strings.get("PosixCmdLineParser.extraArg", new Object[]{params[pIdx]}));
            }
            Parameter p = (Parameter)args.get(argIdx);
            p.addValue(params[pIdx]);
            if (p.isMultiValued()) continue;
            ++argIdx;
        }
    }

    private Parameter findMatchingOption(String tag, Map options) throws CmdLineException {
        String lctag = tag.toLowerCase();
        String fulltag = null;
        if (options.containsKey(lctag)) {
            return (Parameter)options.get(lctag);
        }
        Iterator itr = options.keySet().iterator();
        while (itr.hasNext()) {
            String tmptag = (String)itr.next();
            if (((Parameter)options.get(tmptag)).isHidden() || !tmptag.startsWith(lctag)) continue;
            if (fulltag != null) {
                throw new CmdLineException(Strings.get("PosixCmdLineParser.ambiguousOption", new Object[]{"-" + tag}));
            }
            fulltag = tmptag;
        }
        if (fulltag == null) {
            throw new CmdLineException(Strings.get("PosixCmdLineParser.invalidOption", new Object[]{tag}));
        }
        return (Parameter)options.get(fulltag);
    }
}

