/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.plugin.split.components;

import java.math.BigDecimal;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import org.pdfsam.guiclient.configuration.Configuration;
import org.pdfsam.i18n.GettextResource;

public class JSplitSizeCombo
extends JComboBox {
    private static final long serialVersionUID = 1342525636090510279L;
    private Pattern pattern = Pattern.compile("^(\\d+[.[0-9]+]*)(\\s*)([KB||MB]+)", 2);
    public static final String KB = "KB";
    public static final String MB = "MB";

    public JSplitSizeCombo() {
        this.init();
    }

    private void init() {
        this.setEditable(true);
        this.addItem("");
        this.addItem("500 KB");
        this.addItem("1 MB");
        this.addItem("3 MB");
        this.addItem("5 MB");
        this.addItem("10 MB");
    }

    public long getSelectedBytes() throws Exception {
        long retVal = 0L;
        if (this.isValidSelectedItem()) {
            Matcher m = this.pattern.matcher((String)this.getSelectedItem());
            m.reset();
            m.matches();
            BigDecimal value = new BigDecimal(m.group(1));
            String unit = m.group(3);
            if (KB.equals(unit.toUpperCase())) {
                value = value.multiply(new BigDecimal(1024));
            } else if (MB.equals(unit.toUpperCase())) {
                value = value.multiply(new BigDecimal(0x100000));
            } else {
                throw new Exception(GettextResource.gettext((ResourceBundle)Configuration.getInstance().getI18nResourceBundle(), (String)"Invalid unit: ") + unit);
            }
            retVal = value.longValue();
        }
        return retVal;
    }

    public boolean isValidSelectedItem() {
        this.pattern.matcher((String)this.getSelectedItem()).reset();
        return this.pattern.matcher((String)this.getSelectedItem()).matches();
    }

    public boolean isSelectedItem() {
        return this.getSelectedItem() != null && ((String)this.getSelectedItem()).trim().length() > 0;
    }
}

