/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter.swt;

import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsContext;
import de.intarsys.cwt.swt.environment.CwtSwtGraphicsEnvironment;
import de.intarsys.cwt.swt.image.CwtSwtImage;
import de.intarsys.cwt.swt.image.ImageConverterAwt2Swt;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.pd.PDAxialShading;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDTilingPattern;
import de.intarsys.pdf.platform.cwt.adapter.CommonGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.adapter.awt.AwtGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.swt.ImageConverterPdf2Swt;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;
import de.intarsys.pdf.platform.cwt.rendering.CSPlatformRenderer;
import de.intarsys.tools.attribute.Attribute;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Transform;

public class SwtGraphicsEnvironmentAdapter
extends CommonGraphicsEnvironmentAdapter {
    private static SwtGraphicsEnvironmentAdapter ACTIVE;
    private static final Attribute ATTR_EXCEPTION;
    private static final Attribute ATTR_IMAGE;

    static {
        ATTR_EXCEPTION = new Attribute("swtException");
        ATTR_IMAGE = new Attribute("swtImage");
    }

    public static SwtGraphicsEnvironmentAdapter get() {
        return ACTIVE;
    }

    public SwtGraphicsEnvironmentAdapter() {
        ACTIVE = this;
    }

    protected synchronized ImageData createImage(PDImage pDImage) {
        ImageData imageData = (ImageData)pDImage.getAttribute((Object)ATTR_IMAGE);
        if (imageData == null) {
            RuntimeException runtimeException = (RuntimeException)pDImage.getAttribute((Object)ATTR_EXCEPTION);
            if (runtimeException != null) {
                throw runtimeException;
            }
            ImageConverterPdf2Swt imageConverterPdf2Swt = new ImageConverterPdf2Swt(pDImage);
            try {
                imageData = imageConverterPdf2Swt.getImageData();
                pDImage.setAttribute((Object)ATTR_IMAGE, (Object)imageData);
            }
            catch (RuntimeException runtimeException2) {
                pDImage.setAttribute((Object)ATTR_EXCEPTION, (Object)runtimeException2);
                throw runtimeException2;
            }
        }
        return imageData;
    }

    protected ImageData createImage(PDImage pDImage, float[] fArray) {
        ImageData imageData;
        int n = (int)(fArray[0] * 255.0f);
        int n2 = (int)(fArray[1] * 255.0f);
        int n3 = (int)(fArray[2] * 255.0f);
        String string = "swt-iimage-" + (n << 16 | n2 << 8 | n3);
        SoftReference softReference = (SoftReference)pDImage.getAttribute((Object)string);
        if (softReference != null && (imageData = (ImageData)softReference.get()) != null) {
            return imageData;
        }
        BufferedImage bufferedImage = AwtGraphicsEnvironmentAdapter.get().createImage(pDImage, fArray);
        ImageConverterAwt2Swt imageConverterAwt2Swt = new ImageConverterAwt2Swt(bufferedImage);
        imageData = imageConverterAwt2Swt.getImageData();
        pDImage.setAttribute((Object)string, new SoftReference<ImageData>(imageData));
        return imageData;
    }

    protected Color createResourceColorPaint(Device device, ColorPaint colorPaint) {
        float[] fArray;
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(colorPaint.getPdColorSpace());
        float[] fArray2 = colorPaint.getColorValues();
        if (fArray2 == null) {
            fArray = new float[]{0.0f, 0.0f, 0.0f};
        } else {
            try {
                fArray = awtColorSpace.getRGB(fArray2);
            }
            catch (RuntimeException runtimeException) {
                fArray = AwtColorSpace.FALLBACK.toRGB(fArray2);
            }
        }
        Color color = new Color(device, (int)(fArray[0] * 255.0f), (int)(fArray[1] * 255.0f), (int)(fArray[2] * 255.0f));
        return color;
    }

    protected Pattern createResourceDummyPaint(Device device) {
        Color color = new Color(device, 128, 128, 128);
        Pattern pattern = new Pattern(device, 0.0f, 0.0f, 1.0f, 0.0f, color, 128, color, 128);
        color.dispose();
        return pattern;
    }

    protected Pattern createResourcePatternPaint(Device device, PatternPaint patternPaint) {
        Image image;
        block6: {
            if (!(patternPaint.getPdPattern() instanceof PDTilingPattern)) {
                return this.createResourceDummyPaint(device);
            }
            PDTilingPattern pDTilingPattern = (PDTilingPattern)patternPaint.getPdPattern();
            image = new Image(device, (int)pDTilingPattern.getXStep(), (int)pDTilingPattern.getYStep());
            GC gC = new GC((Drawable)image);
            CwtSwtGraphicsContext cwtSwtGraphicsContext = new CwtSwtGraphicsContext(gC, device);
            try {
                try {
                    cwtSwtGraphicsContext.scale(1.0f, -1.0f);
                    cwtSwtGraphicsContext.translate(0.0f, (float)(0 - (int)pDTilingPattern.getYStep()));
                    cwtSwtGraphicsContext.setClip((Shape)pDTilingPattern.getBoundingBox().toNormalizedRectangle());
                    CSPlatformRenderer cSPlatformRenderer = new CSPlatformRenderer(new HashMap(), (IGraphicsContext)cwtSwtGraphicsContext);
                    cSPlatformRenderer.process(pDTilingPattern.getContentStream(), pDTilingPattern.getResources());
                }
                catch (CSException cSException) {
                    cwtSwtGraphicsContext.dispose();
                    gC.dispose();
                    break block6;
                }
            }
            catch (Throwable throwable) {
                cwtSwtGraphicsContext.dispose();
                gC.dispose();
                throw throwable;
            }
            cwtSwtGraphicsContext.dispose();
            gC.dispose();
        }
        ImagePattern imagePattern = new ImagePattern(device, image);
        return imagePattern;
    }

    protected Pattern createResourceShadingPaint(Device device, ShadingPaint shadingPaint) {
        if (!(shadingPaint.getPdShading() instanceof PDAxialShading)) {
            return this.createResourceDummyPaint(device);
        }
        PDAxialShading pDAxialShading = (PDAxialShading)shadingPaint.getPdShading();
        float[] fArray = pDAxialShading.getCoords();
        float[] fArray2 = pDAxialShading.getDomain();
        PDFunction pDFunction = pDAxialShading.getFunction();
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(shadingPaint.getPdShading().getColorSpace());
        float[] fArray3 = awtColorSpace.getRGB(pDFunction.evaluate(new float[]{fArray2[0]}));
        Color color = new Color(device, (int)(fArray3[0] * 255.0f), (int)(fArray3[1] * 255.0f), (int)(fArray3[2] * 255.0f));
        fArray3 = awtColorSpace.getRGB(pDFunction.evaluate(new float[]{fArray2[1]}));
        Color color2 = new Color(device, (int)(fArray3[0] * 255.0f), (int)(fArray3[1] * 255.0f), (int)(fArray3[2] * 255.0f));
        Pattern pattern = new Pattern(device, fArray[0], fArray[1], fArray[2], fArray[3], color, (int)(shadingPaint.getAlphaValue() * 255.0f), color2, (int)(shadingPaint.getAlphaValue() * 255.0f));
        color.dispose();
        color2.dispose();
        return pattern;
    }

    @Override
    public void drawImage(IGraphicsContext iGraphicsContext, PDImage pDImage, float f, float f2) {
        ImageData imageData = this.createImage(pDImage);
        if (pDImage.isImageMask()) {
            float[] fArray = iGraphicsContext.getBackgroundColor().getRGBColorComponents(null);
            imageData = this.createImage(pDImage, fArray);
        }
        float f3 = pDImage.getWidth();
        float f4 = pDImage.getHeight();
        float f5 = imageData.width;
        float f6 = imageData.height;
        float f7 = f;
        float f8 = f2;
        Transform transform = null;
        Transform transform2 = null;
        GC gC = ((CwtSwtGraphicsContext)iGraphicsContext).getGc();
        if (f4 < f6 || f3 < f5) {
            transform = new Transform(gC.getDevice());
            gC.getTransform(transform);
            float[] fArray = new float[6];
            transform.getElements(fArray);
            transform2 = new Transform(gC.getDevice(), fArray);
            float f9 = f3 / f5;
            float f10 = f4 / f6;
            transform2.scale(f9, f10);
            f7 = f / f9;
            f8 = f2 / f10;
            gC.setTransform(transform2);
            transform2.dispose();
        }
        try {
            new CwtSwtImage(imageData).drawFromGraphicsContext(iGraphicsContext, f7, f8);
        }
        finally {
            if (transform != null) {
                gC.setTransform(transform);
                transform.dispose();
            }
        }
    }

    @Override
    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtSwtGraphicsEnvironment.get();
    }

    @Override
    public void setBackgroundColorPaint(IGraphicsContext iGraphicsContext, ColorPaint colorPaint) {
        CwtSwtGraphicsContext cwtSwtGraphicsContext = (CwtSwtGraphicsContext)iGraphicsContext;
        Color color = this.createResourceColorPaint(cwtSwtGraphicsContext.getDevice(), colorPaint);
        cwtSwtGraphicsContext.setBackgroundColor(color);
    }

    @Override
    public void setBackgroundPatternPaint(IGraphicsContext iGraphicsContext, PatternPaint patternPaint) {
        CwtSwtGraphicsContext cwtSwtGraphicsContext = (CwtSwtGraphicsContext)iGraphicsContext;
        Pattern pattern = this.createResourcePatternPaint(cwtSwtGraphicsContext.getDevice(), patternPaint);
        cwtSwtGraphicsContext.setBackgroundPattern(pattern);
    }

    @Override
    public void setBackgroundShadingPaint(IGraphicsContext iGraphicsContext, ShadingPaint shadingPaint) {
        CwtSwtGraphicsContext cwtSwtGraphicsContext = (CwtSwtGraphicsContext)iGraphicsContext;
        Pattern pattern = this.createResourceShadingPaint(cwtSwtGraphicsContext.getDevice(), shadingPaint);
        cwtSwtGraphicsContext.setBackgroundPattern(pattern);
    }

    @Override
    public void setForegroundColorPaint(IGraphicsContext iGraphicsContext, ColorPaint colorPaint) {
        CwtSwtGraphicsContext cwtSwtGraphicsContext = (CwtSwtGraphicsContext)iGraphicsContext;
        Color color = this.createResourceColorPaint(cwtSwtGraphicsContext.getDevice(), colorPaint);
        cwtSwtGraphicsContext.setForegroundColor(color);
    }

    @Override
    public void setForegroundPatternPaint(IGraphicsContext iGraphicsContext, PatternPaint patternPaint) {
        CwtSwtGraphicsContext cwtSwtGraphicsContext = (CwtSwtGraphicsContext)iGraphicsContext;
        Pattern pattern = this.createResourcePatternPaint(cwtSwtGraphicsContext.getDevice(), patternPaint);
        cwtSwtGraphicsContext.setForegroundPattern(pattern);
    }

    @Override
    public void setForegroundShadingPaint(IGraphicsContext iGraphicsContext, ShadingPaint shadingPaint) {
        CwtSwtGraphicsContext cwtSwtGraphicsContext = (CwtSwtGraphicsContext)iGraphicsContext;
        Pattern pattern = this.createResourceShadingPaint(cwtSwtGraphicsContext.getDevice(), shadingPaint);
        cwtSwtGraphicsContext.setForegroundPattern(pattern);
    }

    static class ImagePattern
    extends Pattern {
        private Image image;

        public ImagePattern(Device device, Image image) {
            super(device, image);
            this.image = image;
        }

        public void dispose() {
            super.dispose();
            this.image.dispose();
        }
    }
}

