/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.awt.PlatformImageTools;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.operator.BandMergeDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.InvertDescriptor;
import javax.media.jai.operator.ScaleDescriptor;

public class ImageConverterPdf2Awt {
    private static final float MAX_SCALE = 400000.0f;
    private BufferedImage bufferedImage;
    private final PDImage pdImage;

    protected static BufferedImage createBufferedImage(PDImage pDImage) {
        COSStream cOSStream = pDImage.cosGetStream();
        if (!pDImage.hasTransparency() && (cOSStream.hasFilter(Filter.CN_Filter_DCTDecode) || cOSStream.hasFilter(Filter.CN_Filter_DCT) || cOSStream.hasFilter(Filter.CN_Filter_JPXDecode))) {
            try {
                return ImageConverterPdf2Awt.createBufferedImageFromJPEG(pDImage, pDImage.cosExtractJPEGStream());
            }
            catch (ImageException imageException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            ColorModel colorModel = ImageConverterPdf2Awt.getColorModel(pDImage);
            WritableRaster writableRaster = ImageConverterPdf2Awt.createRaster(pDImage, colorModel);
            return new BufferedImage(colorModel, writableRaster, false, null);
        }
        catch (ImageException imageException) {
            throw imageException;
        }
        catch (Exception exception) {
            throw new ImageException((Throwable)exception);
        }
    }

    protected static BufferedImage createBufferedImageFromJPEG(PDImage pDImage, COSStream cOSStream) throws IOException {
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cOSStream.getEncodedBytes());
        try {
            string = ImageTools.extractJPEGColorSpaceType((InputStream)byteArrayInputStream);
        }
        catch (ImageException imageException) {
            string = "YCbCr";
        }
        if (!("GRAY".equals(string) || "RGB".equals(string) || "YCbCr".equals(string))) {
            throw new ImageException("AWT non-RGB/GRAY JPEG not supported");
        }
        if (!PlatformImageTools.matchColorSpace(pDImage, string)) {
            throw new ImageException("PD color space does not match JPEG metadata");
        }
        ((InputStream)byteArrayInputStream).reset();
        return ImageIO.read(byteArrayInputStream);
    }

    protected static WritableRaster createDirectRaster(PDImage pDImage, ColorModel colorModel, byte[] byArray) {
        int n = pDImage.getBitsPerComponent();
        DataBufferByte dataBufferByte = new DataBufferByte(byArray, byArray.length);
        if (n == 1 || n == 2 || n == 4) {
            return Raster.createPackedRaster(dataBufferByte, pDImage.getWidth(), pDImage.getHeight(), n, new Point(0, 0));
        }
        if (n == 8) {
            int n2 = colorModel instanceof IndexColorModel ? 1 : colorModel.getNumComponents();
            int[] nArray = new int[n2];
            int n3 = 0;
            while (n3 < nArray.length) {
                nArray[n3] = n3;
                ++n3;
            }
            return Raster.createInterleavedRaster(dataBufferByte, pDImage.getWidth(), pDImage.getHeight(), pDImage.getWidth() * n2, n2, nArray, new Point(0, 0));
        }
        throw new ImageException("unsupported component depth " + n);
    }

    protected static WritableRaster createRaster(PDImage pDImage, ColorModel colorModel) throws IOException {
        if (pDImage.cosGetStream().hasFilter(Filter.CN_Filter_DCTDecode) || pDImage.cosGetStream().hasFilter(Filter.CN_Filter_JPXDecode)) {
            WritableRaster writableRaster = ImageConverterPdf2Awt.createRasterFromJPEG(pDImage, pDImage.cosExtractJPEGStream());
            return writableRaster;
        }
        return ImageConverterPdf2Awt.createDirectRaster(pDImage, colorModel, pDImage.getAdjustedBytes(colorModel.createCompatibleSampleModel(1, 1).getNumBands()));
    }

    protected static WritableRaster createRasterFromAnyJPEG(PDImage pDImage, InputStream inputStream) throws IOException {
        inputStream.reset();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        try {
            String string;
            ImageReader imageReader = ImageIO.getImageReaders(imageInputStream).next();
            imageReader.setInput(imageInputStream);
            WritableRaster writableRaster = (WritableRaster)imageReader.readRaster(0, null);
            try {
                string = ImageTools.extractJPEGColorSpaceType((ImageReader)imageReader);
            }
            catch (ImageException imageException) {
                WritableRaster writableRaster2 = writableRaster;
                imageReader.reset();
                imageReader.dispose();
                imageInputStream.close();
                return writableRaster2;
            }
            try {
                byte[] byArray = (byte[])writableRaster.getDataElements(0, 0, pDImage.getWidth(), pDImage.getHeight(), null);
                if (string.equals("YCCK") && pDImage.getColorSpace() == PDCSDeviceCMYK.SINGLETON) {
                    int n = 0;
                    while (n < byArray.length / 4) {
                        double d = 0xFF & byArray[n * 4];
                        double d2 = (0xFF & byArray[n * 4 + 1]) - 128;
                        double d3 = (0xFF & byArray[n * 4 + 2]) - 128;
                        double d4 = d + 1.402 * d3;
                        double d5 = d - 0.34414 * d2 - 0.71414 * d3;
                        double d6 = d + 1.772 * d2;
                        if (d4 < 0.0) {
                            d4 = 0.0;
                        }
                        if (d4 > 255.0) {
                            d4 = 255.0;
                        }
                        if (d5 < 0.0) {
                            d5 = 0.0;
                        }
                        if (d5 > 255.0) {
                            d5 = 255.0;
                        }
                        if (d6 < 0.0) {
                            d6 = 0.0;
                        }
                        if (d6 > 255.0) {
                            d6 = 255.0;
                        }
                        byArray[n * 4] = (byte)(255.0 - d4);
                        byArray[n * 4 + 1] = (byte)(255.0 - d5);
                        byArray[n * 4 + 2] = (byte)(255.0 - d6);
                        ++n;
                    }
                }
                AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDImage.getColorSpace());
                WritableRaster writableRaster3 = ImageConverterPdf2Awt.createDirectRaster(pDImage, new ComponentColorModel(awtColorSpace.getColorSpace(), false, false, 1, 0), byArray);
                imageReader.reset();
                imageReader.dispose();
                return writableRaster3;
            }
            catch (Throwable throwable) {
                imageReader.reset();
                imageReader.dispose();
                throw throwable;
            }
        }
        finally {
            imageInputStream.close();
        }
    }

    protected static WritableRaster createRasterFromJPEG(PDImage pDImage, COSStream cOSStream) throws IOException {
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cOSStream.getEncodedBytes());
        try {
            string = ImageTools.extractJPEGColorSpaceType((InputStream)byteArrayInputStream);
        }
        catch (ImageException imageException) {
            string = "YCbCr";
        }
        ((InputStream)byteArrayInputStream).reset();
        if ("YCbCr".equals(string)) {
            try {
                return ImageConverterPdf2Awt.createRasterFromYCbCrJPEG(byteArrayInputStream);
            }
            catch (ImageException imageException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ImageConverterPdf2Awt.createRasterFromAnyJPEG(pDImage, byteArrayInputStream);
    }

    protected static WritableRaster createRasterFromYCbCrJPEG(InputStream inputStream) throws IOException {
        BufferedImage bufferedImage = ImageIO.read(inputStream);
        if (bufferedImage == null) {
            throw new ImageException("Couldn't read JPEG");
        }
        return bufferedImage.getRaster();
    }

    protected static ColorModel getColorModel(PDImage pDImage) {
        if (pDImage.isImageMask()) {
            int[] nArray = new int[2];
            nArray[1] = -1;
            return new IndexColorModel(1, 2, nArray, 0, false, -1, 0);
        }
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(pDImage.getColorSpace());
        return awtColorSpace.getColorModel(pDImage);
    }

    public ImageConverterPdf2Awt(PDImage pDImage) {
        this.pdImage = pDImage;
    }

    protected BufferedImage createBufferedImage() {
        BufferedImage bufferedImage = ImageConverterPdf2Awt.createBufferedImage(this.pdImage);
        if (!this.pdImage.hasTransparency()) {
            return bufferedImage;
        }
        return this.mergeMask(bufferedImage);
    }

    protected RenderedImage createColorKeyMask(BufferedImage bufferedImage, byte[][] byArray) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        SampleModel sampleModel = bufferedImage.getSampleModel();
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        byte[] byArray2 = new byte[sampleModel.getNumBands()];
        ComponentColorModel componentColorModel = CwtAwtImageTools.getGrayColorModel();
        WritableRaster writableRaster = ((ColorModel)componentColorModel).createCompatibleWritableRaster(n, n2);
        byte[] byArray3 = new byte[]{-1};
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                boolean bl = false;
                sampleModel.getDataElements(n3, n4, byArray2, dataBuffer);
                int n5 = 0;
                while (n5 < byArray2.length) {
                    if ((byArray2[n5] & 0xFF) < (byArray[0][n5] & 0xFF)) {
                        bl = true;
                        break;
                    }
                    if ((byArray2[n5] & 0xFF) > (byArray[1][n5] & 0xFF)) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
                if (bl) {
                    writableRaster.setDataElements(n3, n4, byArray3);
                }
                ++n4;
            }
            ++n3;
        }
        BufferedImage bufferedImage2 = new BufferedImage(componentColorModel, writableRaster, false, null);
        return bufferedImage2;
    }

    public BufferedImage getBufferedImage() {
        if (this.bufferedImage == null) {
            this.bufferedImage = this.createBufferedImage();
        }
        return this.bufferedImage;
    }

    public PDImage getPDImage() {
        return this.pdImage;
    }

    protected BufferedImage mergeMask(BufferedImage bufferedImage) {
        RenderedImage renderedImage;
        ImageLayout imageLayout;
        ColorModel colorModel;
        Object object;
        BufferedImage bufferedImage2 = bufferedImage;
        if (this.pdImage.getMaskImage() != null) {
            object = ImageConverterPdf2Awt.createBufferedImage(this.pdImage.getMaskImage());
            if (this.pdImage.getMaskImage().isImageMask()) {
                colorModel = CwtAwtImageTools.getGrayColorModel();
                imageLayout = new ImageLayout(0, 0, ((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight(), colorModel.createCompatibleSampleModel(((BufferedImage)object).getWidth(), ((BufferedImage)object).getHeight()), colorModel);
                renderedImage = FormatDescriptor.create((RenderedImage)object, (Integer)0, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
                renderedImage = InvertDescriptor.create((RenderedImage)renderedImage, null);
            } else {
                renderedImage = object;
            }
        } else if (this.pdImage.getSMask() != null) {
            renderedImage = ImageConverterPdf2Awt.createBufferedImage((PDImage)this.pdImage.getSMask());
        } else {
            object = this.pdImage.getColorKeyMask(bufferedImage.getSampleModel().getNumBands());
            renderedImage = this.createColorKeyMask(bufferedImage, (byte[][])object);
        }
        float f = 1.0f;
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (bufferedImage2.getWidth() >= renderedImage.getWidth()) {
            f3 = (float)bufferedImage2.getWidth() / (float)renderedImage.getWidth();
        } else {
            f = (float)renderedImage.getWidth() / (float)bufferedImage2.getWidth();
        }
        if (bufferedImage2.getHeight() >= renderedImage.getHeight()) {
            f4 = (float)bufferedImage2.getHeight() / (float)renderedImage.getHeight();
        } else {
            f2 = (float)renderedImage.getHeight() / (float)bufferedImage2.getHeight();
        }
        if (f * f2 > 400000.0f) {
            float f5 = 400000.0f / (f * f2);
            f *= f5;
            f2 *= f5;
            f3 *= f5;
            f4 *= f5;
        }
        if (f3 * f4 > 400000.0f) {
            float f6 = 400000.0f / (f3 * f4);
            f *= f6;
            f2 *= f6;
            f3 *= f6;
            f4 *= f6;
        }
        if (f != 1.0f || f2 != 1.0f) {
            bufferedImage2 = ScaleDescriptor.create((RenderedImage)bufferedImage2, (Float)Float.valueOf(f), (Float)Float.valueOf(f2), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)0), null);
        }
        if (f3 != 1.0f || f4 != 1.0f) {
            renderedImage = ScaleDescriptor.create((RenderedImage)renderedImage, (Float)Float.valueOf(f3), (Float)Float.valueOf(f4), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)0), null);
        }
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        colorModel = renderedImage.getColorModel();
        if (!(colorModel instanceof ComponentColorModel)) {
            colorModel = CwtAwtImageTools.getGrayColorModel();
            imageLayout = new ImageLayout(0, 0, 512, 512, colorModel.createCompatibleSampleModel(n, n2), colorModel);
            renderedImage = FormatDescriptor.create((RenderedImage)renderedImage, (Integer)0, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        }
        if (!((colorModel = bufferedImage2.getColorModel()) instanceof ComponentColorModel)) {
            colorModel = CwtAwtImageTools.getRgbColorModel();
            imageLayout = new ImageLayout(0, 0, n, n2, colorModel.createCompatibleSampleModel(n, n2), colorModel);
            bufferedImage2 = FormatDescriptor.create((RenderedImage)bufferedImage2, (Integer)0, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        }
        colorModel = new ComponentColorModel(colorModel.getColorSpace(), true, false, 3, colorModel.getTransferType());
        imageLayout = new ImageLayout(0, 0, n, n2, colorModel.createCompatibleSampleModel(n, n2), colorModel);
        return BandMergeDescriptor.create((RenderedImage)bufferedImage2, (RenderedImage)renderedImage, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout)).getRendering().getAsBufferedImage();
    }
}

