/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.swt;

import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.cwt.swt.image.ImageConverterAwt2Swt;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.swt.SwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.swt.SwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.awt.ImageConverterPdf2Awt;
import de.intarsys.pdf.platform.cwt.image.awt.PlatformImageTools;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;

public class ImageConverterPdf2Swt {
    private final PDImage pdImage;
    private ImageData imageData;

    public ImageConverterPdf2Swt(PDImage pDImage) {
        this.pdImage = pDImage;
    }

    protected ImageData createImageData() {
        if (!this.pdImage.hasTransparency()) {
            try {
                ImageData imageData = this.createPrimaryImageData();
                return imageData;
            }
            catch (ImageException imageException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ImageConverterPdf2Awt imageConverterPdf2Awt = new ImageConverterPdf2Awt(this.getPDImage());
        BufferedImage bufferedImage = imageConverterPdf2Awt.getBufferedImage();
        ImageConverterAwt2Swt imageConverterAwt2Swt = new ImageConverterAwt2Swt(bufferedImage);
        return imageConverterAwt2Swt.getImageData();
    }

    protected ImageData createImageDataFromJPEG(COSStream cOSStream) throws IOException {
        ImageData[] imageDataArray;
        String string;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cOSStream.getEncodedBytes());
        try {
            string = ImageTools.extractJPEGColorSpaceType((InputStream)byteArrayInputStream);
        }
        catch (ImageException imageException) {
            string = "YCbCr";
        }
        if (!("GRAY".equals(string) || "RGB".equals(string) || "YCbCr".equals(string))) {
            throw new ImageException("SWT non-RGB/GRAY JPEG not supported");
        }
        if (!PlatformImageTools.matchColorSpace(this.pdImage, string)) {
            throw new ImageException("PD color space does not match JPEG metadata");
        }
        ((InputStream)byteArrayInputStream).reset();
        try {
            imageDataArray = new ImageLoader().load((InputStream)byteArrayInputStream);
        }
        catch (SWTException sWTException) {
            throw new ImageException("SWT JPEG decoding error");
        }
        if (imageDataArray[0].data.length == 0) {
            throw new ImageException("SWT JPEG decoding error");
        }
        return imageDataArray[0];
    }

    protected ImageData createPrimaryImageData() {
        if (this.pdImage.cosGetStream().hasFilter(Filter.CN_Filter_JPXDecode)) {
            throw new ImageException("SWT JPX stream not supported");
        }
        if (this.pdImage.cosGetStream().hasFilter(Filter.CN_Filter_DCTDecode) || this.pdImage.cosGetStream().hasFilter(Filter.CN_Filter_DCT)) {
            try {
                return this.createImageDataFromJPEG(this.pdImage.cosExtractJPEGStream());
            }
            catch (IOException iOException) {
                throw new ImageException("SWT JPEG decoding error");
            }
        }
        try {
            SwtColorSpace swtColorSpace = SwtColorSpaceFactory.get().createPlatformColorSpace(this.pdImage.getColorSpace());
            PaletteData paletteData = swtColorSpace.getPalette(this.pdImage);
            int n = swtColorSpace.getNumComponents();
            ImageData imageData = new ImageData(this.pdImage.getWidth(), this.pdImage.getHeight(), this.pdImage.getBitsPerComponent() * n, paletteData, (this.pdImage.getBitsPerComponent() * n + 7) / 8, this.pdImage.getAdjustedBytes(n));
            return imageData;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw new ImageException("SWT color space not supported", (Throwable)unsupportedOperationException);
        }
    }

    public ImageData getImageData() throws ImageException {
        if (this.imageData == null) {
            this.imageData = this.createImageData();
        }
        return this.imageData;
    }

    public PDImage getPDImage() {
        return this.pdImage;
    }
}

