/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCompleteTextField;
import com.eteks.sweethome3d.swing.ColorButton;
import com.eteks.sweethome3d.swing.ImportedFurnitureWizardStepsPanel;
import com.eteks.sweethome3d.swing.NullableCheckBox;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.ModelMaterialsController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.security.AccessControlException;
import javax.swing.AbstractSpinnerModel;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class HomeFurniturePanel
extends JPanel
implements DialogView {
    private final HomeFurnitureController controller;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel descriptionLabel;
    private JTextField descriptionTextField;
    private NullableCheckBox nameVisibleCheckBox;
    private JLabel priceLabel;
    private JSpinner priceSpinner;
    private JLabel xLabel;
    private JSpinner xSpinner;
    private JLabel yLabel;
    private JSpinner ySpinner;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private JLabel angleLabel;
    private JSpinner angleSpinner;
    private NullableCheckBox basePlanItemCheckBox;
    private JLabel widthLabel;
    private JSpinner widthSpinner;
    private JLabel depthLabel;
    private JSpinner depthSpinner;
    private JLabel heightLabel;
    private JSpinner heightSpinner;
    private JCheckBox keepProportionsCheckBox;
    private NullableCheckBox mirroredModelCheckBox;
    private JRadioButton defaultColorAndTextureRadioButton;
    private JRadioButton colorRadioButton;
    private ColorButton colorButton;
    private JRadioButton textureRadioButton;
    private JComponent textureComponent;
    private JRadioButton modelMaterialsRadioButton;
    private JComponent modelMaterialsComponent;
    private JRadioButton defaultShininessRadioButton;
    private JRadioButton mattRadioButton;
    private JRadioButton shinyRadioButton;
    private NullableCheckBox visibleCheckBox;
    private JLabel lightPowerLabel;
    private JSpinner lightPowerSpinner;
    private String dialogTitle;

    public HomeFurniturePanel(UserPreferences userPreferences, HomeFurnitureController homeFurnitureController) {
        super(new GridBagLayout());
        this.controller = homeFurnitureController;
        this.createComponents(userPreferences, homeFurnitureController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences, homeFurnitureController);
    }

    private void createComponents(UserPreferences userPreferences, final HomeFurnitureController homeFurnitureController) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        String string = userPreferences.getLengthUnit().getName();
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.NAME)) {
            this.nameLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "nameLabel.text", new Object[0]));
            this.nameTextField = new AutoCompleteTextField(homeFurnitureController.getName(), 15, userPreferences.getAutoCompletionStrings("HomePieceOfFurnitureName"));
            if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
                SwingTools.addAutoSelectionOnFocusGain(this.nameTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.nameTextField.setText(homeFurnitureController.getName());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME, (PropertyChangeListener)object4);
            this.nameTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$nameChangeListener;
                {
                    this.val$nameChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.NAME, this.val$nameChangeListener);
                    String string = HomeFurniturePanel.this.nameTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        homeFurnitureController.setName(null);
                    } else {
                        homeFurnitureController.setName(string);
                    }
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME, this.val$nameChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.NAME_VISIBLE)) {
            this.nameVisibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "nameVisibleCheckBox.text", new Object[0]));
            this.nameVisibleCheckBox.setNullable(homeFurnitureController.getNameVisible() == null);
            this.nameVisibleCheckBox.setValue(homeFurnitureController.getNameVisible());
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.nameVisibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.nameVisibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, (PropertyChangeListener)object4);
            this.nameVisibleCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$nameVisibleChangeListener;
                {
                    this.val$nameVisibleChangeListener = propertyChangeListener;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, this.val$nameVisibleChangeListener);
                    homeFurnitureController.setNameVisible(HomeFurniturePanel.this.nameVisibleCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.NAME_VISIBLE, this.val$nameVisibleChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.DESCRIPTION)) {
            this.descriptionLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "descriptionLabel.text", new Object[0]));
            this.descriptionTextField = new AutoCompleteTextField(homeFurnitureController.getDescription(), 15, userPreferences.getAutoCompletionStrings("HomePieceOfFurnitureDescription"));
            if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
                SwingTools.addAutoSelectionOnFocusGain(this.descriptionTextField);
            }
            object4 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.descriptionTextField.setText(homeFurnitureController.getDescription());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DESCRIPTION, (PropertyChangeListener)object4);
            this.descriptionTextField.getDocument().addDocumentListener(new DocumentListener((PropertyChangeListener)object4){
                final /* synthetic */ PropertyChangeListener val$descriptionChangeListener;
                {
                    this.val$descriptionChangeListener = propertyChangeListener;
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.DESCRIPTION, this.val$descriptionChangeListener);
                    String string = HomeFurniturePanel.this.descriptionTextField.getText();
                    if (string == null || string.trim().length() == 0) {
                        homeFurnitureController.setDescription(null);
                    } else {
                        homeFurnitureController.setDescription(string);
                    }
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DESCRIPTION, this.val$descriptionChangeListener);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.changedUpdate(documentEvent);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PRICE)) {
            this.priceLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "priceLabel.text", new Object[0]));
            object4 = new NullableSpinner.NullableSpinnerNumberModel(0.0f, 0.0f, 1.0E8f, 1.0f);
            this.priceSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object4);
            object3 = homeFurnitureController.getPrice();
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setNullable(object3 == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object4).setValue(object3 == null ? null : Float.valueOf(((BigDecimal)object3).floatValue()));
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$priceSpinnerModel;
                {
                    this.val$priceSpinnerModel = nullableSpinnerNumberModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$priceSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$priceSpinnerModel.setValue(Float.valueOf(((Number)propertyChangeEvent.getNewValue()).floatValue()));
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PRICE, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object4).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerNumberModel)object4){
                final /* synthetic */ PropertyChangeListener val$priceChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$priceSpinnerModel;
                {
                    this.val$priceChangeListener = propertyChangeListener;
                    this.val$priceSpinnerModel = nullableSpinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.PRICE, this.val$priceChangeListener);
                    homeFurnitureController.setPrice(new BigDecimal(this.val$priceSpinnerModel.getNumber().doubleValue()));
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PRICE, this.val$priceChangeListener);
                }
            });
        }
        float f = userPreferences.getLengthUnit().getMaximumLength();
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.X)) {
            this.xLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "xLabel.text", string));
            object3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
            this.xSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            ((NullableSpinner.NullableSpinnerNumberModel)object3).setNullable(homeFurnitureController.getX() == null);
            ((NullableSpinner.NullableSpinnerLengthModel)object3).setLength(homeFurnitureController.getX());
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$xSpinnerModel;
                {
                    this.val$xSpinnerModel = nullableSpinnerLengthModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$xSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$xSpinnerModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.X, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ PropertyChangeListener val$xChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$xSpinnerModel;
                {
                    this.val$xChangeListener = propertyChangeListener;
                    this.val$xSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.X, this.val$xChangeListener);
                    homeFurnitureController.setX(this.val$xSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.X, this.val$xChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.Y)) {
            this.yLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "yLabel.text", string));
            object3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -f, f);
            this.ySpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            ((NullableSpinner.NullableSpinnerNumberModel)object3).setNullable(homeFurnitureController.getY() == null);
            ((NullableSpinner.NullableSpinnerLengthModel)object3).setLength(homeFurnitureController.getY());
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$ySpinnerModel;
                {
                    this.val$ySpinnerModel = nullableSpinnerLengthModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$ySpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$ySpinnerModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.Y, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ PropertyChangeListener val$yChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$ySpinnerModel;
                {
                    this.val$yChangeListener = propertyChangeListener;
                    this.val$ySpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.Y, this.val$yChangeListener);
                    homeFurnitureController.setY(this.val$ySpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.Y, this.val$yChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.ELEVATION)) {
            this.elevationLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "elevationLabel.text", string));
            object3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, 0.0f, userPreferences.getLengthUnit().getMaximumElevation());
            this.elevationSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            ((NullableSpinner.NullableSpinnerNumberModel)object3).setNullable(homeFurnitureController.getElevation() == null);
            ((NullableSpinner.NullableSpinnerLengthModel)object3).setLength(homeFurnitureController.getElevation());
            object2 = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$elevationSpinnerModel;
                {
                    this.val$elevationSpinnerModel = nullableSpinnerLengthModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    this.val$elevationSpinnerModel.setNullable(propertyChangeEvent.getNewValue() == null);
                    this.val$elevationSpinnerModel.setLength((Float)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ELEVATION, (PropertyChangeListener)object2);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object2, (NullableSpinner.NullableSpinnerLengthModel)object3){
                final /* synthetic */ PropertyChangeListener val$elevationChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$elevationSpinnerModel;
                {
                    this.val$elevationChangeListener = propertyChangeListener;
                    this.val$elevationSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.ELEVATION, this.val$elevationChangeListener);
                    homeFurnitureController.setElevation(this.val$elevationSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ELEVATION, this.val$elevationChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.ANGLE_IN_DEGREES)) {
            this.angleLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "angleLabel.text", new Object[0]));
            object3 = new NullableSpinner.NullableSpinnerModuloNumberModel(0, 0, 360, 1);
            this.angleSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object3);
            object2 = homeFurnitureController.getAngleInDegrees();
            ((NullableSpinner.NullableSpinnerNumberModel)object3).setNullable(object2 == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object3).setValue(object2);
            object = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object3){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$angleSpinnerModel;
                {
                    this.val$angleSpinnerModel = nullableSpinnerNumberModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Integer n = (Integer)propertyChangeEvent.getNewValue();
                    this.val$angleSpinnerModel.setNullable(n == null);
                    this.val$angleSpinnerModel.setValue(n);
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ANGLE_IN_DEGREES, (PropertyChangeListener)object);
            ((AbstractSpinnerModel)object3).addChangeListener(new ChangeListener((PropertyChangeListener)object, (NullableSpinner.NullableSpinnerNumberModel)object3){
                final /* synthetic */ PropertyChangeListener val$angleChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$angleSpinnerModel;
                {
                    this.val$angleChangeListener = propertyChangeListener;
                    this.val$angleSpinnerModel = nullableSpinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.ANGLE_IN_DEGREES, this.val$angleChangeListener);
                    Number number = (Number)this.val$angleSpinnerModel.getValue();
                    if (number == null) {
                        homeFurnitureController.setAngleInDegrees(null);
                    } else {
                        homeFurnitureController.setAngleInDegrees(number.intValue());
                    }
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.ANGLE_IN_DEGREES, this.val$angleChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.BASE_PLAN_ITEM)) {
            this.basePlanItemCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "basePlanItemCheckBox.text", new Object[0]));
            object3 = userPreferences.getLocalizedString(HomeFurniturePanel.class, "basePlanItemCheckBox.tooltip", new Object[0]);
            if (((String)object3).length() > 0) {
                this.basePlanItemCheckBox.setToolTipText((String)object3);
            }
            this.basePlanItemCheckBox.setNullable(homeFurnitureController.getBasePlanItem() == null);
            this.basePlanItemCheckBox.setValue(homeFurnitureController.getBasePlanItem());
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.basePlanItemCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.basePlanItemCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, (PropertyChangeListener)object2);
            this.basePlanItemCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$basePlanItemModelChangeListener;
                {
                    this.val$basePlanItemModelChangeListener = propertyChangeListener;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, this.val$basePlanItemModelChangeListener);
                    homeFurnitureController.setBasePlanItem(HomeFurniturePanel.this.basePlanItemCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.BASE_PLAN_ITEM, this.val$basePlanItemModelChangeListener);
                }
            });
            this.basePlanItemCheckBox.setEnabled(homeFurnitureController.isBasePlanItemEnabled());
        }
        float f2 = userPreferences.getLengthUnit().getMinimumLength();
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.WIDTH)) {
            this.widthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "widthLabel.text", string));
            object2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
            this.widthSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object2);
            object = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object2, f2){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$widthSpinnerModel;
                final /* synthetic */ float val$minimumLength;
                {
                    this.val$widthSpinnerModel = nullableSpinnerLengthModel;
                    this.val$minimumLength = f;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = homeFurnitureController.getWidth();
                    this.val$widthSpinnerModel.setNullable(f == null);
                    this.val$widthSpinnerModel.setLength(f);
                    if (f != null) {
                        this.val$widthSpinnerModel.setMinimumLength(Math.min(f.floatValue(), this.val$minimumLength));
                    }
                }
            };
            object.propertyChange(null);
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.WIDTH, (PropertyChangeListener)object);
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((PropertyChangeListener)object, (NullableSpinner.NullableSpinnerLengthModel)object2){
                final /* synthetic */ PropertyChangeListener val$widthChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$widthSpinnerModel;
                {
                    this.val$widthChangeListener = propertyChangeListener;
                    this.val$widthSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.WIDTH, this.val$widthChangeListener);
                    homeFurnitureController.setWidth(this.val$widthSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.WIDTH, this.val$widthChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.DEPTH)) {
            this.depthLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "depthLabel.text", string));
            object2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
            this.depthSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object2);
            object = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object2, f2){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$depthSpinnerModel;
                final /* synthetic */ float val$minimumLength;
                {
                    this.val$depthSpinnerModel = nullableSpinnerLengthModel;
                    this.val$minimumLength = f;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = homeFurnitureController.getDepth();
                    this.val$depthSpinnerModel.setNullable(f == null);
                    this.val$depthSpinnerModel.setLength(f);
                    if (f != null) {
                        this.val$depthSpinnerModel.setMinimumLength(Math.min(f.floatValue(), this.val$minimumLength));
                    }
                }
            };
            object.propertyChange(null);
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEPTH, (PropertyChangeListener)object);
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((PropertyChangeListener)object, (NullableSpinner.NullableSpinnerLengthModel)object2){
                final /* synthetic */ PropertyChangeListener val$depthChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$depthSpinnerModel;
                {
                    this.val$depthChangeListener = propertyChangeListener;
                    this.val$depthSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.DEPTH, this.val$depthChangeListener);
                    homeFurnitureController.setDepth(this.val$depthSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEPTH, this.val$depthChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.HEIGHT)) {
            this.heightLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "heightLabel.text", string));
            object2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, f2, f);
            this.heightSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object2);
            object = new PropertyChangeListener((NullableSpinner.NullableSpinnerLengthModel)object2, f2){
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$heightSpinnerModel;
                final /* synthetic */ float val$minimumLength;
                {
                    this.val$heightSpinnerModel = nullableSpinnerLengthModel;
                    this.val$minimumLength = f;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = homeFurnitureController.getHeight();
                    this.val$heightSpinnerModel.setNullable(f == null);
                    this.val$heightSpinnerModel.setLength(f);
                    if (f != null) {
                        this.val$heightSpinnerModel.setMinimumLength(Math.min(f.floatValue(), this.val$minimumLength));
                    }
                }
            };
            object.propertyChange(null);
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.HEIGHT, (PropertyChangeListener)object);
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((PropertyChangeListener)object, (NullableSpinner.NullableSpinnerLengthModel)object2){
                final /* synthetic */ PropertyChangeListener val$heightChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerLengthModel val$heightSpinnerModel;
                {
                    this.val$heightChangeListener = propertyChangeListener;
                    this.val$heightSpinnerModel = nullableSpinnerLengthModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.HEIGHT, this.val$heightChangeListener);
                    homeFurnitureController.setHeight(this.val$heightSpinnerModel.getLength());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.HEIGHT, this.val$heightChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PROPORTIONAL)) {
            this.keepProportionsCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ImportedFurnitureWizardStepsPanel.class, "keepProportionsCheckBox.text", new Object[0]));
            this.keepProportionsCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    homeFurnitureController.setProportional(HomeFurniturePanel.this.keepProportionsCheckBox.isSelected());
                }
            });
            this.keepProportionsCheckBox.setSelected(homeFurnitureController.isProportional());
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PROPORTIONAL, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.keepProportionsCheckBox.setSelected(homeFurnitureController.isProportional());
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.MODEL_MIRRORED)) {
            this.mirroredModelCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "mirroredModelCheckBox.text", new Object[0]));
            object2 = userPreferences.getLocalizedString(HomeFurniturePanel.class, "mirroredModelCheckBox.tooltip", new Object[0]);
            if (((String)object2).length() > 0) {
                this.mirroredModelCheckBox.setToolTipText((String)object2);
            }
            this.mirroredModelCheckBox.setNullable(homeFurnitureController.getModelMirrored() == null);
            this.mirroredModelCheckBox.setValue(homeFurnitureController.getModelMirrored());
            object = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.mirroredModelCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.mirroredModelCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, (PropertyChangeListener)object);
            this.mirroredModelCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object){
                final /* synthetic */ PropertyChangeListener val$mirroredModelChangeListener;
                {
                    this.val$mirroredModelChangeListener = propertyChangeListener;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, this.val$mirroredModelChangeListener);
                    homeFurnitureController.setModelMirrored(HomeFurniturePanel.this.mirroredModelCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.MODEL_MIRRORED, this.val$mirroredModelChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PAINT)) {
            object2 = new ButtonGroup();
            this.defaultColorAndTextureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "defaultColorAndTextureRadioButton.text", new Object[0]));
            ((ButtonGroup)object2).add(this.defaultColorAndTextureRadioButton);
            this.defaultColorAndTextureRadioButton.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.defaultColorAndTextureRadioButton.isSelected()) {
                        homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.DEFAULT);
                    }
                }
            });
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.PAINT, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.updatePaintRadioButtons(homeFurnitureController);
                }
            });
            this.colorRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "colorRadioButton.text", new Object[0]));
            ((ButtonGroup)object2).add(this.colorRadioButton);
            this.colorRadioButton.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.colorRadioButton.isSelected()) {
                        homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.COLORED);
                    }
                }
            });
            this.colorButton = new ColorButton(userPreferences);
            if (OperatingSystem.isMacOSX()) {
                this.colorButton.putClientProperty("JButton.buttonType", "segmented");
                this.colorButton.putClientProperty("JButton.segmentPosition", "only");
            }
            this.colorButton.setColorDialogTitle(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorDialog.title", new Object[0]));
            this.colorButton.setColor(homeFurnitureController.getColor());
            this.colorButton.addPropertyChangeListener("color", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    homeFurnitureController.setColor(HomeFurniturePanel.this.colorButton.getColor());
                    homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.COLORED);
                }
            });
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.COLOR, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.colorButton.setColor(homeFurnitureController.getColor());
                }
            });
            object = homeFurnitureController.getTextureController();
            if (object != null) {
                this.textureRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "textureRadioButton.text", new Object[0]));
                this.textureRadioButton.addChangeListener(new ChangeListener(){

                    public void stateChanged(ChangeEvent changeEvent) {
                        if (HomeFurniturePanel.this.textureRadioButton.isSelected()) {
                            homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.TEXTURED);
                        }
                    }
                });
                this.textureComponent = (JComponent)((Object)((TextureChoiceController)object).getView());
                if (OperatingSystem.isMacOSX()) {
                    this.textureComponent.putClientProperty("JButton.buttonType", "segmented");
                    this.textureComponent.putClientProperty("JButton.segmentPosition", "only");
                }
                ((ButtonGroup)object2).add(this.textureRadioButton);
            }
            try {
                ModelMaterialsController modelMaterialsController = homeFurnitureController.getModelMaterialsController();
                if (modelMaterialsController != null && !Boolean.getBoolean("com.eteks.sweethome3d.no3D")) {
                    this.modelMaterialsRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "modelMaterialsRadioButton.text", new Object[0]));
                    this.modelMaterialsRadioButton.addChangeListener(new ChangeListener(){

                        public void stateChanged(ChangeEvent changeEvent) {
                            if (HomeFurniturePanel.this.modelMaterialsRadioButton.isSelected()) {
                                homeFurnitureController.setPaint(HomeFurnitureController.FurniturePaint.MODEL_MATERIALS);
                            }
                        }
                    });
                    this.modelMaterialsComponent = (JComponent)((Object)modelMaterialsController.getView());
                    if (OperatingSystem.isMacOSX()) {
                        this.modelMaterialsComponent.putClientProperty("JButton.buttonType", "segmented");
                        this.modelMaterialsComponent.putClientProperty("JButton.segmentPosition", "only");
                    }
                    ((ButtonGroup)object2).add(this.modelMaterialsRadioButton);
                    boolean bl = modelMaterialsController.getModel() != null;
                    this.modelMaterialsRadioButton.setEnabled(bl);
                    this.modelMaterialsComponent.setEnabled(bl);
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.SHININESS)) {
            this.defaultShininessRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "defaultShininessRadioButton.text", new Object[0]));
            this.defaultShininessRadioButton.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.defaultShininessRadioButton.isSelected()) {
                        homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.DEFAULT);
                    }
                }
            });
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.SHININESS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.updateShininessRadioButtons(homeFurnitureController);
                }
            });
            this.mattRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "mattRadioButton.text", new Object[0]));
            this.mattRadioButton.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.mattRadioButton.isSelected()) {
                        homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.MATT);
                    }
                }
            });
            this.shinyRadioButton = new JRadioButton(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "shinyRadioButton.text", new Object[0]));
            this.shinyRadioButton.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (HomeFurniturePanel.this.shinyRadioButton.isSelected()) {
                        homeFurnitureController.setShininess(HomeFurnitureController.FurnitureShininess.SHINY);
                    }
                }
            });
            object2 = new ButtonGroup();
            ((ButtonGroup)object2).add(this.defaultShininessRadioButton);
            ((ButtonGroup)object2).add(this.mattRadioButton);
            ((ButtonGroup)object2).add(this.shinyRadioButton);
            this.updateShininessRadioButtons(homeFurnitureController);
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.PAINT)) {
            this.updatePaintRadioButtons(homeFurnitureController);
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.VISIBLE)) {
            this.visibleCheckBox = new NullableCheckBox(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "visibleCheckBox.text", new Object[0]));
            this.visibleCheckBox.setNullable(homeFurnitureController.getVisible() == null);
            this.visibleCheckBox.setValue(homeFurnitureController.getVisible());
            object2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurniturePanel.this.visibleCheckBox.setNullable(propertyChangeEvent.getNewValue() == null);
                    HomeFurniturePanel.this.visibleCheckBox.setValue((Boolean)propertyChangeEvent.getNewValue());
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VISIBLE, (PropertyChangeListener)object2);
            this.visibleCheckBox.addChangeListener(new ChangeListener((PropertyChangeListener)object2){
                final /* synthetic */ PropertyChangeListener val$visibleChangeListener;
                {
                    this.val$visibleChangeListener = propertyChangeListener;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.VISIBLE, this.val$visibleChangeListener);
                    homeFurnitureController.setVisible(HomeFurniturePanel.this.visibleCheckBox.getValue());
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.VISIBLE, this.val$visibleChangeListener);
                }
            });
        }
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.LIGHT_POWER)) {
            this.lightPowerLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "lightPowerLabel.text", string));
            object2 = new NullableSpinner.NullableSpinnerNumberModel(0, 0, 100, 5);
            this.lightPowerSpinner = new NullableSpinner((NullableSpinner.NullableSpinnerNumberModel)object2);
            ((NullableSpinner.NullableSpinnerNumberModel)object2).setNullable(homeFurnitureController.getLightPower() == null);
            ((NullableSpinner.NullableSpinnerNumberModel)object2).setValue(homeFurnitureController.getLightPower() != null ? Integer.valueOf(Math.round(homeFurnitureController.getLightPower().floatValue() * 100.0f)) : null);
            object = new PropertyChangeListener((NullableSpinner.NullableSpinnerNumberModel)object2){
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$lightPowerSpinnerModel;
                {
                    this.val$lightPowerSpinnerModel = nullableSpinnerNumberModel;
                }

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Float f = (Float)propertyChangeEvent.getNewValue();
                    this.val$lightPowerSpinnerModel.setNullable(f == null);
                    this.val$lightPowerSpinnerModel.setValue(f != null ? Integer.valueOf(Math.round(((Float)propertyChangeEvent.getNewValue()).floatValue() * 100.0f)) : null);
                }
            };
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, (PropertyChangeListener)object);
            ((AbstractSpinnerModel)object2).addChangeListener(new ChangeListener((PropertyChangeListener)object, (NullableSpinner.NullableSpinnerNumberModel)object2){
                final /* synthetic */ PropertyChangeListener val$lightPowerChangeListener;
                final /* synthetic */ NullableSpinner.NullableSpinnerNumberModel val$lightPowerSpinnerModel;
                {
                    this.val$lightPowerChangeListener = propertyChangeListener;
                    this.val$lightPowerSpinnerModel = nullableSpinnerNumberModel;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    homeFurnitureController.removePropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, this.val$lightPowerChangeListener);
                    homeFurnitureController.setLightPower(Float.valueOf(((Number)this.val$lightPowerSpinnerModel.getValue()).floatValue() / 100.0f));
                    homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.LIGHT_POWER, this.val$lightPowerChangeListener);
                }
            });
        }
        this.updateSizeComponents(homeFurnitureController);
        object2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HomeFurniturePanel.this.updateSizeComponents(homeFurnitureController);
            }
        };
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.RESIZABLE, (PropertyChangeListener)object2);
        homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.DEFORMABLE, (PropertyChangeListener)object2);
        this.dialogTitle = userPreferences.getLocalizedString(HomeFurniturePanel.class, "homeFurniture.title", new Object[0]);
    }

    private void updatePaintRadioButtons(HomeFurnitureController homeFurnitureController) {
        if (homeFurnitureController.getPaint() == null) {
            SwingTools.deselectAllRadioButtons(this.defaultColorAndTextureRadioButton, this.colorRadioButton, this.textureRadioButton, this.modelMaterialsRadioButton);
        } else {
            switch (homeFurnitureController.getPaint()) {
                case DEFAULT: {
                    this.defaultColorAndTextureRadioButton.setSelected(true);
                    break;
                }
                case COLORED: {
                    this.colorRadioButton.setSelected(true);
                    break;
                }
                case TEXTURED: {
                    this.textureRadioButton.setSelected(true);
                    break;
                }
                case MODEL_MATERIALS: {
                    this.modelMaterialsRadioButton.setSelected(true);
                }
            }
            this.updateShininessRadioButtons(homeFurnitureController);
        }
    }

    private void updateShininessRadioButtons(HomeFurnitureController homeFurnitureController) {
        if (homeFurnitureController.isPropertyEditable(HomeFurnitureController.Property.SHININESS)) {
            if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.DEFAULT) {
                this.defaultShininessRadioButton.setSelected(true);
            } else if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.MATT) {
                this.mattRadioButton.setSelected(true);
            } else if (homeFurnitureController.getShininess() == HomeFurnitureController.FurnitureShininess.SHINY) {
                this.shinyRadioButton.setSelected(true);
            } else {
                SwingTools.deselectAllRadioButtons(this.defaultShininessRadioButton, this.mattRadioButton, this.shinyRadioButton);
            }
            boolean bl = homeFurnitureController.getPaint() != HomeFurnitureController.FurniturePaint.MODEL_MATERIALS;
            this.defaultShininessRadioButton.setEnabled(bl);
            this.mattRadioButton.setEnabled(bl);
            this.shinyRadioButton.setEnabled(bl);
            if (!bl) {
                SwingTools.deselectAllRadioButtons(this.defaultShininessRadioButton, this.mattRadioButton, this.shinyRadioButton);
            }
        }
    }

    private void updateSizeComponents(HomeFurnitureController homeFurnitureController) {
        boolean bl = homeFurnitureController.isResizable();
        this.widthLabel.setEnabled(bl);
        this.widthSpinner.setEnabled(bl);
        this.depthLabel.setEnabled(bl);
        this.depthSpinner.setEnabled(bl);
        this.heightLabel.setEnabled(bl);
        this.heightSpinner.setEnabled(bl);
        this.keepProportionsCheckBox.setEnabled(bl && homeFurnitureController.isDeformable());
        this.mirroredModelCheckBox.setEnabled(bl);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            if (this.nameLabel != null) {
                this.nameLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "nameLabel.mnemonic", new Object[0])).getKeyCode());
                this.nameLabel.setLabelFor(this.nameTextField);
            }
            if (this.nameVisibleCheckBox != null) {
                this.nameVisibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "nameVisibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.descriptionLabel != null) {
                this.descriptionLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "descriptionLabel.mnemonic", new Object[0])).getKeyCode());
                this.descriptionLabel.setLabelFor(this.descriptionTextField);
            }
            if (this.priceLabel != null) {
                this.priceLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "priceLabel.mnemonic", new Object[0])).getKeyCode());
                this.priceLabel.setLabelFor(this.priceSpinner);
            }
            if (this.xLabel != null) {
                this.xLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
                this.xLabel.setLabelFor(this.xSpinner);
            }
            if (this.yLabel != null) {
                this.yLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
                this.yLabel.setLabelFor(this.ySpinner);
            }
            if (this.elevationLabel != null) {
                this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
                this.elevationLabel.setLabelFor(this.elevationSpinner);
            }
            if (this.angleLabel != null) {
                this.angleLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "angleLabel.mnemonic", new Object[0])).getKeyCode());
                this.angleLabel.setLabelFor(this.angleSpinner);
            }
            if (this.keepProportionsCheckBox != null) {
                this.keepProportionsCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "keepProportionsCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.widthLabel != null) {
                this.widthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "widthLabel.mnemonic", new Object[0])).getKeyCode());
                this.widthLabel.setLabelFor(this.widthSpinner);
            }
            if (this.depthLabel != null) {
                this.depthLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "depthLabel.mnemonic", new Object[0])).getKeyCode());
                this.depthLabel.setLabelFor(this.depthSpinner);
            }
            if (this.heightLabel != null) {
                this.heightLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "heightLabel.mnemonic", new Object[0])).getKeyCode());
                this.heightLabel.setLabelFor(this.heightSpinner);
            }
            if (this.basePlanItemCheckBox != null) {
                this.basePlanItemCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "basePlanItemCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.mirroredModelCheckBox != null) {
                this.mirroredModelCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "mirroredModelCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.defaultColorAndTextureRadioButton != null) {
                this.defaultColorAndTextureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "defaultColorAndTextureRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.colorRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.textureRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "textureRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.defaultShininessRadioButton != null) {
                this.defaultShininessRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "defaultShininessRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.mattRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "mattRadioButton.mnemonic", new Object[0])).getKeyCode());
                this.shinyRadioButton.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "shinyRadioButton.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.visibleCheckBox != null) {
                this.visibleCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "visibleCheckBox.mnemonic", new Object[0])).getKeyCode());
            }
            if (this.lightPowerLabel != null) {
                this.lightPowerLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HomeFurniturePanel.class, "lightPowerLabel.mnemonic", new Object[0])).getKeyCode());
                this.lightPowerLabel.setLabelFor(this.lightPowerSpinner);
            }
        }
    }

    private void layoutComponents(UserPreferences userPreferences, final HomeFurnitureController homeFurnitureController) {
        int n;
        int n2 = OperatingSystem.isMacOSX() ? 22 : 21;
        boolean bl = this.priceLabel != null;
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, bl ? "nameAndPricePanel.title" : "namePanel.title", new Object[0]));
        int n3 = n = OperatingSystem.isMacOSXLeopardOrSuperior() ? 0 : 5;
        if (this.nameLabel != null) {
            jPanel.add((Component)this.nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n2, 0, new Insets(0, 0, 0, 5), 0, 0));
            jPanel.add((Component)this.nameTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 10), 0, 0));
        }
        if (this.nameVisibleCheckBox != null) {
            jPanel.add((Component)this.nameVisibleCheckBox, new GridBagConstraints(2, 0, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (this.descriptionLabel != null) {
            jPanel.add((Component)this.descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n2, 0, new Insets(5, 0, 0, 5), 0, 0));
            jPanel.add((Component)this.descriptionTextField, new GridBagConstraints(1, 1, bl ? 1 : 3, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 0, bl ? 10 : 0), 0, 0));
        }
        if (bl) {
            jPanel.add((Component)this.priceLabel, new GridBagConstraints(this.descriptionLabel != null ? 2 : 0, 1, 1, 1, 0.0, 0.0, n2, 0, new Insets(5, 0, 0, 5), 0, 0));
            jPanel.add((Component)this.priceSpinner, new GridBagConstraints(this.descriptionLabel != null ? 3 : 1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, 0, 0), 0, 0));
        }
        if (jPanel.getComponentCount() > 0) {
            this.add((Component)jPanel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, n2, 2, new Insets(0, 0, n, 0), 0, 0));
        }
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "locationPanel.title", new Object[0]));
        Insets insets = new Insets(0, 0, 5, 5);
        Insets insets2 = new Insets(0, 0, 5, 0);
        if (this.xLabel != null) {
            jPanel2.add((Component)this.xLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel2.add((Component)this.xSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        }
        if (this.yLabel != null) {
            jPanel2.add((Component)this.yLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel2.add((Component)this.ySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        }
        if (this.elevationLabel != null) {
            jPanel2.add((Component)this.elevationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel2.add((Component)this.elevationSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        }
        if (this.angleLabel != null) {
            jPanel2.add((Component)this.angleLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel2.add((Component)this.angleSpinner, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 21, 2, insets2, -15, 0));
        }
        if (this.basePlanItemCheckBox != null) {
            jPanel2.add((Component)this.basePlanItemCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (jPanel2.getComponentCount() > 0) {
            this.add((Component)jPanel2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
        }
        JPanel jPanel3 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "sizePanel.title", new Object[0]));
        if (this.widthLabel != null) {
            jPanel3.add((Component)this.widthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel3.add((Component)this.widthSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        }
        if (this.depthLabel != null) {
            jPanel3.add((Component)this.depthLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel3.add((Component)this.depthSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        }
        if (this.heightLabel != null) {
            jPanel3.add((Component)this.heightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n2, 0, insets, 0, 0));
            jPanel3.add((Component)this.heightSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 0, insets2, -10, 0));
        }
        if (this.keepProportionsCheckBox != null) {
            jPanel3.add((Component)this.keepProportionsCheckBox, new GridBagConstraints(0, 3, 2, 1, 0.0, 1.0, 21, 0, insets2, 0, 0));
        }
        if (this.mirroredModelCheckBox != null) {
            jPanel3.add((Component)this.mirroredModelCheckBox, new GridBagConstraints(0, 4, 2, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (jPanel3.getComponentCount() > 0) {
            this.add((Component)jPanel3, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
        }
        final JPanel jPanel4 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "colorAndTexturePanel.title", new Object[0]));
        if (this.defaultColorAndTextureRadioButton != null) {
            int n4;
            int n5;
            if (OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                n5 = 4;
                n4 = -4;
            } else {
                n5 = 0;
                n4 = 0;
            }
            jPanel4.add((Component)this.defaultColorAndTextureRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 0, insets, 0, 0));
            jPanel4.add((Component)this.colorRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
            jPanel4.add((Component)this.colorButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, n4, 0), 0, n5));
            if (this.textureComponent != null) {
                jPanel4.add((Component)this.textureRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 5), 0, 0));
                jPanel4.add((Component)this.textureComponent, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, n4, 0), 0, n5));
            }
            if (this.modelMaterialsComponent != null) {
                jPanel4.add((Component)this.modelMaterialsRadioButton, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(5, 0, 0, 5), 0, 0));
                jPanel4.add((Component)this.modelMaterialsComponent, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 21, 2, new Insets(5, 0, n4, 0), 0, n5));
            }
            this.add((Component)jPanel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.TEXTURABLE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jPanel4.setVisible(homeFurnitureController.isTexturable());
                }
            });
            jPanel4.setVisible(homeFurnitureController.isTexturable());
        }
        if (this.defaultShininessRadioButton != null) {
            final JPanel jPanel5 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(HomeFurniturePanel.class, "shininessPanel.title", new Object[0]));
            jPanel5.add((Component)this.defaultShininessRadioButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 5, 0), 0, 0));
            jPanel5.add((Component)this.mattRadioButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 21, 0, new Insets(0, 0, 0, 0), 0, 0));
            jPanel5.add((Component)this.shinyRadioButton, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
            if (jPanel4.getComponentCount() == 7) {
                jPanel5.add((Component)new JLabel(), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 21, 0, new Insets(5, 0, 0, 0), 0, 0));
            }
            this.add((Component)jPanel5, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, n2, 1, new Insets(0, 0, n, 0), 0, 0));
            homeFurnitureController.addPropertyChangeListener(HomeFurnitureController.Property.TEXTURABLE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jPanel5.setVisible(homeFurnitureController.isTexturable());
                }
            });
            jPanel5.setVisible(homeFurnitureController.isTexturable());
        }
        if (this.visibleCheckBox != null) {
            this.add((Component)this.visibleCheckBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 10, 0, 0), 0, 0));
        }
        if (this.lightPowerLabel != null) {
            this.add((Component)this.lightPowerLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, n2, 0, new Insets(0, 10, 0, 5), 0, 0));
            this.add((Component)this.lightPowerSpinner, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 21, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
    }

    public void displayView(View view) {
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, this.nameTextField) == 0) {
            this.controller.modifyFurniture();
        }
    }
}

