/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.control;

import com.baselet.control.enums.FormatLabels;
import java.util.HashSet;
import java.util.Set;

public class StringStyle {
    public static final String ESCAPE_CHARACTER = "\\";
    private static final String TEMP_REPLACEMENT = "\u00c2\u00a7$\u00c2\u00a7\u00c3\u00a4%\u00c2\u00a7%\u00c3\u00bc/,";
    private final Set<FormatLabels> format;
    private final String stringWithoutMarkup;

    public StringStyle(Set<FormatLabels> set, String string) {
        this.format = set;
        this.stringWithoutMarkup = string;
    }

    public static String replaceNotEscaped(String string) {
        string = StringStyle.replaceNotEscaped(string, "<<", "\u00ab");
        string = StringStyle.replaceNotEscaped(string, ">>", "\u00bb");
        return string;
    }

    private static String replaceNotEscaped(String string, String string2, String string3) {
        string = string.replace(ESCAPE_CHARACTER + string2, TEMP_REPLACEMENT);
        string = string.replace(string2, string3);
        string = string.replace(TEMP_REPLACEMENT, string2);
        return string;
    }

    public static StringStyle analyzeFormatLabels(String string) {
        HashSet<FormatLabels> hashSet = new HashSet<FormatLabels>();
        if (string != null && !string.isEmpty()) {
            boolean bl = true;
            while (bl) {
                bl = false;
                for (FormatLabels formatLabels : FormatLabels.values()) {
                    String string2 = formatLabels.getValue();
                    if (!string.startsWith(string2) || !string.endsWith(string2) || string.length() <= string2.length() * 2) continue;
                    hashSet.add(formatLabels);
                    string = string.substring(string2.length(), string.length() - string2.length());
                    bl = true;
                }
            }
        }
        return new StringStyle(hashSet, string);
    }

    public Set<FormatLabels> getFormat() {
        return this.format;
    }

    public String getStringWithoutMarkup() {
        return this.stringWithoutMarkup;
    }
}

