/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element;

import com.baselet.control.SharedUtils;
import com.baselet.control.basics.geom.Rectangle;
import com.baselet.element.sticking.PointChange;
import com.baselet.element.sticking.Stickable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class UndoInformation {
    private final Rectangle diffRect;
    private final Map<Stickable, List<PointChange>> stickableMoves;
    private final String oldAdditionalAttributes;
    private final String newAdditionalAttributes;

    private UndoInformation(Rectangle rectangle, Map<Stickable, List<PointChange>> map, String string, String string2) {
        this.diffRect = rectangle;
        this.stickableMoves = map;
        this.oldAdditionalAttributes = string;
        this.newAdditionalAttributes = string2;
    }

    public UndoInformation(Rectangle rectangle, Rectangle rectangle2, Map<Stickable, List<PointChange>> map, int n, String string, String string2) {
        this(UndoInformation.toMinZoom(rectangle.subtract(rectangle2), n), map, string, string2);
    }

    private static Map<Stickable, List<PointChange>> invertStickableMoves(Map<Stickable, List<PointChange>> map) {
        HashMap<Stickable, List<PointChange>> hashMap = new HashMap<Stickable, List<PointChange>>();
        for (Map.Entry<Stickable, List<PointChange>> entry : map.entrySet()) {
            ArrayList<PointChange> arrayList = new ArrayList<PointChange>();
            for (PointChange pointChange : entry.getValue()) {
                arrayList.add(new PointChange(pointChange.getIndex(), -pointChange.getDiffX(), -pointChange.getDiffY()));
            }
            hashMap.put(entry.getKey(), arrayList);
        }
        return hashMap;
    }

    public Rectangle getDiffRectangle(int n, boolean bl) {
        Rectangle rectangle = bl ? this.diffRect.copyInverted() : this.diffRect;
        return UndoInformation.toCurrentZoom(rectangle, n);
    }

    public Map<Stickable, List<PointChange>> getStickableMoves(boolean bl) {
        return bl ? UndoInformation.invertStickableMoves(this.stickableMoves) : this.stickableMoves;
    }

    public String getAdditionalAttributes(boolean bl) {
        if (bl) {
            return this.oldAdditionalAttributes;
        }
        return this.newAdditionalAttributes;
    }

    private static Rectangle toMinZoom(Rectangle rectangle, int n) {
        int n2 = UndoInformation.toMinZoom(rectangle.getX(), n);
        int n3 = UndoInformation.toMinZoom(rectangle.getY(), n);
        int n4 = UndoInformation.toMinZoom(rectangle.getWidth(), n);
        int n5 = UndoInformation.toMinZoom(rectangle.getHeight(), n);
        return new Rectangle(n2, n3, n4, n5);
    }

    private static int toMinZoom(int n, int n2) {
        return n / n2;
    }

    private static Rectangle toCurrentZoom(Rectangle rectangle, int n) {
        int n2 = UndoInformation.toCurrentZoom(rectangle.getX(), n);
        int n3 = UndoInformation.toCurrentZoom(rectangle.getY(), n);
        int n4 = UndoInformation.toCurrentZoom(rectangle.getWidth(), n);
        int n5 = UndoInformation.toCurrentZoom(rectangle.getHeight(), n);
        return new Rectangle(n2, n3, n4, n5);
    }

    private static int toCurrentZoom(int n, int n2) {
        return n * n2;
    }

    public UndoInformation merge(UndoInformation undoInformation) {
        Rectangle rectangle = this.diffRect.add(undoInformation.diffRect);
        HashMap<Stickable, List<PointChange>> hashMap = new HashMap<Stickable, List<PointChange>>();
        this.mergeStickableMoves(hashMap, this.stickableMoves);
        this.mergeStickableMoves(hashMap, undoInformation.stickableMoves);
        return new UndoInformation(rectangle, hashMap, undoInformation.oldAdditionalAttributes, this.newAdditionalAttributes);
    }

    private void mergeStickableMoves(Map<Stickable, List<PointChange>> map, Map<Stickable, List<PointChange>> map2) {
        for (Map.Entry<Stickable, List<PointChange>> entry : map2.entrySet()) {
            Stickable stickable = entry.getKey();
            List<PointChange> list = entry.getValue();
            List<PointChange> list2 = map.get(stickable);
            if (list2 == null) {
                map.put(stickable, list);
                continue;
            }
            this.mergeSourceToTarget(list, list2);
        }
    }

    private void mergeSourceToTarget(List<PointChange> list, List<PointChange> list2) {
        for (PointChange pointChange : list) {
            this.mergePoint(list2, pointChange);
        }
    }

    private void mergePoint(List<PointChange> list, PointChange pointChange) {
        ListIterator<PointChange> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            PointChange pointChange2 = listIterator.next();
            if (!pointChange.getIndex().equals(pointChange2.getIndex())) continue;
            listIterator.set(new PointChange(pointChange2.getIndex(), pointChange.getDiffX() + pointChange2.getDiffX(), pointChange.getDiffY() + pointChange2.getDiffY()));
            return;
        }
        list.add(pointChange);
    }

    public String toString(boolean bl) {
        return "UndoInformation [diffRect=" + this.getDiffRectangle(10, bl) + ", stickableMoves=" + SharedUtils.mapToString(this.getStickableMoves(bl)) + ", additionalAttributes=" + this.getAdditionalAttributes(bl) + "]";
    }
}

