/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.sticking;

import com.baselet.control.SharedUtils;
import com.baselet.element.sticking.PointDoubleIndexed;
import com.baselet.element.sticking.Stickable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StickableMap {
    public static final StickableMap EMPTY_MAP = new StickableMap();
    Map<Stickable, List<Integer>> stickingIndexMap = new HashMap<Stickable, List<Integer>>();

    public boolean equalsMap(StickableMap stickableMap) {
        return StickableMap.checkMapsEqual(this.stickingIndexMap, stickableMap.stickingIndexMap);
    }

    private static boolean checkMapsEqual(Map<Stickable, List<Integer>> map, Map<Stickable, List<Integer>> map2) {
        if (!StickableMap.containSameElements(map.keySet(), map2.keySet())) {
            return false;
        }
        for (Map.Entry<Stickable, List<Integer>> entry : map.entrySet()) {
            List<Integer> list;
            List<Integer> list2 = entry.getValue();
            if (StickableMap.containSameElements(list2, list = map2.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    private static boolean containSameElements(Collection<?> collection, Collection<?> collection2) {
        return collection.containsAll(collection2) && collection2.containsAll(collection);
    }

    public boolean isEmpty() {
        for (List<Integer> list : this.stickingIndexMap.values()) {
            if (list.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void add(Stickable stickable, PointDoubleIndexed pointDoubleIndexed) {
        List<Integer> list = this.stickingIndexMap.get(stickable);
        if (list == null) {
            list = new ArrayList<Integer>();
            this.stickingIndexMap.put(stickable, list);
        }
        list.add(pointDoubleIndexed.getIndex());
    }

    public Set<Stickable> getStickables() {
        return this.stickingIndexMap.keySet();
    }

    public List<PointDoubleIndexed> getStickablePoints(Stickable stickable) {
        List<Integer> list = this.stickingIndexMap.get(stickable);
        ArrayList<PointDoubleIndexed> arrayList = new ArrayList<PointDoubleIndexed>();
        for (PointDoubleIndexed pointDoubleIndexed : stickable.getStickablePoints()) {
            if (!list.contains(pointDoubleIndexed.getIndex())) continue;
            arrayList.add(pointDoubleIndexed);
        }
        return arrayList;
    }

    public void setStickablePoints(Stickable stickable, List<PointDoubleIndexed> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (PointDoubleIndexed pointDoubleIndexed : list) {
            arrayList.add(pointDoubleIndexed.getIndex());
        }
        this.stickingIndexMap.put(stickable, arrayList);
    }

    public String toString() {
        return "StickableMap [map=" + SharedUtils.mapToString("\n", ",", this.stickingIndexMap) + "]";
    }
}

