/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.gui.pane;

import com.baselet.control.basics.Converter;
import com.baselet.control.config.DerivedConfig;
import com.baselet.diagram.CurrentDiagram;
import com.baselet.diagram.draw.helper.ColorOwn;
import com.baselet.element.interfaces.GridElement;
import com.baselet.gui.AutocompletionText;
import com.baselet.gui.pane.OwnTokenMaker;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.AutoCompletion;
import org.fife.ui.autocomplete.BasicCompletion;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.fife.ui.rsyntaxtextarea.AbstractTokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rsyntaxtextarea.TokenMap;
import org.fife.ui.rtextarea.RTextScrollPane;

public class OwnSyntaxPane {
    private static final String SEPARATOR = "    ";
    private final DefaultCompletionProvider provider = new DefaultCompletionProvider(){

        @Override
        protected boolean isValidChar(char ch) {
            return ch != ' ';
        }
    };
    List<AutocompletionText> words = new ArrayList<AutocompletionText>();
    JPanel panel = new JPanel(new FlowLayout());
    RSyntaxTextArea textArea;
    RTextScrollPane scrollPane;

    public OwnSyntaxPane() {
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.textArea = new RSyntaxTextArea(){
            private static final long serialVersionUID = 7431070002967577129L;

            public void undoLastAction() {
                CurrentDiagram.getInstance().getDiagramHandler().getController().undo();
            }

            public void redoLastAction() {
                CurrentDiagram.getInstance().getDiagramHandler().getController().redo();
            }
        };
        this.createHightLightMap();
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory)TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("OwnTokenMaker", OwnTokenMaker.class.getName());
        this.textArea.setSyntaxEditingStyle("OwnTokenMaker");
        this.textArea.getSyntaxScheme().getStyle((int)6).foreground = Converter.convert(ColorOwn.SYNTAX_HIGHLIGHTING);
        this.createAutocompletionCompletionProvider();
        AutoCompletion ac = new AutoCompletion(this.provider);
        ac.install((JTextComponent)this.textArea);
        JLabel propertyLabel = new JLabel(" Properties");
        propertyLabel.setAlignmentX(0.0f);
        propertyLabel.setFont(DerivedConfig.getPanelHeaderFont());
        this.panel.add(propertyLabel);
        this.textArea.setAntiAliasingEnabled(true);
        this.textArea.setFont(DerivedConfig.getPanelContentFont());
        this.scrollPane = new RTextScrollPane((Component)this.textArea, false);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.panel.add((Component)this.scrollPane);
        this.textArea.getDocument().putProperty("tabSize", 3);
    }

    private void createAutocompletionCompletionProvider() {
        this.provider.clear();
        for (AutocompletionText word : this.words) {
            this.provider.addCompletion(new BasicCompletion(this.provider, word.getText(), word.getInfo()){

                @Override
                public String toString() {
                    if (this.getShortDescription() == null) {
                        return this.getInputText();
                    }
                    return String.valueOf(this.getInputText()) + OwnSyntaxPane.SEPARATOR + this.getShortDescription();
                }
            });
        }
    }

    private void createHightLightMap() {
        TokenMap myWordsToHighlight = new TokenMap();
        for (AutocompletionText word : this.words) {
            myWordsToHighlight.put(word.getText(), 6);
        }
        OwnTokenMaker.setMyWordsToHighlight(myWordsToHighlight);
        this.textArea.setSyntaxEditingStyle(null);
        this.textArea.setSyntaxEditingStyle("OwnTokenMaker");
    }

    public String getText() {
        return this.textArea.getText();
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void invalidate() {
        this.panel.invalidate();
    }

    public JTextComponent getTextComponent() {
        return this.textArea;
    }

    public void switchToElement(GridElement e) {
        this.words = e.getAutocompletionList();
        this.setText(e.getPanelAttributes());
    }

    public void switchToNonElement(String text) {
        this.words = new ArrayList<AutocompletionText>();
        this.setText(text);
    }

    private void setText(String text) {
        if (!this.textArea.getText().equals(text)) {
            this.textArea.setText(text);
        }
        this.textArea.setCaretPosition(0);
        this.createHightLightMap();
        this.createAutocompletionCompletionProvider();
    }
}

