/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.OccurrenceMarker;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.SmartHighlightPainter;

class MarkOccurrencesSupport
implements CaretListener,
ActionListener {
    private RSyntaxTextArea textArea;
    private Timer timer;
    private SmartHighlightPainter p;
    public static final Color DEFAULT_COLOR = new Color(224, 224, 224);
    private static final int DEFAULT_DELAY_MS = 1000;

    public MarkOccurrencesSupport() {
        this(1000);
    }

    public MarkOccurrencesSupport(int delay) {
        this(delay, DEFAULT_COLOR);
    }

    public MarkOccurrencesSupport(int delay, Color color) {
        this.timer = new Timer(delay, this);
        this.timer.setRepeats(false);
        this.p = new SmartHighlightPainter();
        this.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Caret c = this.textArea.getCaret();
        if (c.getDot() != c.getMark()) {
            return;
        }
        RSyntaxDocument doc = (RSyntaxDocument)this.textArea.getDocument();
        OccurrenceMarker occurrenceMarker = doc.getOccurrenceMarker();
        boolean occurrencesChanged = false;
        if (occurrenceMarker != null) {
            doc.readLock();
            try {
                int line = this.textArea.getCaretLineNumber();
                Token tokenList = this.textArea.getTokenListForLine(line);
                int dot = c.getDot();
                Token t = RSyntaxUtilities.getTokenAtOffset(tokenList, dot);
                if (t == null || !this.isValidType(t) || MarkOccurrencesSupport.isNonWordChar(t)) {
                    --dot;
                    try {
                        if (dot >= this.textArea.getLineStartOffset(line)) {
                            t = RSyntaxUtilities.getTokenAtOffset(tokenList, dot);
                        }
                    }
                    catch (BadLocationException ble) {
                        ble.printStackTrace();
                    }
                }
                if (t != null && this.isValidType(t) && !MarkOccurrencesSupport.isNonWordChar(t)) {
                    this.removeHighlights();
                    RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
                    occurrenceMarker.markOccurrences(doc, t, h, this.p);
                    occurrencesChanged = true;
                }
            }
            finally {
                doc.readUnlock();
            }
        }
        if (occurrencesChanged) {
            this.textArea.fireMarkedOccurrencesChanged();
        }
    }

    public void caretUpdate(CaretEvent e) {
        this.timer.restart();
    }

    public Color getColor() {
        return (Color)this.p.getPaint();
    }

    public int getDelay() {
        return this.timer.getDelay();
    }

    public boolean getPaintBorder() {
        return this.p.getPaintBorder();
    }

    public void install(RSyntaxTextArea textArea) {
        if (this.textArea != null) {
            this.uninstall();
        }
        this.textArea = textArea;
        textArea.addCaretListener(this);
        if (textArea.getMarkOccurrencesColor() != null) {
            this.setColor(textArea.getMarkOccurrencesColor());
        }
    }

    private static final boolean isNonWordChar(Token t) {
        return t.length() == 1 && !RSyntaxUtilities.isLetter(t.charAt(0));
    }

    private boolean isValidType(Token t) {
        return this.textArea.getMarkOccurrencesOfTokenType(t.getType());
    }

    private void removeHighlights() {
        if (this.textArea != null) {
            RSyntaxTextAreaHighlighter h = (RSyntaxTextAreaHighlighter)this.textArea.getHighlighter();
            h.clearMarkOccurrencesHighlights();
        }
    }

    public void setColor(Color color) {
        this.p.setPaint(color);
        if (this.textArea != null) {
            this.removeHighlights();
            this.caretUpdate(null);
        }
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }

    public void setPaintBorder(boolean paint) {
        if (paint != this.p.getPaintBorder()) {
            this.p.setPaintBorder(paint);
            if (this.textArea != null) {
                this.textArea.repaint();
            }
        }
    }

    public void uninstall() {
        if (this.textArea != null) {
            this.removeHighlights();
            this.textArea.removeCaretListener(this);
        }
    }
}

