/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.ui.menu;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.owasp.jbrofuzz.db.OpenDatabaseDialog;
import org.owasp.jbrofuzz.db.SyncDatabaseDialog;
import org.owasp.jbrofuzz.fuzz.io.OpenSession;
import org.owasp.jbrofuzz.fuzz.io.SaveAsSession;
import org.owasp.jbrofuzz.fuzz.io.SaveSession;
import org.owasp.jbrofuzz.payloads.OpenLocationDialog;
import org.owasp.jbrofuzz.ui.AbstractPanel;
import org.owasp.jbrofuzz.ui.JBroFuzzWindow;
import org.owasp.jbrofuzz.ui.menu.JBroFuzzMenuBar;
import org.owasp.jbrofuzz.version.ImageCreator;

public class JMenuFile
extends JMenu {
    private static final long serialVersionUID = -202188806275057795L;

    protected JMenuFile(final JBroFuzzMenuBar mainMenuBar) {
        super("File");
        final JBroFuzzWindow mFrameWindow = mainMenuBar.getFrame();
        JMenuItem newFile = new JMenuItem("New", ImageCreator.IMG_NEW);
        JMenuItem open = new JMenuItem("Open File...", ImageCreator.IMG_OPEN);
        JMenuItem close = new JMenuItem("Close");
        JMenuItem openLocation = new JMenuItem("Open Location...");
        JMenuItem openDatabase = new JMenuItem("Open Database...");
        JMenuItem syncDatabase = new JMenuItem("Sync to remote DB...");
        JMenuItem clearOutput = new JMenuItem("Clear All Output", ImageCreator.IMG_CLEAR);
        JMenuItem clearFuzzers = new JMenuItem("Clear All Fuzzers", ImageCreator.IMG_CLEAR);
        JMenuItem clearOnTheWire = new JMenuItem("Clear On The Wire", ImageCreator.IMG_CLEAR);
        JMenuItem save = new JMenuItem("Save", ImageCreator.IMG_SAVE);
        JMenuItem saveAs = new JMenuItem("Save as...", ImageCreator.IMG_SAVE_AS);
        JMenuItem exit = new JMenuItem("Exit", ImageCreator.IMG_EXIT);
        JMenuItem loadFuzzers = new JMenuItem("Load Fuzzers...");
        newFile.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        open.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        close.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        openLocation.setAccelerator(KeyStroke.getKeyStroke(76, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        openDatabase.setAccelerator(KeyStroke.getKeyStroke(68, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        loadFuzzers.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        clearOnTheWire.setAccelerator(KeyStroke.getKeyStroke(75, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        clearOutput.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        save.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        exit.setAccelerator(KeyStroke.getKeyStroke(49, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask(), false));
        this.add(newFile);
        this.add(open);
        this.add(close);
        this.addSeparator();
        this.add(openLocation);
        this.add(openDatabase);
        this.addSeparator();
        this.add(save);
        this.add(saveAs);
        this.addSeparator();
        this.add(loadFuzzers);
        this.addSeparator();
        this.add(clearOutput);
        this.add(clearFuzzers);
        this.add(clearOnTheWire);
        this.addSeparator();
        this.add(exit);
        newFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent even) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (mFrameWindow.getPanelFuzzing().isStopped()) {
                    mFrameWindow.getPanelFuzzing().clearAllFields();
                    mFrameWindow.setTitle("Untitled");
                    mFrameWindow.getJBroFuzz().getStorageHandler().createNewLocation();
                } else {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        mFrameWindow.getPanelFuzzing().clearAllFields();
                        mFrameWindow.setTitle("Untitled");
                        mFrameWindow.getJBroFuzz().getStorageHandler().createNewLocation();
                    }
                }
            }
        });
        open.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (mFrameWindow.getPanelFuzzing().isStopped()) {
                    new OpenSession(mFrameWindow);
                } else {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        new OpenSession(mFrameWindow);
                    }
                }
            }
        });
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (mFrameWindow.getPanelFuzzing().isStopped()) {
                    mFrameWindow.setCloseFile();
                    mFrameWindow.setTitle("Untitled");
                } else {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        mFrameWindow.setCloseFile();
                        mFrameWindow.setTitle("Untitled");
                    }
                }
            }
        });
        openLocation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (!mFrameWindow.getPanelFuzzing().isStopped()) {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        new OpenLocationDialog(mFrameWindow);
                    }
                } else {
                    new OpenLocationDialog(mFrameWindow);
                }
            }
        });
        openDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (!mFrameWindow.getPanelFuzzing().isStopped()) {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        new OpenDatabaseDialog(mFrameWindow);
                    }
                } else {
                    new OpenDatabaseDialog(mFrameWindow);
                }
            }
        });
        syncDatabase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (!mFrameWindow.getPanelFuzzing().isStopped()) {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        new SyncDatabaseDialog(mFrameWindow);
                    }
                } else {
                    new SyncDatabaseDialog(mFrameWindow);
                }
            }
        });
        loadFuzzers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mFrameWindow.getPanelPayloads().start();
            }
        });
        clearOutput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (!mFrameWindow.getPanelFuzzing().isStopped()) {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        mFrameWindow.getPanelFuzzing().clearOutputTable();
                        mFrameWindow.getJBroFuzz().getStorageHandler().createNewLocation();
                    }
                } else {
                    mFrameWindow.getPanelFuzzing().clearOutputTable();
                    mFrameWindow.getJBroFuzz().getStorageHandler().createNewLocation();
                }
            }
        });
        clearFuzzers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (!mFrameWindow.getPanelFuzzing().isStopped()) {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        mFrameWindow.getPanelFuzzing().getFuzzersPanel().clearFuzzersTable();
                    }
                } else {
                    mFrameWindow.getPanelFuzzing().getFuzzersPanel().clearFuzzersTable();
                }
            }
        });
        clearOnTheWire.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                mFrameWindow.getPanelFuzzing().clearOnTheWire();
            }
        });
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (mFrameWindow.getPanelFuzzing().isStopped()) {
                    try {
                        new SaveSession(mFrameWindow);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        try {
                            new SaveSession(mFrameWindow);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        saveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent aEvent) {
                mainMenuBar.setSelectedPanelCheckBox(124);
                mFrameWindow.setTabShow(124);
                if (!mFrameWindow.getPanelFuzzing().isStopped()) {
                    int choice = JOptionPane.showConfirmDialog(mFrameWindow, "Fuzzing Session Running. Stop Fuzzing?", " JBroFuzz - Stop ", 0);
                    if (choice == 0) {
                        int c = mFrameWindow.getTp().getSelectedIndex();
                        AbstractPanel p = (AbstractPanel)mFrameWindow.getTp().getComponent(c);
                        p.stop();
                        new SaveAsSession(mFrameWindow);
                    }
                } else {
                    new SaveAsSession(mFrameWindow);
                }
            }
        });
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        mFrameWindow.closeFrame();
                    }
                });
            }
        });
    }
}

