/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SQLiteBasisTest {
    private String[] result = new String[]{"Gandhi", "politics", "Turing", "computers", "Wittgenstein", "smartypants"};

    @Before
    public void setup() {
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:test.db");
            Statement stat = conn.createStatement();
            stat.executeUpdate("drop table if exists people;");
            stat.executeUpdate("create table people (name, occupation);");
            PreparedStatement prep = conn.prepareStatement("insert into people values (?, ?);");
            prep.setString(1, "Gandhi");
            prep.setString(2, "politics");
            prep.addBatch();
            prep.setString(1, "Turing");
            prep.setString(2, "computers");
            prep.addBatch();
            prep.setString(1, "Wittgenstein");
            prep.setString(2, "smartypants");
            prep.addBatch();
            conn.setAutoCommit(false);
            prep.executeBatch();
            conn.setAutoCommit(true);
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void simpleSQLiteCheck() throws Exception {
        try {
            Class.forName("org.sqlite.JDBC");
            Connection conn = DriverManager.getConnection("jdbc:sqlite:test.db");
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery("select * from people;");
            int i = 0;
            while (rs.next()) {
                Assert.assertEquals((Object)this.result[i], (Object)rs.getString("name"));
                Assert.assertEquals((Object)this.result[++i], (Object)rs.getString("occupation"));
                System.out.println("name = " + rs.getString("name"));
                System.out.println("job = " + rs.getString("occupation"));
                ++i;
            }
            rs.close();
            conn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

