/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;

public class VariantCookie
implements Variant {
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();

    @Override
    public void setMessage(HttpMessage httpMessage) {
        TreeSet<HtmlParameter> treeSet = httpMessage.getRequestHeader().getCookieParams();
        int n = 0;
        for (HtmlParameter htmlParameter : treeSet) {
            this.params.add(new NameValuePair(4, htmlParameter.getName(), this.getUnescapedValue(htmlParameter.getValue()), n++));
        }
    }

    private String getEscapedValue(String string) {
        return string != null ? AbstractPlugin.getURLEncode(string) : "";
    }

    private String getUnescapedValue(String string) {
        return string != null ? AbstractPlugin.getURLDecode(string) : "";
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, true);
    }

    private String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2, boolean bl) {
        ArrayList<HttpCookie> arrayList = new ArrayList<HttpCookie>();
        String string3 = bl ? string2 : this.getEscapedValue(string2);
        for (int i = 0; i < this.params.size(); ++i) {
            NameValuePair nameValuePair2 = this.params.get(i);
            if (i == nameValuePair.getPosition()) {
                arrayList.add(new HttpCookie(string, string3));
                continue;
            }
            arrayList.add(new HttpCookie(nameValuePair2.getName(), this.getEscapedValue(nameValuePair2.getValue())));
        }
        httpMessage.getRequestHeader().setCookies(arrayList);
        return string + "=" + string3;
    }
}

