/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.core.scanner.Variant;
import org.parosproxy.paros.network.HttpMessage;

public class VariantHeader
implements Variant {
    public static final String[] injectableHeaders = new String[]{"User-Agent", "Referer", "Host"};
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();
    private static final Logger log = Logger.getLogger(VariantHeader.class);

    @Override
    public void setMessage(HttpMessage httpMessage) {
        String string = null;
        try {
            string = httpMessage.getRequestHeader().getURI().getQuery();
        }
        catch (URIException uRIException) {
            log.error((Object)uRIException.getMessage(), (Throwable)uRIException);
        }
        if ((string == null || string.isEmpty()) && httpMessage.getRequestBody().length() == 0) {
            return;
        }
        for (int i = 0; i < injectableHeaders.length; ++i) {
            String string2 = httpMessage.getRequestHeader().getHeader(injectableHeaders[i]);
            if (string2 == null) continue;
            this.params.add(new NameValuePair(8, injectableHeaders[i], string2, i));
        }
    }

    @Override
    public List<NameValuePair> getParamList() {
        return this.params;
    }

    @Override
    public String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, false);
    }

    @Override
    public String setEscapedParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2) {
        return this.setParameter(httpMessage, nameValuePair, string, string2, true);
    }

    private String setParameter(HttpMessage httpMessage, NameValuePair nameValuePair, String string, String string2, boolean bl) {
        httpMessage.getRequestHeader().setHeader(nameValuePair.getName(), string2);
        return string + ":" + string2;
    }
}

