/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordParam;
import org.parosproxy.paros.db.TableParam;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableParam
extends ParosAbstractTable
implements TableParam {
    private static final String TABLE_NAME = "PARAM";
    private static final String PARAMID = "PARAMID";
    private static final String SITE = "SITE";
    private static final String TYPE = "TYPE";
    private static final String NAME = "NAME";
    private static final String USED = "USED";
    private static final String FLAGS = "FLAGS";
    private static final String VALUES = "VALS";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psUpdate = null;
    private PreparedStatement psGetAll = null;

    @Override
    protected void reconnect(Connection connection) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(connection, TABLE_NAME)) {
                DbUtils.executeAndClose(connection.prepareStatement("CREATE cached TABLE PARAM (paramid bigint generated by default as identity (start with 1), site varchar(32768) not null, type varchar(32768) not null, name varchar(32768) not null, used int not null, flags varchar(32768) not null, vals varchar(8388608) not null)"));
            }
            this.psRead = connection.prepareStatement("SELECT * FROM PARAM WHERE PARAMID = ?");
            this.psInsert = connection.prepareStatement("INSERT INTO PARAM (SITE,TYPE,NAME,USED,FLAGS,VALS) VALUES (?, ?, ?, ?, ?, ?)");
            this.psGetIdLastInsert = connection.prepareCall("CALL IDENTITY();");
            this.psUpdate = connection.prepareStatement("UPDATE PARAM SET USED = ?,FLAGS = ?,VALS = ? WHERE PARAMID = ?");
            this.psGetAll = connection.prepareStatement("SELECT * FROM PARAM");
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordParam read(long l) throws DatabaseException {
        try {
            this.psRead.setLong(1, l);
            try (ResultSet resultSet = this.psRead.executeQuery();){
                RecordParam recordParam = this.build(resultSet);
                resultSet.close();
                RecordParam recordParam2 = recordParam;
                return recordParam2;
            }
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public List<RecordParam> getAll() throws DatabaseException {
        try {
            ArrayList<RecordParam> arrayList = new ArrayList<RecordParam>();
            try (ResultSet resultSet = this.psGetAll.executeQuery();){
                while (resultSet.next()) {
                    arrayList.add(new RecordParam(resultSet.getLong(PARAMID), resultSet.getString(SITE), resultSet.getString(TYPE), resultSet.getString(NAME), resultSet.getInt(USED), resultSet.getString(FLAGS), resultSet.getString(VALUES)));
                }
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized RecordParam insert(String string, String string2, String string3, int n, String string4, String string5) throws DatabaseException {
        try {
            long l;
            this.psInsert.setString(1, string);
            this.psInsert.setString(2, string2);
            this.psInsert.setString(3, string3);
            this.psInsert.setInt(4, n);
            this.psInsert.setString(5, string4);
            this.psInsert.setString(6, string5);
            this.psInsert.executeUpdate();
            try (ResultSet resultSet = this.psGetIdLastInsert.executeQuery();){
                resultSet.next();
                l = resultSet.getLong(1);
            }
            return this.read(l);
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    @Override
    public synchronized void update(long l, int n, String string, String string2) throws DatabaseException {
        try {
            this.psUpdate.setInt(1, n);
            this.psUpdate.setString(2, string);
            this.psUpdate.setString(3, string2);
            this.psUpdate.setLong(4, l);
            this.psUpdate.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }

    private RecordParam build(ResultSet resultSet) throws DatabaseException {
        try {
            RecordParam recordParam = null;
            if (resultSet.next()) {
                recordParam = new RecordParam(resultSet.getLong(PARAMID), resultSet.getString(SITE), resultSet.getString(TYPE), resultSet.getString(NAME), resultSet.getInt(USED), resultSet.getString(FLAGS), resultSet.getString(VALUES));
            }
            return recordParam;
        }
        catch (SQLException sQLException) {
            throw new DatabaseException(sQLException);
        }
    }
}

