/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.network.HttpMessage;

public class FilterDetectMalciousContent
extends FilterAdaptor {
    private static final int DEFAULT = 10;
    private static final Pattern[] patternBadHeaderList = new Pattern[]{Pattern.compile("Content-type:\\s+application/hta", 10), Pattern.compile("Content-Disposition: attachment; filename=[^{}]+\\{[\\w\\d\\-]*\\}[^{}]+", 10), Pattern.compile("Location:\\s+URL:", 10)};
    private static final String[] patternBadHeaderDesc = new String[]{"Suspicious content-type header 'application/hta'", "MS IE Microsoft Internet Explorer CLSID File Extension Misrepresentation Vulnerability (http://www.securityfocus.com/bid/9510)", "Microsoft Internet Explorer URL Local Resource Access Weakness (http://www.securityfocus.com/bid/10472, http://secunia.com/advisories/11793"};
    private static final Pattern[] patternBadBodyList = new Pattern[]{Pattern.compile("^.*file:javascript:eval.*$", 10), Pattern.compile("<[^>]*CLSID:11111111-1111-1111-1111-11111111111[^>]*>", 10), Pattern.compile("^.*?Scripting\\.FileSystemObject.*?$", 10), Pattern.compile("^.*?new\\s+ActiveXObject.*?$", 10), Pattern.compile("<OBJECT\\s+[^>]+>", 10), Pattern.compile("https?://[^\\s\"']+?@[^\\s\"']+?", 10), Pattern.compile("^.*?Microsoft\\.XMLHTTP.*?$", 10), Pattern.compile("^.*?SaveToFile.*?$", 10), Pattern.compile("^.*?CreateObject\\(\\s*[\"']+Adodb.Stream[\"']\\s*\\)$", 10), Pattern.compile("^.*?execcommand.*?$", 10), Pattern.compile("(ms-its|ms-itss|mk:@MSITStore):mhtml:file://", 10), Pattern.compile("ms-its|ms-itss", 10), Pattern.compile("<iframe[^>]+src=['\"]*shell:[^>]+>", 10), Pattern.compile("showModalDialog\\([^)]*\\).location\\s*?=\\s*?[\"']javascript:[\"']<SCRIPT", 10), Pattern.compile("^.*?execScript.*?$", 10)};
    private static final String[] patternBadBodyDesc = new String[]{"Suspcious use of javascript 'file:javascript:eval'.", "Suspicious ActiveX CLSID 11111111-1111-1111-1111-... being used.", "Attempt to access Scripting.FileSystemObject.", "Inline creation of ActiveX object.", "ActiveX object used.", "URL with '@' to obscure hyperlink.", "Suspicious use of ActiveX XMLHTTP object (http://www.securityfocus.com/bid/8577)", "Suspicious scripting attempt to access local file via SafeToFile.  MS IE Self Executing HTML Arbitrary Code Execution Vulnerability.  (http://www.securityfocus.com/bid/8984)", "MS IE ADODB.Stream Object File Installation Weakness.  (http://www.securityfocus.com/bid/10514)", "MS IE ExecCommand Cross-Domain Access Violation Vulnerability (http://www.securityfocus.com/bid/9015)", "MS IE MT-ITS Protocol Zone Bypass Vulnerability (http://www.securityfocus.com/bid/9658)", "MS IE MT-ITS Protocol Zone Bypass Vulnerability (http://www.securityfocus.com/bid/9658)", "MS IE Shell: IFrame Cross-Zone Scripting Vulnerability (http://www.securityfocus.com/bid/9628)", "Microsoft Internet Explorer Modal Dialog Zone Bypass Vulnerability (http://www.securityfocus.com/bid/10473)", "Suspicious use of IE ActiveX Control Cross-Site Scripting (http://secunia.com/advisories/13482/)"};

    @Override
    public int getId() {
        return 90;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.malicious.name");
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
        if (httpMessage.getResponseHeader().isImage()) {
            this.checkImage(httpMessage);
        }
        if (httpMessage.getResponseHeader().isText()) {
            this.checkText(httpMessage);
        }
    }

    private void checkImage(HttpMessage httpMessage) {
    }

    private void checkText(HttpMessage httpMessage) {
        try {
            this.checkMaliciousCode(httpMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeOutput(String string, String string2, String string3) {
        this.getView().getOutputPanel().append("+ " + string + "\r\n");
        this.getView().getOutputPanel().append("- " + string2 + "\r\n");
        if (string3 != null) {
            this.getView().getOutputPanel().append("- " + string3 + "\r\n");
        }
        this.getView().getOutputPanel().append("\r\n");
    }

    private void checkMaliciousCode(HttpMessage httpMessage) {
        int n;
        Pattern pattern = null;
        Matcher matcher = null;
        String string = httpMessage.getRequestHeader().toString();
        String string2 = httpMessage.getResponseBody().toString();
        for (n = 0; n < patternBadHeaderList.length; ++n) {
            pattern = patternBadHeaderList[n];
            matcher = pattern.matcher(string);
            while (matcher.find()) {
                this.writeOutput(httpMessage.getRequestHeader().getURI().toString(), patternBadHeaderDesc[n], matcher.group(0));
            }
        }
        for (n = 0; n < patternBadBodyList.length; ++n) {
            pattern = patternBadBodyList[n];
            matcher = pattern.matcher(string2);
            while (matcher.find()) {
                this.writeOutput(httpMessage.getRequestHeader().getURI().toString(), patternBadBodyDesc[n], matcher.group(0));
            }
        }
    }
}

