/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.extension.api.ApiResponseSet;

public class ApiResponseConversionUtils {
    private static Logger logger = Logger.getLogger(ApiResponseConversionUtils.class);

    private ApiResponseConversionUtils() {
    }

    public static ApiResponseSet httpMessageToSet(int n, HttpMessage httpMessage) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("id", String.valueOf(n));
        hashMap.put("cookieParams", httpMessage.getCookieParamsAsString());
        hashMap.put("note", httpMessage.getNote());
        hashMap.put("requestHeader", httpMessage.getRequestHeader().toString());
        hashMap.put("requestBody", httpMessage.getRequestBody().toString());
        hashMap.put("responseHeader", httpMessage.getResponseHeader().toString());
        if ("gzip".equals(httpMessage.getResponseHeader().getHeader("Content-Encoding"))) {
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(httpMessage.getResponseBody().getBytes());
                 GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                 InputStreamReader inputStreamReader = new InputStreamReader(gZIPInputStream);
                 BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                StringBuilder stringBuilder = new StringBuilder();
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string);
                }
                hashMap.put("responseBody", stringBuilder.toString());
            }
            catch (IOException iOException) {
                logger.error((Object)("Unable to uncompress gzip content: " + iOException.getMessage()), (Throwable)iOException);
                hashMap.put("responseBody", httpMessage.getResponseBody().toString());
            }
        } else {
            hashMap.put("responseBody", httpMessage.getResponseBody().toString());
        }
        return new ApiResponseSet("message", hashMap);
    }
}

