/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.DefaultListModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.ascan.ActiveScanTableModel;
import org.zaproxy.zap.extension.ascan.ScanPolicy;
import org.zaproxy.zap.model.GenericScanner2;
import org.zaproxy.zap.model.Target;

public class ActiveScan
extends Scanner
implements GenericScanner2,
ScannerListener {
    private String displayName = null;
    private int progress = 0;
    private ActiveScanTableModel messagesTableModel = new ActiveScanTableModel();
    private SiteNode startNode = null;
    private AtomicInteger totalRequests = new AtomicInteger(0);
    private Date timeStarted = null;
    private Date timeFinished = null;
    private int maxResultsToList = 0;
    private final List<Integer> hRefs = Collections.synchronizedList(new ArrayList());
    private final List<Integer> alerts = Collections.synchronizedList(new ArrayList());
    private static final Logger log = Logger.getLogger(ActiveScan.class);

    public ActiveScan(String string, ScannerParam scannerParam, ConnectionParam connectionParam, ScanPolicy scanPolicy) {
        super(scannerParam, connectionParam, scanPolicy);
        this.displayName = string;
        this.maxResultsToList = scannerParam.getMaxResultsToList();
        this.addScannerListener(this);
    }

    @Override
    public int getMaximum() {
        return 100;
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    @Override
    public boolean isRunning() {
        return !this.isStop();
    }

    @Override
    public boolean isStopped() {
        return super.isStop();
    }

    @Override
    public void pauseScan() {
        if (this.isRunning()) {
            super.pause();
        }
    }

    @Override
    public void start(Target target) {
        this.reset();
        this.timeStarted = new Date();
        this.progress = 0;
        super.start(target);
    }

    @Override
    public void stopScan() {
        super.stop();
    }

    @Override
    public void resumeScan() {
        if (this.isPaused()) {
            super.resume();
        }
    }

    @Override
    public void alertFound(Alert alert) {
        int n = alert.getAlertId();
        if (n != -1) {
            this.alerts.add(alert.getAlertId());
        }
    }

    @Override
    public void hostComplete(int n, String string) {
    }

    @Override
    public void hostNewScan(int n, String string, HostProcess hostProcess) {
    }

    @Override
    public void hostProgress(int n, String string, String string2, int n2) {
        int n3 = 0;
        for (HostProcess hostProcess : this.getHostProcesses()) {
            n3 += hostProcess.getPercentageComplete();
        }
        this.progress = n3 / this.getHostProcesses().size();
    }

    @Override
    public void scannerComplete(int n) {
        this.timeFinished = new Date();
    }

    public DefaultListModel<HistoryReference> getList() {
        return null;
    }

    public ActiveScanTableModel getMessagesTableModel() {
        return this.messagesTableModel;
    }

    @Override
    public void notifyNewMessage(HttpMessage httpMessage) {
        HistoryReference historyReference = httpMessage.getHistoryRef();
        if (historyReference == null) {
            try {
                historyReference = new HistoryReference(Model.getSingleton().getSession(), 14, httpMessage);
                httpMessage.setHistoryRef(null);
                this.hRefs.add(historyReference.getHistoryId());
            }
            catch (DatabaseException | HttpMalformedHeaderException exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        } else {
            this.hRefs.add(historyReference.getHistoryId());
        }
        if (historyReference != null && this.totalRequests.incrementAndGet() <= this.maxResultsToList) {
            this.addHistoryReference(historyReference);
        }
    }

    private void addHistoryReference(HistoryReference historyReference) {
        if (View.isInitialised()) {
            this.addHistoryReferenceInEdt(historyReference);
        }
    }

    private void addHistoryReferenceInEdt(final HistoryReference historyReference) {
        if (EventQueue.isDispatchThread()) {
            this.messagesTableModel.addHistoryReference(historyReference);
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveScan.this.addHistoryReference(historyReference);
                }
            });
        }
    }

    @Override
    public SiteNode getStartNode() {
        return this.startNode;
    }

    @Override
    public void setStartNode(SiteNode siteNode) {
        this.startNode = siteNode;
        super.setStartNode(siteNode);
    }

    public void reset() {
        if (!View.isInitialised() || EventQueue.isDispatchThread()) {
            this.messagesTableModel.clear();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ActiveScan.this.reset();
                }
            });
        }
    }

    public int getTotalRequests() {
        return this.totalRequests.intValue();
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public List<Integer> getMessagesIds() {
        return this.hRefs;
    }

    public List<Integer> getAlertsIds() {
        return this.alerts;
    }

    public State getState() {
        if (this.timeStarted == null) {
            return State.NOT_STARTED;
        }
        if (this.isStop()) {
            return State.FINISHED;
        }
        if (this.isPaused()) {
            return State.PAUSED;
        }
        return State.RUNNING;
    }

    @Override
    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setScanId(int n) {
        this.setId(n);
    }

    @Override
    public int getScanId() {
        return this.getId();
    }

    public static enum State {
        NOT_STARTED,
        RUNNING,
        PAUSED,
        FINISHED;

    }
}

