/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.ascan;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMapEventPublisher;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZAP;
import org.zaproxy.zap.eventBus.Event;
import org.zaproxy.zap.eventBus.EventConsumer;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.ascan.AttackScan;
import org.zaproxy.zap.extension.ascan.ExtensionActiveScan;
import org.zaproxy.zap.extension.log4j.ExtensionLog4j;
import org.zaproxy.zap.view.ScanStatus;

public class AttackModeScanner
implements EventConsumer {
    private static final String ATTACK_ICON_RESOURCE = "/resource/icon/16/093.png";
    private ExtensionActiveScan extension;
    private Date lastUpdated = new Date();
    private ScanStatus scanStatus;
    private ExtensionAlert extAlert = null;
    private AttackModeThread attackModeThread = null;
    private boolean rescanOnChange = false;
    private Logger log = Logger.getLogger(AttackModeScanner.class);
    private List<SiteNode> nodeStack = new ArrayList<SiteNode>();

    public AttackModeScanner(ExtensionActiveScan extensionActiveScan) {
        this.extension = extensionActiveScan;
        ZAP.getEventBus().registerConsumer(this, SiteMapEventPublisher.class.getCanonicalName());
        this.scanStatus = new ScanStatus(new ImageIcon(ExtensionLog4j.class.getResource("/resource/icon/fugue/target.png")), Constant.messages.getString("ascan.attack.icon.title"));
    }

    public void start() {
        this.log.debug((Object)"Starting");
        this.nodeStack.clear();
        this.addAllInScope();
        if (this.attackModeThread != null) {
            this.attackModeThread.shutdown();
        }
        this.attackModeThread = new AttackModeThread();
        Thread thread = new Thread(this.attackModeThread);
        thread.setName("ZAP-AttackMode");
        thread.start();
    }

    private void addAllInScope() {
        if (this.rescanOnChange) {
            this.nodeStack.addAll(Model.getSingleton().getSession().getNodesInScopeFromSiteTree());
            this.log.debug((Object)("Added existing in scope nodes to attack mode stack " + this.nodeStack.size()));
            this.updateCount();
        }
    }

    public void stop() {
        this.log.debug((Object)"Stopping");
        if (this.attackModeThread != null) {
            this.attackModeThread.shutdown();
        }
        this.nodeStack.clear();
        this.updateCount();
    }

    @Override
    public void eventReceived(Event event) {
        if (this.attackModeThread != null && this.attackModeThread.isRunning()) {
            if (event.getEventType().equals("siteNode.added") && event.getTarget().getStartNode().isIncludedInScope()) {
                if (event.getTarget().getStartNode().getHistoryReference().getHistoryType() != 0) {
                    this.log.debug((Object)("Adding node to attack mode stack " + event.getTarget().getStartNode()));
                    this.nodeStack.add(event.getTarget().getStartNode());
                    this.updateCount();
                }
            } else if (event.getEventType().equals("siteNode.removed") && this.nodeStack.contains(event.getTarget().getStartNode())) {
                this.nodeStack.remove(event.getTarget().getStartNode());
            }
        }
    }

    public ScanStatus getScanStatus() {
        return this.scanStatus;
    }

    public void sessionScopeChanged(Session session) {
        this.addAllInScope();
    }

    public void sessionModeChanged(Control.Mode mode) {
        if (mode.equals((Object)Control.Mode.attack)) {
            if (View.isInitialised() && this.extension.getScannerParam().isPromptInAttackMode()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int n = View.getSingleton().showYesNoRememberDialog(View.getSingleton().getMainFrame(), Constant.messages.getString("ascan.attack.prompt"));
                        if (View.getSingleton().isRememberLastDialogChosen()) {
                            AttackModeScanner.this.extension.getScannerParam().setPromptInAttackMode(false);
                            AttackModeScanner.this.extension.getScannerParam().setRescanInAttackMode(n == 0);
                        }
                        AttackModeScanner.this.rescanOnChange = n == 0;
                        AttackModeScanner.this.start();
                    }
                });
            } else {
                this.rescanOnChange = this.extension.getScannerParam().isRescanInAttackMode();
                this.start();
            }
        } else {
            this.stop();
        }
    }

    private void updateCount() {
        Date date = new Date();
        if (date.getTime() - this.lastUpdated.getTime() > 200L) {
            this.lastUpdated = date;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AttackModeScanner.this.scanStatus.setScanCount(AttackModeScanner.this.nodeStack.size());
                }
            });
        }
    }

    public int getStackSize() {
        int n = this.nodeStack.size();
        if (n > 0) {
            return n;
        }
        if (this.attackModeThread != null && this.attackModeThread.isActive()) {
            return 0;
        }
        return -1;
    }

    public boolean isRescanOnChange() {
        return this.rescanOnChange;
    }

    public void setRescanOnChange(boolean bl) {
        this.rescanOnChange = bl;
    }

    private ExtensionAlert getExtensionAlert() {
        if (this.extAlert == null) {
            this.extAlert = (ExtensionAlert)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAlert");
        }
        return this.extAlert;
    }

    private class AttackModeThread
    implements Runnable,
    ScannerListener {
        private int scannerCount = 4;
        private List<Scanner> scanners = new ArrayList<Scanner>();
        private AttackScan ascanWrapper;
        private boolean running = false;

        private AttackModeThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            AttackModeScanner.this.log.debug((Object)"Starting attack thread");
            this.running = true;
            this.ascanWrapper = new AttackScan(Constant.messages.getString("ascan.attack.scan"), AttackModeScanner.this.extension.getScannerParam(), AttackModeScanner.this.extension.getModel().getOptionsParam().getConnectionParam(), AttackModeScanner.this.extension.getPolicyManager().getAttackScanPolicy());
            AttackModeScanner.this.extension.registerScan(this.ascanWrapper);
            while (this.running) {
                if (AttackModeScanner.this.scanStatus.getScanCount() != AttackModeScanner.this.nodeStack.size()) {
                    AttackModeScanner.this.updateCount();
                }
                if (AttackModeScanner.this.nodeStack.size() == 0 || this.scanners.size() == this.scannerCount) {
                    if (this.scanners.size() > 0) {
                        this.scannerComplete(-1);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                while (AttackModeScanner.this.nodeStack.size() > 0 && this.scanners.size() < this.scannerCount) {
                    object = (SiteNode)AttackModeScanner.this.nodeStack.remove(0);
                    AttackModeScanner.this.log.debug((Object)("Attacking node " + ((SiteNode)object).getNodeName()));
                    Scanner scanner = new Scanner(AttackModeScanner.this.extension.getScannerParam(), AttackModeScanner.this.extension.getModel().getOptionsParam().getConnectionParam(), AttackModeScanner.this.extension.getPolicyManager().getAttackScanPolicy());
                    scanner.setStartNode((SiteNode)object);
                    scanner.setScanChildren(false);
                    scanner.addScannerListener(this);
                    List<Scanner> object2 = this.scanners;
                    synchronized (object2) {
                        this.scanners.add(scanner);
                    }
                    if (View.isInitialised()) {
                        ((SiteNode)object).addCustomIcon(AttackModeScanner.ATTACK_ICON_RESOURCE, false);
                    }
                    scanner.start((SiteNode)object);
                }
            }
            object = this.scanners;
            synchronized (object) {
                for (Scanner scanner : this.scanners) {
                    scanner.stop();
                }
            }
            AttackModeScanner.this.log.debug((Object)"Attack thread finished");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scannerComplete(int n) {
            ArrayList<Scanner> arrayList = new ArrayList<Scanner>();
            List<Scanner> list = this.scanners;
            synchronized (list) {
                for (Scanner scanner : this.scanners) {
                    if (!scanner.isStop()) continue;
                    SiteNode siteNode = scanner.getStartNode();
                    if (siteNode != null) {
                        AttackModeScanner.this.log.debug((Object)("Finished attacking node " + siteNode.getNodeName()));
                        if (View.isInitialised()) {
                            siteNode.removeCustomIcon(AttackModeScanner.ATTACK_ICON_RESOURCE);
                        }
                    }
                    arrayList.add(scanner);
                }
                for (Scanner scanner : arrayList) {
                    this.scanners.remove(scanner);
                }
            }
            AttackModeScanner.this.updateCount();
        }

        @Override
        public void hostNewScan(int n, String string, HostProcess hostProcess) {
        }

        @Override
        public void hostProgress(int n, String string, String string2, int n2) {
        }

        @Override
        public void hostComplete(int n, String string) {
        }

        @Override
        public void alertFound(Alert alert) {
            AttackModeScanner.this.getExtensionAlert().alertFound(alert, alert.getHistoryRef());
        }

        @Override
        public void notifyNewMessage(HttpMessage httpMessage) {
            this.ascanWrapper.notifyNewMessage(httpMessage);
        }

        public void shutdown() {
            this.running = false;
        }

        public boolean isRunning() {
            return this.running;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            List<Scanner> list = this.scanners;
            synchronized (list) {
                for (Scanner scanner : this.scanners) {
                    if (scanner.isStop()) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

