/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.globalexcludeurl;

import java.awt.Dialog;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.globalexcludeurl.GlobalExcludeURLParamToken;
import org.zaproxy.zap.utils.ZapTextField;
import org.zaproxy.zap.view.AbstractFormDialog;

class DialogAddToken
extends AbstractFormDialog {
    private static final long serialVersionUID = 4460797449668634319L;
    private static final String DIALOG_TITLE = Constant.messages.getString("options.globalexcludeurl.dialog.token.add.title");
    private static final String CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.add.button.confirm");
    private static final String NAME_FIELD_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.field.label.name");
    private static final String ENABLED_FIELD_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.field.label.enabled");
    private static final String DESC_FIELD_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.field.label.description");
    private static final String TITLE_NAME_REPEATED_DIALOG = Constant.messages.getString("options.globalexcludeurl.dialog.token.warning.name.repeated.title");
    private static final String TEXT_NAME_REPEATED_DIALOG = Constant.messages.getString("options.globalexcludeurl.dialog.token.warning.name.repeated.text");
    private ZapTextField regexTextField;
    private JCheckBox enabledCheckBox;
    private ZapTextField descTextField;
    protected GlobalExcludeURLParamToken token;
    private List<GlobalExcludeURLParamToken> tokens;

    public DialogAddToken(Dialog dialog) {
        super(dialog, DIALOG_TITLE);
    }

    protected DialogAddToken(Dialog dialog, String string) {
        super(dialog, string);
    }

    @Override
    protected JPanel getFieldsPanel() {
        JPanel jPanel = new JPanel();
        GroupLayout groupLayout = new GroupLayout(jPanel);
        jPanel.setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        JLabel jLabel = new JLabel(NAME_FIELD_LABEL);
        JLabel jLabel2 = new JLabel(ENABLED_FIELD_LABEL);
        JLabel jLabel3 = new JLabel(DESC_FIELD_LABEL);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(jLabel).addComponent(jLabel2).addComponent(jLabel3)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getRegexTextField()).addComponent(this.getEnabledCheckBox()).addComponent(this.getDescTextField())));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel).addComponent(this.getRegexTextField())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.getEnabledCheckBox())).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel3).addComponent(this.getDescTextField())));
        return jPanel;
    }

    @Override
    protected String getConfirmButtonLabel() {
        return CONFIRM_BUTTON_LABEL;
    }

    @Override
    protected void init() {
        this.getRegexTextField().setText("");
        this.getEnabledCheckBox().setSelected(true);
        this.getDescTextField().setText("");
        this.token = null;
    }

    @Override
    protected boolean validateFields() {
        String string = this.getRegexTextField().getText();
        for (GlobalExcludeURLParamToken globalExcludeURLParamToken : this.tokens) {
            if (!string.equalsIgnoreCase(globalExcludeURLParamToken.getRegex())) continue;
            JOptionPane.showMessageDialog(this, TEXT_NAME_REPEATED_DIALOG, TITLE_NAME_REPEATED_DIALOG, 1);
            this.getRegexTextField().requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected void performAction() {
        this.token = new GlobalExcludeURLParamToken(this.getRegexTextField().getText(), this.getDescTextField().getText(), this.getEnabledCheckBox().isSelected());
    }

    @Override
    protected void clearFields() {
        this.getRegexTextField().setText("");
        this.getRegexTextField().discardAllEdits();
        this.getDescTextField().setText("");
    }

    public GlobalExcludeURLParamToken getToken() {
        return this.token;
    }

    protected ZapTextField getRegexTextField() {
        if (this.regexTextField == null) {
            this.regexTextField = new ZapTextField(25);
            this.regexTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                private void checkAndEnableConfirmButton() {
                    DialogAddToken.this.setConfirmButtonEnabled(DialogAddToken.this.getRegexTextField().getDocument().getLength() > 0);
                }
            });
        }
        return this.regexTextField;
    }

    protected JCheckBox getEnabledCheckBox() {
        if (this.enabledCheckBox == null) {
            this.enabledCheckBox = new JCheckBox();
        }
        return this.enabledCheckBox;
    }

    protected ZapTextField getDescTextField() {
        if (this.descTextField == null) {
            this.descTextField = new ZapTextField(25);
            this.descTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    this.checkAndEnableConfirmButton();
                }

                private void checkAndEnableConfirmButton() {
                    DialogAddToken.this.setConfirmButtonEnabled(DialogAddToken.this.getDescTextField().getDocument().getLength() > 0);
                }
            });
        }
        return this.descTextField;
    }

    public void setTokens(List<GlobalExcludeURLParamToken> list) {
        this.tokens = list;
    }

    public void clear() {
        this.tokens = null;
        this.token = null;
    }
}

