/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.component;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import org.apache.commons.configuration.FileConfiguration;
import org.apache.log4j.Logger;
import org.zaproxy.zap.extension.httppanel.HttpPanel;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelDefaultViewSelector;
import org.zaproxy.zap.extension.httppanel.view.HttpPanelView;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.extension.search.SearchableHttpPanelView;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.utils.SortedComboBoxModel;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlighter;

public class HttpPanelComponentViewsManager
implements ItemListener,
MessageLocationHighlighter {
    private static final Logger logger = Logger.getLogger(HttpPanelComponentViewsManager.class);
    private static final String VIEWS_KEY = "views";
    private static final String DEFAULT_VIEW_KEY = "defaultview";
    private static DefaultViewSelectorComparator defaultViewSelectorComparator;
    private Message message;
    private JPanel panelViews;
    private JComboBox<ViewItem> comboBoxSelectView;
    private MutableComboBoxModel<ViewItem> comboBoxModel;
    private HttpPanelView currentView;
    private List<ViewItem> enabledViews = new ArrayList<ViewItem>();
    private Map<String, ViewItem> viewItems = new HashMap<String, ViewItem>();
    private Map<String, HttpPanelView> views = new HashMap<String, HttpPanelView>();
    private List<HttpPanelDefaultViewSelector> defaultViewsSelectors = new ArrayList<HttpPanelDefaultViewSelector>();
    private String savedSelectedViewName;
    private String configurationKey;
    private String viewsConfigurationKey;
    private boolean isEditable = false;
    private Object changingComboBoxLocker;
    private boolean changingComboBox;
    private HttpPanel owner;

    public HttpPanelComponentViewsManager(String string) {
        this.configurationKey = string;
        this.viewsConfigurationKey = "";
        this.changingComboBoxLocker = new Object();
        this.changingComboBox = false;
        this.savedSelectedViewName = null;
        this.comboBoxModel = new SortedComboBoxModel<ViewItem>();
        this.comboBoxSelectView = new JComboBox<ViewItem>(this.comboBoxModel);
        this.comboBoxSelectView.addItemListener(this);
        this.panelViews = new JPanel(new CardLayout());
    }

    public HttpPanelComponentViewsManager(String string, String string2) {
        this(string);
        this.comboBoxSelectView.setRenderer(new CustomDelegateListCellRenderer(this.comboBoxSelectView, string2));
    }

    public HttpPanelComponentViewsManager(HttpPanel httpPanel, String string) {
        this(string);
        this.owner = httpPanel;
    }

    public HttpPanelComponentViewsManager(HttpPanel httpPanel, String string, String string2) {
        this(string, string2);
        this.owner = httpPanel;
    }

    public JComponent getSelectableViewsComponent() {
        return this.comboBoxSelectView;
    }

    public JPanel getViewsPanel() {
        return this.panelViews;
    }

    public void setSelected(boolean bl) {
        if (this.currentView != null) {
            this.currentView.setSelected(bl);
        }
    }

    private void switchView(String string) {
        if (this.currentView != null && this.currentView.getCaptionName().equals(string)) {
            this.currentView.setSelected(true);
            if (this.owner != null) {
                this.owner.fireMessageViewChangedEvent(this.currentView, this.currentView);
            }
            return;
        }
        HttpPanelView httpPanelView = this.views.get(string);
        if (httpPanelView == null) {
            logger.info((Object)("No view found with name: " + string));
            return;
        }
        HttpPanelView httpPanelView2 = this.currentView;
        if (this.currentView != null) {
            this.currentView.setSelected(false);
            this.currentView.getModel().clear();
        }
        this.currentView = httpPanelView;
        this.comboBoxModel.setSelectedItem(this.viewItems.get(string));
        this.currentView.getModel().setMessage(this.message);
        ((CardLayout)this.panelViews.getLayout()).show(this.panelViews, string);
        this.currentView.setSelected(true);
        if (this.owner != null) {
            this.owner.fireMessageViewChangedEvent(httpPanelView2, this.currentView);
        }
    }

    public void setMessage(Message message) {
        this.message = message;
        this.enableViews();
        String string = this.getDefaultEnabledViewName();
        if (string != null) {
            if (string.equals(this.currentView.getName())) {
                this.currentView.getModel().setMessage(this.message);
            } else {
                this.switchView(string);
            }
        } else if (!this.enabledViews.contains(this.viewItems.get(this.currentView.getName()))) {
            this.switchView(this.enabledViews.get(0).getConfigName());
        } else {
            this.currentView.getModel().setMessage(this.message);
        }
    }

    private void enableViews() {
        Iterator<Map.Entry<String, HttpPanelView>> iterator = this.views.entrySet().iterator();
        while (iterator.hasNext()) {
            HttpPanelView httpPanelView = iterator.next().getValue();
            ViewItem viewItem = this.viewItems.get(httpPanelView.getName());
            if (!httpPanelView.isEnabled(this.message)) {
                if (!this.enabledViews.contains(viewItem)) continue;
                this.disableView(viewItem);
                continue;
            }
            if (this.enabledViews.contains(viewItem)) continue;
            this.enableView(viewItem);
        }
    }

    private String getDefaultEnabledViewName() {
        String string = null;
        for (HttpPanelDefaultViewSelector httpPanelDefaultViewSelector : this.defaultViewsSelectors) {
            if (!httpPanelDefaultViewSelector.matchToDefaultView(this.message) || !this.enabledViews.contains(this.viewItems.get(httpPanelDefaultViewSelector.getViewName()))) continue;
            string = httpPanelDefaultViewSelector.getViewName();
            break;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = this.changingComboBoxLocker;
        synchronized (object) {
            if (this.changingComboBox) {
                return;
            }
        }
        if (itemEvent.getStateChange() == 1) {
            if (this.currentView == null) {
                return;
            }
            object = (ViewItem)this.comboBoxModel.getSelectedItem();
            if (object == null || ((ViewItem)object).getConfigName().equals(this.currentView.getName())) {
                return;
            }
            this.save();
            this.switchView(((ViewItem)object).getConfigName());
        }
    }

    public void save() {
        if (this.message == null || this.currentView == null) {
            return;
        }
        if (this.isEditable && this.currentView.hasChanged()) {
            this.currentView.save();
        }
    }

    public void addView(HttpPanelView httpPanelView) {
        String string = httpPanelView.getTargetViewName();
        if (!"".equals(string) && this.views.containsKey(string)) {
            this.removeView(string);
        }
        String string2 = httpPanelView.getName();
        this.views.put(string2, httpPanelView);
        ViewItem viewItem = new ViewItem(string2, httpPanelView.getCaptionName(), httpPanelView.getPosition());
        this.viewItems.put(string2, viewItem);
        this.panelViews.add((Component)httpPanelView.getPane(), string2);
        httpPanelView.setEditable(this.isEditable);
        httpPanelView.setParentConfigurationKey(this.viewsConfigurationKey);
        if (httpPanelView.isEnabled(this.message)) {
            this.enableView(viewItem);
            boolean bl = false;
            if (this.currentView == null) {
                bl = true;
            } else if (this.savedSelectedViewName != null) {
                if (this.savedSelectedViewName.equals(string2)) {
                    bl = true;
                } else if (!this.savedSelectedViewName.equals(this.currentView.getName()) && this.currentView.getPosition() > httpPanelView.getPosition()) {
                    bl = true;
                }
            } else if (this.currentView.getPosition() > httpPanelView.getPosition()) {
                bl = true;
            }
            if (bl) {
                this.switchView(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableView(ViewItem viewItem) {
        this.enabledViews.add(viewItem);
        Collections.sort(this.enabledViews);
        Object object = this.changingComboBoxLocker;
        synchronized (object) {
            this.changingComboBox = true;
            this.comboBoxModel.addElement(viewItem);
            this.changingComboBox = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableView(ViewItem viewItem) {
        this.enabledViews.remove(viewItem);
        Object object = this.changingComboBoxLocker;
        synchronized (object) {
            this.changingComboBox = true;
            this.comboBoxModel.removeElement(viewItem);
            this.changingComboBox = false;
        }
    }

    public void addView(HttpPanelView httpPanelView, FileConfiguration fileConfiguration) {
        this.addView(httpPanelView);
        httpPanelView.loadConfiguration(fileConfiguration);
    }

    public void removeView(String string) {
        HttpPanelView httpPanelView = this.views.get(string);
        if (httpPanelView == null) {
            return;
        }
        this.views.remove(string);
        this.panelViews.remove(httpPanelView.getPane());
        ViewItem viewItem = this.viewItems.get(string);
        if (this.enabledViews.contains(viewItem)) {
            this.disableView(viewItem);
        }
        this.viewItems.remove(httpPanelView.getName());
        if (string.equals(this.currentView.getName())) {
            if (this.enabledViews.size() > 0) {
                this.switchView(this.enabledViews.get(0).getConfigName());
            } else {
                this.currentView = null;
            }
        }
    }

    public void clearView() {
        if (this.currentView != null) {
            this.currentView.getModel().clear();
            this.setMessage(null);
        }
    }

    public void clearView(boolean bl) {
        this.clearView();
        this.setEnableViewSelect(bl);
    }

    public void setEnableViewSelect(boolean bl) {
        this.comboBoxSelectView.setEnabled(bl);
    }

    public void addDefaultViewSelector(HttpPanelDefaultViewSelector httpPanelDefaultViewSelector) {
        this.defaultViewsSelectors.add(httpPanelDefaultViewSelector);
        Collections.sort(this.defaultViewsSelectors, HttpPanelComponentViewsManager.getDefaultViewSelectorComparator());
    }

    public void removeDefaultViewSelector(String string) {
        for (HttpPanelDefaultViewSelector httpPanelDefaultViewSelector : this.defaultViewsSelectors) {
            if (!httpPanelDefaultViewSelector.getName().equals(string)) continue;
            this.defaultViewsSelectors.remove(httpPanelDefaultViewSelector);
            break;
        }
    }

    private static Comparator<HttpPanelDefaultViewSelector> getDefaultViewSelectorComparator() {
        if (defaultViewSelectorComparator == null) {
            HttpPanelComponentViewsManager.createDefaultViewSelectorComparator();
        }
        return defaultViewSelectorComparator;
    }

    private static synchronized void createDefaultViewSelectorComparator() {
        if (defaultViewSelectorComparator == null) {
            defaultViewSelectorComparator = new DefaultViewSelectorComparator();
        }
    }

    public void setConfigurationKey(String string) {
        this.configurationKey = string + this.configurationKey + ".";
        this.viewsConfigurationKey = this.configurationKey + VIEWS_KEY + ".";
        Iterator<HttpPanelView> iterator = this.views.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().setParentConfigurationKey(this.viewsConfigurationKey);
        }
    }

    public void loadConfig(FileConfiguration fileConfiguration) {
        this.savedSelectedViewName = fileConfiguration.getString(this.configurationKey + DEFAULT_VIEW_KEY);
        Iterator<HttpPanelView> iterator = this.views.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().loadConfiguration(fileConfiguration);
        }
    }

    public void saveConfig(FileConfiguration fileConfiguration) {
        if (this.currentView != null) {
            fileConfiguration.setProperty(this.configurationKey + DEFAULT_VIEW_KEY, (Object)this.currentView.getName());
        }
        Iterator<HttpPanelView> iterator = this.views.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().saveConfiguration(fileConfiguration);
        }
    }

    public void setEditable(boolean bl) {
        if (this.isEditable != bl) {
            this.isEditable = bl;
            Iterator<HttpPanelView> iterator = this.views.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().setEditable(bl);
            }
        }
    }

    public void highlight(SearchMatch searchMatch) {
        if (this.currentView instanceof SearchableHttpPanelView) {
            ((SearchableHttpPanelView)((Object)this.currentView)).highlight(searchMatch);
        } else {
            SearchableHttpPanelView searchableHttpPanelView = this.findSearchableView();
            if (this.currentView != null) {
                this.switchView(((HttpPanelView)((Object)searchableHttpPanelView)).getName());
                searchableHttpPanelView.highlight(searchMatch);
            }
        }
    }

    public void search(Pattern pattern, List<SearchMatch> list) {
        if (this.currentView instanceof SearchableHttpPanelView) {
            ((SearchableHttpPanelView)((Object)this.currentView)).search(pattern, list);
        } else {
            SearchableHttpPanelView searchableHttpPanelView = this.findSearchableView();
            if (searchableHttpPanelView != null) {
                searchableHttpPanelView.search(pattern, list);
            }
        }
    }

    private SearchableHttpPanelView findSearchableView() {
        SearchableHttpPanelView searchableHttpPanelView = null;
        for (HttpPanelView httpPanelView : this.views.values()) {
            if (!httpPanelView.isEnabled(this.message) || !(httpPanelView instanceof SearchableHttpPanelView)) continue;
            searchableHttpPanelView = (SearchableHttpPanelView)((Object)httpPanelView);
            break;
        }
        return searchableHttpPanelView;
    }

    @Override
    public boolean supports(MessageLocation messageLocation) {
        for (ViewItem viewItem : this.enabledViews) {
            MessageLocationHighlighter messageLocationHighlighter;
            HttpPanelView httpPanelView = this.views.get(viewItem.getConfigName());
            if (!(httpPanelView instanceof MessageLocationHighlighter) || !(messageLocationHighlighter = (MessageLocationHighlighter)((Object)httpPanelView)).supports(messageLocation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> clazz) {
        for (ViewItem viewItem : this.enabledViews) {
            MessageLocationHighlighter messageLocationHighlighter;
            HttpPanelView httpPanelView = this.views.get(viewItem.getConfigName());
            if (!(httpPanelView instanceof MessageLocationHighlighter) || !(messageLocationHighlighter = (MessageLocationHighlighter)((Object)httpPanelView)).supports(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation) {
        if (this.currentView instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter messageLocationHighlighter = (MessageLocationHighlighter)((Object)this.currentView);
            return messageLocationHighlighter.highlight(messageLocation);
        }
        return null;
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (this.currentView instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter messageLocationHighlighter = (MessageLocationHighlighter)((Object)this.currentView);
            return messageLocationHighlighter.highlight(messageLocation, messageLocationHighlight);
        }
        return null;
    }

    @Override
    public void removeHighlight(MessageLocation messageLocation, MessageLocationHighlight messageLocationHighlight) {
        if (this.currentView instanceof MessageLocationHighlighter) {
            MessageLocationHighlighter messageLocationHighlighter = (MessageLocationHighlighter)((Object)this.currentView);
            messageLocationHighlighter.removeHighlight(messageLocation, messageLocationHighlight);
        }
    }

    public HttpPanelView setSelectedView(String string) {
        for (ViewItem viewItem : this.enabledViews) {
            if (!string.equals(viewItem.getConfigName())) continue;
            this.switchView(string);
            return this.currentView;
        }
        return null;
    }

    private static final class DefaultViewSelectorComparator
    implements Comparator<HttpPanelDefaultViewSelector>,
    Serializable {
        private static final long serialVersionUID = -1380844848294384189L;

        private DefaultViewSelectorComparator() {
        }

        @Override
        public int compare(HttpPanelDefaultViewSelector httpPanelDefaultViewSelector, HttpPanelDefaultViewSelector httpPanelDefaultViewSelector2) {
            int n;
            int n2 = httpPanelDefaultViewSelector.getOrder();
            if (n2 < (n = httpPanelDefaultViewSelector2.getOrder())) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    }

    private static final class CustomDelegateListCellRenderer
    implements ListCellRenderer<ViewItem> {
        private ListCellRenderer<? super ViewItem> delegateRenderer;
        private JComboBox<ViewItem> comboBox;
        private String label;
        private ViewItem viewItem;

        public CustomDelegateListCellRenderer(JComboBox<ViewItem> jComboBox, String string) {
            this.delegateRenderer = jComboBox.getRenderer();
            this.comboBox = jComboBox;
            this.label = string;
            this.viewItem = new ViewItem("", "", -1);
            this.comboBox.addPropertyChangeListener("UI", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    CustomDelegateListCellRenderer.this.delegateRenderer = new JComboBox().getRenderer();
                }
            });
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ViewItem> jList, ViewItem viewItem, int n, boolean bl, boolean bl2) {
            if (n != -1) {
                return this.delegateRenderer.getListCellRendererComponent(jList, viewItem, n, bl, bl2);
            }
            this.viewItem.name = this.label + viewItem.name;
            return this.delegateRenderer.getListCellRendererComponent(jList, this.viewItem, n, bl, bl2);
        }
    }

    private static final class ViewItem
    implements Comparable<ViewItem> {
        private final String configName;
        private String name;
        private final int position;

        public ViewItem(String string, String string2, int n) {
            this.configName = string;
            this.name = string2;
            this.position = n;
        }

        public String getConfigName() {
            return this.configName;
        }

        @Override
        public int compareTo(ViewItem viewItem) {
            if (this.position < viewItem.position) {
                return -1;
            }
            if (this.position > viewItem.position) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            return 31 * this.configName.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ViewItem viewItem = (ViewItem)object;
            return this.configName.equals(viewItem.configName);
        }

        public String toString() {
            return this.name;
        }
    }
}

