/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.params;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.params.HtmlParameterStats;

public class ParamsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final int COLUMN_COUNT = 7;
    private final Vector<String> columnNames = new Vector(7);
    private List<HtmlParameterStats> paramStats;
    private int lastAddedRow;
    private int lastEditedRow;

    public ParamsTableModel() {
        this.columnNames.add(Constant.messages.getString("params.table.header.type"));
        this.columnNames.add(Constant.messages.getString("params.table.header.name"));
        this.columnNames.add(Constant.messages.getString("params.table.header.used"));
        this.columnNames.add(Constant.messages.getString("params.table.header.numvals"));
        this.columnNames.add(Constant.messages.getString("params.table.header.pcchange"));
        this.columnNames.add(Constant.messages.getString("params.table.header.flags"));
        this.columnNames.add(Constant.messages.getString("params.table.header.values"));
        this.paramStats = Collections.synchronizedList(new ArrayList());
        this.lastAddedRow = -1;
        this.lastEditedRow = -1;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public int getRowCount() {
        return this.paramStats.size();
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames.get(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        if (n >= this.paramStats.size()) {
            return null;
        }
        HtmlParameterStats htmlParameterStats = this.paramStats.get(n);
        switch (n2) {
            case 0: {
                object = Constant.messages.getString("params.type." + htmlParameterStats.getType().name());
                break;
            }
            case 1: {
                object = htmlParameterStats.getName();
                break;
            }
            case 2: {
                object = htmlParameterStats.getTimesUsed();
                break;
            }
            case 3: {
                object = htmlParameterStats.getValues().size();
                break;
            }
            case 4: {
                object = this.getPercentChange(htmlParameterStats);
                break;
            }
            case 5: {
                object = htmlParameterStats.getAllFlags();
                break;
            }
            case 6: {
                object = htmlParameterStats.getValuesSummary();
            }
        }
        return object;
    }

    private int getPercentChange(HtmlParameterStats htmlParameterStats) {
        if (htmlParameterStats.getValues().size() == 1) {
            return 0;
        }
        return htmlParameterStats.getValues().size() * 100 / htmlParameterStats.getTimesUsed();
    }

    public HtmlParameterStats getHtmlParameterStatsAtRow(int n) {
        return this.paramStats.get(n);
    }

    public void addHtmlParameterStats(HtmlParameterStats htmlParameterStats) {
        this.lastAddedRow = -1;
        for (int i = 0; i < this.paramStats.size(); ++i) {
            int n = htmlParameterStats.compareTo(this.paramStats.get(i));
            if (n < 0) {
                this.paramStats.add(i, htmlParameterStats);
                this.fireTableRowsInserted(i, i);
                this.lastAddedRow = i;
                return;
            }
            if (n != 0) continue;
            this.lastAddedRow = i;
            return;
        }
        this.paramStats.add(htmlParameterStats);
        this.fireTableRowsInserted(this.paramStats.size() - 1, this.paramStats.size() - 1);
        this.lastAddedRow = this.paramStats.size() - 1;
    }

    public int getLastAddedRow() {
        return this.lastAddedRow;
    }

    public int getLastEditedRow() {
        return this.lastEditedRow;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Class<? extends Object> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Integer.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return String.class;
            }
        }
        return null;
    }

    public void removeAllElements() {
        this.paramStats.clear();
    }
}

