/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;

public class PolicyPassiveScanTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{Constant.messages.getString("ascan.policy.table.testname"), Constant.messages.getString("ascan.policy.table.threshold"), Constant.messages.getString("ascan.policy.table.quality")};
    private List<ScannerWrapper> listScanners = new ArrayList<ScannerWrapper>();
    private Map<String, String> i18nToStr = null;

    public void addScanner(PluginPassiveScanner pluginPassiveScanner) {
        this.listScanners.add(new ScannerWrapper(pluginPassiveScanner));
        this.fireTableDataChanged();
    }

    public void persistChanges() {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            scannerWrapper.persistChanges();
        }
    }

    public void reset() {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            scannerWrapper.reset();
        }
    }

    public void applyThreshold(Plugin.AlertThreshold alertThreshold, String string) {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            if (!string.equals(scannerWrapper.getQuality())) continue;
            scannerWrapper.setThreshold(alertThreshold);
        }
    }

    public void applyThresholdToAll(Plugin.AlertThreshold alertThreshold) {
        for (ScannerWrapper scannerWrapper : this.listScanners) {
            scannerWrapper.setThreshold(alertThreshold);
        }
    }

    public void removeScanner(PluginPassiveScanner pluginPassiveScanner) {
        for (int i = 0; i < this.listScanners.size(); ++i) {
            if (!pluginPassiveScanner.equals(this.listScanners.get(i).getScanner())) continue;
            this.listScanners.remove(i);
            this.fireTableRowsDeleted(i, i);
            break;
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        return columnNames[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 1;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        ScannerWrapper scannerWrapper = this.listScanners.get(n);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                Plugin.AlertThreshold alertThreshold = Plugin.AlertThreshold.valueOf(this.i18nToStr((String)object));
                scannerWrapper.setThreshold(alertThreshold);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    private String strToI18n(String string) {
        return Constant.messages.getString("ascan.policy.level." + string.toLowerCase());
    }

    private String i18nToStr(String string) {
        if (this.i18nToStr == null) {
            this.i18nToStr = new HashMap<String, String>();
            for (Plugin.AlertThreshold alertThreshold : Plugin.AlertThreshold.values()) {
                this.i18nToStr.put(this.strToI18n(alertThreshold.name()), alertThreshold.name());
            }
        }
        return this.i18nToStr.get(string);
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public int getRowCount() {
        if (this.listScanners == null) {
            return 0;
        }
        return this.listScanners.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ScannerWrapper scannerWrapper = this.listScanners.get(n);
        String string = null;
        switch (n2) {
            case 0: {
                string = scannerWrapper.getName();
                break;
            }
            case 1: {
                string = this.strToI18n(scannerWrapper.getThreshold().name());
                break;
            }
            case 2: {
                string = scannerWrapper.getQuality();
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    private static class ScannerWrapper {
        private final PluginPassiveScanner scanner;
        private Plugin.AlertThreshold threshold;

        public ScannerWrapper(PluginPassiveScanner pluginPassiveScanner) {
            this.scanner = pluginPassiveScanner;
            this.reset();
        }

        public PluginPassiveScanner getScanner() {
            return this.scanner;
        }

        public void reset() {
            this.threshold = this.scanner.getLevel();
        }

        public void persistChanges() {
            this.scanner.setLevel(this.threshold);
            this.scanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)this.threshold));
            this.scanner.save();
        }

        public String getName() {
            return this.scanner.getName();
        }

        public Plugin.AlertThreshold getThreshold() {
            return this.threshold;
        }

        public void setThreshold(Plugin.AlertThreshold alertThreshold) {
            this.threshold = alertThreshold;
        }

        public String getQuality() {
            return Constant.messages.getString("ascan.policy.table.quality." + this.scanner.getStatus().name());
        }
    }
}

