/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.spider;

import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.Constant;

public class SpiderPanelTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6380136823410869457L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("spider.table.header.inScope"), Constant.messages.getString("spider.table.header.method"), Constant.messages.getString("spider.table.header.uri"), Constant.messages.getString("spider.table.header.flags")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;
    private List<SpiderScanResult> scanResults = new ArrayList<SpiderScanResult>();
    private static final ImageIcon skippedIcon = new ImageIcon(SpiderPanelTableModel.class.getResource("/resource/icon/16/149.png"));
    private static final ImageIcon notSkippedIcon = new ImageIcon(SpiderPanelTableModel.class.getResource("/resource/icon/16/152.png"));

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public int getRowCount() {
        return this.scanResults.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        SpiderScanResult spiderScanResult = this.scanResults.get(n);
        switch (n2) {
            case 0: {
                if (spiderScanResult.skipped) {
                    return skippedIcon;
                }
                return notSkippedIcon;
            }
            case 1: {
                return spiderScanResult.method;
            }
            case 2: {
                return spiderScanResult.uri;
            }
            case 3: {
                return spiderScanResult.flags;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllElements() {
        List<SpiderScanResult> list = this.scanResults;
        synchronized (list) {
            this.scanResults.clear();
            this.fireTableDataChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanResult(String string, String string2, String string3, boolean bl) {
        SpiderScanResult spiderScanResult = new SpiderScanResult(string, string2, string3, bl);
        List<SpiderScanResult> list = this.scanResults;
        synchronized (list) {
            this.scanResults.add(spiderScanResult);
            try {
                this.fireTableRowsInserted(this.scanResults.size() - 1, this.scanResults.size() - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removesScanResult(String string, String string2) {
        SpiderScanResult spiderScanResult = new SpiderScanResult(string, string2);
        List<SpiderScanResult> list = this.scanResults;
        synchronized (list) {
            int n = this.scanResults.indexOf(spiderScanResult);
            if (n >= 0) {
                this.scanResults.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return ImageIcon.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return null;
    }

    private static class SpiderScanResult {
        protected String uri;
        protected String method;
        protected String flags;
        protected boolean skipped;

        protected SpiderScanResult(String string, String string2) {
            this.uri = string;
            this.method = string2;
        }

        protected SpiderScanResult(String string, String string2, String string3, boolean bl) {
            this.uri = string;
            this.method = string2;
            this.flags = string3;
            this.skipped = bl;
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + (this.method == null ? 0 : this.method.hashCode());
            n = 31 * n + (this.uri == null ? 0 : this.uri.hashCode());
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            SpiderScanResult spiderScanResult = (SpiderScanResult)object;
            if (this.method == null ? spiderScanResult.method != null : !this.method.equals(spiderScanResult.method)) {
                return false;
            }
            return !(this.uri == null ? spiderScanResult.uri != null : !this.uri.equals(spiderScanResult.uri));
        }
    }
}

