/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.users;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.view.AbstractMultipleOptionsTableModel;

public class UsersTableModel
extends AbstractMultipleOptionsTableModel<User> {
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("users.table.header.enabled"), Constant.messages.getString("users.table.header.id"), Constant.messages.getString("users.table.header.name")};
    private static final long serialVersionUID = 4463944219657112162L;
    private List<User> users = new ArrayList<User>();

    public UsersTableModel(List<User> list) {
        this.users = new ArrayList<User>(list);
    }

    public UsersTableModel() {
        this.users = new ArrayList<User>();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public int getRowCount() {
        return this.users.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.users.get(n).isEnabled();
            }
            case 1: {
                return this.users.get(n).getId();
            }
            case 2: {
                return this.users.get(n).getName();
            }
        }
        return null;
    }

    @Override
    public List<User> getElements() {
        return this.users;
    }

    public List<User> getUsers() {
        return this.users;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void setUsers(List<User> list) {
        this.users = new ArrayList<User>(list);
        this.fireTableDataChanged();
    }

    public void removeAllUsers() {
        this.users = new ArrayList<User>();
        this.fireTableDataChanged();
    }

    public void addUser(User user) {
        this.users.add(user);
        this.fireTableRowsInserted(this.users.size() - 1, this.users.size() - 1);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return Integer.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int n) {
        return COLUMN_NAMES[n];
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 0 && object instanceof Boolean) {
            this.users.get(n).setEnabled((Boolean)object);
            this.fireTableCellUpdated(n, n2);
        }
    }
}

