/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.httputils;

import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.network.HttpMessage;

public class HtmlContext {
    public static final int IGNORE_PARENT = 1;
    public static final int IGNORE_TAG = 2;
    public static final int IGNORE_QUOTES = 4;
    public static final int IGNORE_IN_SCRIPT = 8;
    public static final int IGNORE_IN_URL = 16;
    public static final int IGNORE_WITH_SRC = 32;
    public static final int IGNORE_HTML_COMMENT = 64;
    private HttpMessage msg;
    private String target;
    private int start = 0;
    private int end = 0;
    private List<String> parentTags = new ArrayList<String>();
    private String tagAttribute = null;
    private boolean inScriptAttribute = false;
    private boolean inUrlAttribute = false;
    private boolean inTagWithSrc = false;
    private String surroundingQuote = "";
    private boolean htmlComment = false;

    public HtmlContext(HttpMessage httpMessage, String string, int n, int n2) {
        this.msg = httpMessage;
        this.target = string;
        this.start = n;
        this.end = n2;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int n) {
        this.end = n;
    }

    public HttpMessage getMsg() {
        return this.msg;
    }

    public String getTarget() {
        return this.target;
    }

    public List<String> getParentTags() {
        return this.parentTags;
    }

    public void setParentTags(List<String> list) {
        this.parentTags = list;
    }

    public String getSurroundingQuote() {
        return this.surroundingQuote;
    }

    public void setSurroundingQuote(String string) {
        this.surroundingQuote = string;
    }

    public String getTagAttribute() {
        return this.tagAttribute;
    }

    public void setTagAttribute(String string) {
        this.tagAttribute = string;
    }

    public void addParentTag(String string) {
        this.parentTags.add(0, string);
    }

    public String getParentTag() {
        if (this.parentTags.size() > 0) {
            return this.parentTags.get(this.parentTags.size() - 1);
        }
        return null;
    }

    public boolean isInScriptAttribute() {
        return this.inScriptAttribute;
    }

    public void setInScriptAttribute(boolean bl) {
        this.inScriptAttribute = bl;
    }

    public boolean isHtmlComment() {
        return this.htmlComment;
    }

    public void setHtmlComment(boolean bl) {
        this.htmlComment = bl;
    }

    public boolean isInUrlAttribute() {
        return this.inUrlAttribute;
    }

    public void setInUrlAttribute(boolean bl) {
        this.inUrlAttribute = bl;
    }

    public boolean isInTagWithSrc() {
        return this.inTagWithSrc;
    }

    public void setInTagWithSrc(boolean bl) {
        this.inTagWithSrc = bl;
    }

    public boolean matches(HtmlContext htmlContext, int n) {
        if (htmlContext == null) {
            return false;
        }
        if ((n ^ 2) > 0 && (this.tagAttribute != null ? !this.tagAttribute.equals(htmlContext.getTagAttribute()) : htmlContext.getTagAttribute() != null)) {
            return false;
        }
        if ((n ^ 4) > 0 && (this.surroundingQuote != null ? !this.surroundingQuote.equals(htmlContext.getSurroundingQuote()) : htmlContext.getSurroundingQuote() != null)) {
            return false;
        }
        if ((n ^ 1) > 0 && (this.getParentTag() != null ? !this.getParentTag().equals(htmlContext.getParentTag()) : htmlContext.getParentTag() != null)) {
            return false;
        }
        if ((n ^ 8) > 0 && this.inScriptAttribute != htmlContext.isInScriptAttribute()) {
            return false;
        }
        if ((n ^ 0x20) > 0 && this.inTagWithSrc != htmlContext.isInTagWithSrc()) {
            return false;
        }
        if ((n ^ 0x10) > 0 && this.inUrlAttribute != htmlContext.isInUrlAttribute()) {
            return false;
        }
        return (n ^ 0x40) <= 0 || this.htmlComment == htmlContext.isHtmlComment();
    }
}

